/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.compare;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.sirius.SiriusMergePolicy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.lib.IdGenerator;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.MultiplicityElement;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.communication.CommunicationPackage;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.Role;

public class CapellaMergePolicy
extends SiriusMergePolicy {
    protected static final Collection<EReference> MANDATORY_REFERENCES = Arrays.asList(ModellingcorePackage.eINSTANCE.getAbstractTrace_SourceElement(), ModellingcorePackage.eINSTANCE.getAbstractTrace_TargetElement(), CapellacorePackage.eINSTANCE.getInvolvement_Involved(), CapellacorePackage.eINSTANCE.getInvolvement_Involver(), CommunicationPackage.eINSTANCE.getCommunicationLink_ExchangeItem(), InteractionPackage.eINSTANCE.getSequenceMessage_SendingEnd(), InteractionPackage.eINSTANCE.getSequenceMessage_ReceivingEnd(), InteractionPackage.eINSTANCE.getSequenceMessage_ExchangedItems(), InteractionPackage.eINSTANCE.getEventReceiptOperation_Operation(), InteractionPackage.eINSTANCE.getEventSentOperation_Operation(), FaPackage.eINSTANCE.getComponentExchange_SourcePart(), FaPackage.eINSTANCE.getComponentExchange_SourcePort(), FaPackage.eINSTANCE.getComponentExchange_TargetPart(), FaPackage.eINSTANCE.getComponentExchange_TargetPort(), CsPackage.eINSTANCE.getExchangeItemAllocation_AllocatedItem(), CsPackage.eINSTANCE.getExchangeItemAllocation_AllocatingInterface(), CsPackage.eINSTANCE.getPhysicalLinkEnd_Part(), CsPackage.eINSTANCE.getPhysicalLinkEnd_Port(), CsPackage.eINSTANCE.getPhysicalLink_LinkEnds());

    protected void extendCapellaAssociationPropertyAdditionGroup(Set<EObject> group, EObject element, ITreeDataScope<EObject> scope) {
        if (element instanceof Association) {
            Association association = (Association)element;
            group.addAll((Collection<EObject>)association.getOwnedMembers());
            group.addAll((Collection<EObject>)association.getNavigableMembers());
        } else if (element instanceof Property) {
            NumericValue maxCard;
            NumericValue minCard;
            Property property = (Property)element;
            Association association = property.getAssociation();
            if (association != null) {
                group.add((EObject)association);
            }
            if ((minCard = property.getOwnedMinCard()) != null) {
                group.add((EObject)minCard);
            }
            if ((maxCard = property.getOwnedMaxCard()) != null) {
                group.add((EObject)maxCard);
            }
        }
    }

    protected void extendCapellaGraphicalContainmentAdditionGroup(Set<EObject> group, EObject element, ITreeDataScope<EObject> scope) {
        EObject container;
        if (element instanceof AbstractDNode && (container = element.eContainer()) instanceof AbstractDNode) {
            AbstractDNode node = (AbstractDNode)element;
            AbstractDNode containerNode = (AbstractDNode)container;
            EObject nodeTarget = node.getTarget();
            EObject containerTarget = containerNode.getTarget();
            EObject relation = this.getCapellaRelationBetween(containerTarget, nodeTarget);
            if (relation != null) {
                group.add(relation);
            }
        }
    }

    protected void extendCapellaMultiplicityAdditionGroup(Set<EObject> group, EObject element, ITreeDataScope<EObject> scope) {
        if (element instanceof MultiplicityElement) {
            NumericValue maxCard;
            MultiplicityElement multi = (MultiplicityElement)element;
            NumericValue minCard = multi.getOwnedMinCard();
            if (minCard != null) {
                group.add((EObject)minCard);
            }
            if ((maxCard = multi.getOwnedMaxCard()) != null) {
                group.add((EObject)maxCard);
            }
        }
    }

    protected void extendCapellaPartComponentAdditionGroup(Set<EObject> group, EObject element, ITreeDataScope<EObject> scope) {
        Component component;
        EList typed;
        if (element instanceof Part) {
            Part part = (Part)element;
            AbstractType type = part.getAbstractType();
            if (type instanceof Component) {
                group.add((EObject)type);
            }
        } else if (element instanceof Component && (typed = (component = (Component)element).getAbstractTypedElements()).size() == 1 && typed.get(0) instanceof Part) {
            group.addAll((Collection<EObject>)typed);
        }
    }

    public Set<EObject> getAdditionGroup(EObject element, ITreeDataScope<EObject> scope) {
        Set result = super.getAdditionGroup(element, scope);
        this.extendCapellaPartComponentAdditionGroup(result, element, scope);
        this.extendCapellaAssociationPropertyAdditionGroup(result, element, scope);
        this.extendCapellaGraphicalContainmentAdditionGroup(result, element, scope);
        this.extendCapellaMultiplicityAdditionGroup(result, element, scope);
        return result;
    }

    protected EObject getCapellaRelationBetween(EObject source, EObject target) {
        AbstractDeploymentLink result;
        block7: {
            AbstractType rawType;
            block9: {
                block8: {
                    result = null;
                    if (!(source instanceof Part) || !(target instanceof Part)) break block8;
                    for (AbstractDeploymentLink link : ((Part)target).getDeployingLinks()) {
                        if (link.getLocation() != source) continue;
                        result = link;
                        break block7;
                    }
                    break block7;
                }
                if (!(source instanceof Role) || !(target instanceof OperationalActivity)) break block9;
                OperationalActivity targetActivity = (OperationalActivity)target;
                for (ActivityAllocation link : targetActivity.getActivityAllocations()) {
                    if (link.getRole() != source) continue;
                    result = link;
                    break block7;
                }
                break block7;
            }
            if (!(target instanceof AbstractFunction)) break block7;
            AbstractFunction targetFunction = (AbstractFunction)target;
            AbstractFunctionalBlock sourceType = null;
            if (source instanceof AbstractFunctionalBlock) {
                sourceType = (AbstractFunctionalBlock)source;
            } else if (source instanceof AbstractTypedElement && (rawType = ((AbstractTypedElement)source).getAbstractType()) instanceof AbstractFunctionalBlock) {
                sourceType = (AbstractFunctionalBlock)rawType;
            }
            if (sourceType != null) {
                for (ComponentFunctionalAllocation link : targetFunction.getComponentFunctionalAllocations()) {
                    if (link.getBlock() != sourceType) continue;
                    result = link;
                    break;
                }
            }
        }
        return result;
    }

    public Object getNewIntrinsicID(EObject element, ITreeDataScope<EObject> scope) {
        Object result = element.eClass().getEIDAttribute() != null ? IdGenerator.createId() : super.getNewIntrinsicID((Object)element, scope);
        return result;
    }

    protected boolean isSingleMandatory(Object reference, ITreeDataScope<EObject> scope_p) {
        return super.isSingleMandatory(reference, scope_p) || MANDATORY_REFERENCES.contains(reference);
    }
}

