/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import org.eclipse.help.IIndexContribution;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.dynamic.DocumentWriter;
import org.eclipse.help.internal.index.Index;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class IndexServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Map<String, String> responseByLocale;
    private DocumentWriter writer;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/xml; charset=UTF-8");
        resp.getWriter().write(this.processRequest(req, resp));
    }

    protected String processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String response;
        BaseHelpSystem.checkMode();
        String locale = UrlUtil.getLocale(req, resp);
        req.setCharacterEncoding("UTF-8");
        if (this.responseByLocale == null) {
            this.responseByLocale = new WeakHashMap<String, String>();
        }
        if ((response = this.responseByLocale.get(locale)) == null) {
            IIndexContribution[] contributions = HelpPlugin.getIndexManager().getIndexContributions(locale);
            try {
                response = this.serialize(contributions, locale);
            }
            catch (TransformerException e) {
                throw new ServletException((Throwable)e);
            }
            this.responseByLocale.put(locale, response);
        }
        return response != null ? response : "";
    }

    public String serialize(IIndexContribution[] contributions, String locale) throws TransformerException {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<indexContributions>\n");
        if (this.writer == null) {
            this.writer = new DocumentWriter();
        }
        IIndexContribution[] iIndexContributionArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexContribution contrib = iIndexContributionArray[n2];
            buf.append("<indexContribution\n");
            buf.append("      id=\"" + contrib.getId() + '\"');
            buf.append("      locale=\"" + contrib.getLocale() + "\">\n");
            buf.append(this.writer.writeString((UAElement)((Index)contrib.getIndex()), false));
            buf.append("</indexContribution>\n");
            ++n2;
        }
        buf.append("</indexContributions>\n");
        return buf.toString();
    }
}

