/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.resources;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.BundleContext;
import org.polarsys.capella.common.ui.services.AbstractUIActivator;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortKind;
import org.polarsys.capella.core.data.fa.FunctionKind;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.OrientationPortKind;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;

public class CapellaUIResourcesPlugin
extends AbstractUIActivator {
    public static final String PLUGIN_ID = "org.polarsys.capella.core.ui.resources";
    private static CapellaUIResourcesPlugin __plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        __plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        __plugin = null;
        super.stop(context);
    }

    public static CapellaUIResourcesPlugin getDefault() {
        return __plugin;
    }

    public ImageDescriptor getPNGImage(EClass eclass_p) {
        String key = "full/png/" + eclass_p.getName() + ".png";
        return this.getMetaClassImageDescriptor(key);
    }

    public ImageDescriptor getPNGImage(EObject eobject_p) {
        String key = "full/png/" + this.getCustomizedImageName(eobject_p) + ".png";
        return this.getMetaClassImageDescriptor(key);
    }

    public ImageDescriptor getSVGImage(EClass eclass_p) {
        String key = "full/svg/" + eclass_p.getName() + ".svg";
        return this.getMetaClassImageDescriptor(key);
    }

    private ImageDescriptor getMetaClassImageDescriptor(String metaClassImageDescriptorKey_p) {
        ImageDescriptor result = null;
        if (this.getImageURL(metaClassImageDescriptorKey_p) != null) {
            result = super.getImageDescriptor(metaClassImageDescriptorKey_p);
        }
        return result;
    }

    public String getCustomizedImageName(EObject eobject) {
        String eClassName = eobject.eClass().getName();
        if (eobject instanceof Part) {
            eClassName = "Part";
        } else if (eobject instanceof CommunicationLink) {
            CommunicationLinkKind kind = ((CommunicationLink)eobject).getKind();
            if (CommunicationLinkKind.PRODUCE.equals((Object)kind)) {
                eClassName = "CommunicationLinkProduce";
            } else if (CommunicationLinkKind.CONSUME.equals((Object)kind)) {
                eClassName = "CommunicationLinkConsume";
            } else if (CommunicationLinkKind.SEND.equals((Object)kind)) {
                eClassName = "CommunicationLinkSend";
            } else if (CommunicationLinkKind.RECEIVE.equals((Object)kind)) {
                eClassName = "CommunicationLinkReceive";
            } else if (CommunicationLinkKind.CALL.equals((Object)kind)) {
                eClassName = "CommunicationLinkCall";
            } else if (CommunicationLinkKind.EXECUTE.equals((Object)kind)) {
                eClassName = "CommunicationLinkExecute";
            } else if (CommunicationLinkKind.WRITE.equals((Object)kind)) {
                eClassName = "CommunicationLinkWrite";
            } else if (CommunicationLinkKind.ACCESS.equals((Object)kind)) {
                eClassName = "CommunicationLinkAccess";
            } else if (CommunicationLinkKind.ACQUIRE.equals((Object)kind)) {
                eClassName = "CommunicationLinkAcquire";
            } else if (CommunicationLinkKind.TRANSMIT.equals((Object)kind)) {
                eClassName = "CommunicationLinkTransmit";
            }
        } else if (eobject instanceof ExchangeItem) {
            if (((ExchangeItem)eobject).getExchangeMechanism() == ExchangeMechanism.EVENT) {
                eClassName = "ExchangeItemEvent";
            } else if (ExchangeMechanism.FLOW.equals((Object)((ExchangeItem)eobject).getExchangeMechanism())) {
                eClassName = "ExchangeItemFlow";
            } else if (ExchangeMechanism.OPERATION.equals((Object)((ExchangeItem)eobject).getExchangeMechanism())) {
                eClassName = "ExchangeItemOperation";
            } else if (ExchangeMechanism.SHARED_DATA.equals((Object)((ExchangeItem)eobject).getExchangeMechanism())) {
                eClassName = "ExchangeItemData";
            }
        } else if (eobject instanceof FunctionalExchange) {
            if (((FunctionalExchange)eobject).getSource() instanceof OperationalActivity && ((FunctionalExchange)eobject).getTarget() instanceof OperationalActivity) {
                eClassName = "FunctionalExchange_OA";
            }
        } else if (eobject instanceof ComponentPort) {
            ComponentPortKind kind = ((ComponentPort)eobject).getKind();
            if (ComponentPortKind.STANDARD.equals((Object)kind)) {
                eClassName = "StandardPort";
            } else if (ComponentPortKind.FLOW.equals((Object)kind)) {
                eClassName = "FlowPort";
                if (OrientationPortKind.IN.equals((Object)((ComponentPort)eobject).getOrientation())) {
                    eClassName = "InFlowPort";
                } else if (OrientationPortKind.OUT.equals((Object)((ComponentPort)eobject).getOrientation())) {
                    eClassName = "OutFlowPort";
                }
            }
        } else if (eobject instanceof AbstractFunction) {
            FunctionKind kind = ((AbstractFunction)eobject).getKind();
            if (FunctionKind.DUPLICATE.equals((Object)kind)) {
                eClassName = "FunctionKind_Duplicate";
            } else if (FunctionKind.GATHER.equals((Object)kind)) {
                eClassName = "FunctionKind_Gather";
            } else if (FunctionKind.ROUTE.equals((Object)kind)) {
                eClassName = "FunctionKind_Route";
            } else if (FunctionKind.SELECT.equals((Object)kind)) {
                eClassName = "FunctionKind_Select";
            } else if (FunctionKind.SPLIT.equals((Object)kind)) {
                eClassName = "FunctionKind_Split";
            }
        } else if (eobject instanceof Component) {
            Component component = (Component)eobject;
            if (component.isActor() && component.isHuman()) {
                eClassName = "ActorHuman";
            } else if (component instanceof Entity && component.isActor() && !component.isHuman()) {
                eClassName = "OperationalActor";
            } else if (component instanceof SystemComponent && component.isActor() && !component.isHuman()) {
                eClassName = "SystemActor";
            } else if (component instanceof LogicalComponent) {
                if (!component.isActor() && component.isHuman()) {
                    eClassName = "LogicalComponentHuman";
                } else if (component.isActor() && !component.isHuman()) {
                    eClassName = "LogicalActor";
                }
            } else if (component instanceof PhysicalComponent) {
                if (component.isActor() && !component.isHuman()) {
                    eClassName = "PhysicalActor";
                } else {
                    PhysicalComponentNature nature = ((PhysicalComponent)component).getNature();
                    if (nature == PhysicalComponentNature.NODE) {
                        eClassName = component.isHuman() ? "PhysicalComponentHumanNode" : "PhysicalComponentNode";
                    } else if (nature == PhysicalComponentNature.BEHAVIOR) {
                        eClassName = component.isHuman() ? "PhysicalComponentHumanBehavior" : "PhysicalComponentBehavior";
                    } else if (component.isHuman()) {
                        eClassName = "PhysicalComponentHumanUnset";
                    }
                }
            }
        }
        return eClassName;
    }
}

