/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.accelerators;

import java.net.URL;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellamodeller.provider.CapellaModellerEditPlugin;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.core.data.oa.OperationalProcess;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.FunctionalChainServices;

public class AcceleratorOnSequenceLinkHandler
extends AbstractHandler
implements IElementUpdater {
    FunctionalChainServices functionalChainServices = FunctionalChainServices.getFunctionalChainServices();

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        final DEdge selectedSeqLinkEdge = this.getDiagramElementFromSelection(selection);
        if (selectedSeqLinkEdge != null) {
            ExecutionManager manager = TransactionHelper.getExecutionManager((EObject)selectedSeqLinkEdge);
            manager.execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    AcceleratorOnSequenceLinkHandler.this.functionalChainServices.accelerateOnSequenceLinkEdge(selectedSeqLinkEdge);
                    IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
                    DiagramServices.getDiagramServices().refreshRepresentationOfEditor(activeEditor);
                }
            });
        }
        return null;
    }

    private DEdge getDiagramElementFromSelection(ISelection selection) {
        Object selectedElement;
        StructuredSelection structuredSelection;
        if (selection instanceof StructuredSelection && (structuredSelection = (StructuredSelection)selection).size() == 1 && (selectedElement = structuredSelection.getFirstElement()) instanceof IAdaptable) {
            return (DEdge)((IAdaptable)selectedElement).getAdapter(DEdge.class);
        }
        return null;
    }

    private DDiagramElement getDiagramElementFromActiveSelection() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        ISelection selection = activePage.getSelection();
        return this.getDiagramElementFromSelection(selection);
    }

    public boolean isEnabled() {
        DDiagramElement diagramElement = this.getDiagramElementFromActiveSelection();
        return diagramElement instanceof DEdge && diagramElement.getTarget() instanceof SequenceLink;
    }

    public void updateElement(UIElement element, Map parameters) {
        DDiagramElement diagramElement = this.getDiagramElementFromActiveSelection();
        if (diagramElement instanceof DEdge && diagramElement.getTarget() instanceof SequenceLink) {
            SequenceLink seqLink = (SequenceLink)diagramElement.getTarget();
            EObject fc = seqLink.eContainer();
            if (fc instanceof OperationalProcess) {
                element.setText("Create new Interaction");
                URL url = (URL)CapellaModellerEditPlugin.INSTANCE.getImage("full/obj16/FunctionalChainInvolvementLinkOA_ToExchange");
                element.setIcon(ImageDescriptor.createFromURL((URL)url));
            } else if (fc instanceof FunctionalChain) {
                element.setText("Create new Exchange");
                URL url = (URL)CapellaModellerEditPlugin.INSTANCE.getImage("full/obj16/FunctionalChainInvolvementLink_ToExchange");
                element.setIcon(ImageDescriptor.createFromURL((URL)url));
            }
        }
    }
}

