/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.extensions.INodeMappingExt;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.NodeMappingHelper;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityInvolvement;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.AbstractCacheAwareRefreshExtension;

public class ContextualCapabilityRefreshExtension
extends AbstractCacheAwareRefreshExtension {
    @Override
    public void beforeRefresh(DDiagram diagram) {
        DNode container;
        super.beforeRefresh(diagram);
        if (((DSemanticDecorator)diagram).getTarget() == null) {
            return;
        }
        LinkedList<Object> actors = new LinkedList<Object>();
        HashSet<Capability> capabilities = new HashSet<Capability>();
        LinkedList<Mission> missions = new LinkedList<Mission>();
        NodeMapping actorNodeMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "ActorNode3");
        NodeMapping capaNodeMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "Capability3");
        NodeMapping missionNodeMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "MissionNode3");
        Capability capa = (Capability)((DSemanticDecorator)diagram).getTarget();
        for (CapabilityInvolvement inv : capa.getOwnedCapabilityInvolvements()) {
            SystemComponent systemComponent = inv.getSystemComponent();
            if (!ComponentExt.isActor((Component)systemComponent)) continue;
            actors.add(systemComponent);
            for (GeneralizableElement elt : systemComponent.getSuper()) {
                if (!ComponentExt.isActor((EObject)elt)) continue;
                actors.add((Component)elt);
            }
        }
        capabilities.add(capa);
        capabilities.addAll((Collection<Capability>)capa.getSuper());
        capabilities.addAll((Collection<Capability>)capa.getSub());
        capabilities.addAll((Collection<Capability>)capa.getExtendedAbstractCapabilities());
        capabilities.addAll((Collection<Capability>)capa.getIncludedAbstractCapabilities());
        missions.addAll((Collection<Mission>)CapellaServices.getService().getAllPurposeMission(capa));
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)capa);
        NodeMappingHelper nodeMappingHelper = new NodeMappingHelper(interpreter);
        for (Component component : actors) {
            if (DiagramServices.getDiagramServices().isOnDiagram(diagram, (EObject)component)) continue;
            container = nodeMappingHelper.createNode((INodeMappingExt)actorNodeMapping, (EObject)component, (EObject)capa, diagram);
            diagram.getOwnedDiagramElements().add((Object)container);
        }
        for (AbstractCapability abstractCapability : capabilities) {
            if (DiagramServices.getDiagramServices().isOnDiagram(diagram, (EObject)abstractCapability)) continue;
            container = nodeMappingHelper.createNode((INodeMappingExt)capaNodeMapping, (EObject)abstractCapability, (EObject)capa, diagram);
            diagram.getOwnedDiagramElements().add((Object)container);
        }
        for (Mission mission : missions) {
            if (DiagramServices.getDiagramServices().isOnDiagram(diagram, (EObject)mission)) continue;
            container = nodeMappingHelper.createNode((INodeMappingExt)missionNodeMapping, (EObject)mission, (EObject)capa, diagram);
            diagram.getOwnedDiagramElements().add((Object)container);
        }
    }
}

