/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.modellingcore.IState;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.Pseudostate;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.ModeStateMachineServices;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideMSMStateMode
extends AbstractShowHide {
    public static final String CONTEXTUAL_CONTAINER = "CONTEXTUAL_CONTAINER";
    public static final String CONTEXTUAL_CONTAINER_VIEW = "CONTEXTUAL_CONTAINER_VIEW";
    private DDiagramContents content;

    public ShowHideMSMStateMode(DDiagramContents contentp) {
        super(contentp);
        this.content = contentp;
    }

    @Override
    public HashMapSet<String, EObject> getRelatedObjects(EObject semantic, AbstractShowHide.DiagramContext context) {
        AbstractShowHide.ContextItemElement lastContext = context.getLast();
        HashMapSet<String, EObject> value = super.getRelatedObjects(semantic, context);
        EObject lastCtxValue = lastContext.getValue();
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (lastCtxValue instanceof IState) {
            List referencers = EObjectExt.getReferencers((EObject)lastCtxValue, (EReference)CapellacommonPackage.Literals.REGION__INVOLVED_STATES);
            for (EObject s : referencers) {
                result.add(s.eContainer());
            }
        }
        value.putAll("container", result);
        return value;
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple, AbstractShowHide.DiagramContext context) {
        AbstractShowHide.ContextItemElement item;
        EObject semantic = originCouple.getValue();
        if (semantic != (item = context.getLast("root")).getValue()) {
            return false;
        }
        return semantic instanceof IState;
    }

    @Override
    protected boolean mustHide(DDiagramElement view, AbstractShowHide.DiagramContext context) {
        return true;
    }

    @Override
    protected boolean isValidSemanticView(EObject semantic, DSemanticDecorator semanticView, AbstractShowHide.DiagramContext context) {
        AbstractShowHide.ContextItemElement element = context.getLast("root");
        if (element == null) {
            return true;
        }
        if (semantic != element.getValue() && semanticView instanceof DDiagramElement) {
            AbstractShowHide.ContextItemVariable clickedStateVar = context.getLastVariable(CONTEXTUAL_CONTAINER_VIEW);
            return semanticView == clickedStateVar.getValue() || EcoreUtil.isAncestor((EObject)((EObject)clickedStateVar.getValue()), (EObject)semanticView) || EcoreUtil.isAncestor((EObject)semanticView, (EObject)((EObject)clickedStateVar.getValue()));
        }
        return true;
    }

    @Override
    public DiagramElementMapping getMapping(EObject semantic, AbstractShowHide.DiagramContext context, HashMapSet<String, DSemanticDecorator> relatedViews) {
        DiagramElementMapping mapping = super.getMapping(semantic, context, relatedViews);
        Object containerViews = relatedViews.get("container");
        AbstractShowHide.ContextItemVariable clickedStateVar = context.getLastVariable(CONTEXTUAL_CONTAINER_VIEW);
        EObject eContainer = semantic.eContainer();
        EObject parent = eContainer.eContainer();
        if (!containerViews.isEmpty()) {
            parent = ((DSemanticDecorator)containerViews.iterator().next()).getTarget();
        }
        if (semantic instanceof State) {
            mapping = ModeStateMachineServices.getService().getMappingMSMStateMode((State)semantic, this.getContent().getDDiagram());
        }
        if (semantic instanceof Pseudostate) {
            mapping = ModeStateMachineServices.getService().getMappingMSMPseudostate((Pseudostate)semantic, this.getContent().getDDiagram());
        }
        return mapping;
    }

    @Override
    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic, AbstractShowHide.DiagramContext context, Collection<DSemanticDecorator> targetViews) {
        if (semantic instanceof IState) {
            return Collections.singletonList((DSemanticDecorator)this.getContent().getDDiagram());
        }
        return super.retrieveDefaultContainer(semantic, context, targetViews);
    }
}

