/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.massactions.core.edit.control.single;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.polarsys.capella.common.ui.massactions.core.activator.MECoreCapellaActivator;
import org.polarsys.capella.common.ui.massactions.core.shared.helper.CommonElementsHelper;
import org.polarsys.capella.common.ui.massactions.core.shared.helper.container.CommonBQInput;
import org.polarsys.capella.common.ui.massactions.core.shared.helper.container.CommonBQResult;
import org.polarsys.capella.common.ui.massactions.core.shared.messages.Messages;
import org.polarsys.capella.core.ui.properties.helpers.DialogHelper;
import org.polarsys.kitalpha.massactions.core.control.AbstractMAPrimitiveCellControl;
import org.polarsys.kitalpha.massactions.core.helper.EObjectImageProvider;

public class SingleRefCellControl
extends AbstractMAPrimitiveCellControl {
    private EObject canonicalValue;
    private List<CommonBQInput> commonBQInputs;
    private Text editorValueText;
    private ToolItem editorIconToolItem;
    private final SelectionAdapter browseSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            CommonBQResult commonBusinessQueryResult;
            List<EObject> commonAvailableElements;
            EObject selectedElement;
            if (SingleRefCellControl.this.commonBQInputs != null && (selectedElement = DialogHelper.openSimpleSelectionDialog((Control)SingleRefCellControl.this, commonAvailableElements = (commonBusinessQueryResult = CommonElementsHelper.getAllCommonBusinessQueryResults(SingleRefCellControl.this.commonBQInputs)).getCommonAvailableElements())) != null) {
                SingleRefCellControl.this.setCanonicalValue(selectedElement);
            }
        }
    };

    public SingleRefCellControl(Composite parent, int style, IDisplayConverter displayConverter, Map<String, EStructuralFeature> featureMap) {
        super(parent, style, displayConverter, featureMap);
        this.initialize();
    }

    protected void initialize() {
        GridData gridData = new GridData(4, 4, true, true);
        this.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        ToolBar iconToolBar = new ToolBar((Composite)this, 256);
        this.editorIconToolItem = new ToolItem(iconToolBar, 32);
        this.editorIconToolItem.setEnabled(false);
        this.editorValueText = new Text((Composite)this, 4);
        this.editorValueText.setEditable(false);
        this.editorValueText.setCursor(Display.getCurrent().getSystemCursor(0));
        this.editorValueText.setText(Messages.NO_COMMON_VALUE_TEXT);
        this.editorValueText.setLayoutData((Object)new GridData(4, 4, true, true));
        ToolBar browseToolBar = new ToolBar((Composite)this, 256);
        ToolItem browse = new ToolItem(browseToolBar, 8);
        browse.setToolTipText(Messages.ELEMENT_SELECTION_TOOLTIP_TEXT);
        Image browseImage = MECoreCapellaActivator.getDefault().getImageRegistry().get("IMAGE_BROWSE");
        browse.setImage(browseImage);
        browse.addSelectionListener((SelectionListener)this.browseSelectionAdapter);
    }

    public void setSelectedRowObjects(List<EObject> selectedRowObjects) {
        super.setSelectedRowObjects(selectedRowObjects);
        this.commonBQInputs = selectedRowObjects.stream().map(rowObject -> new CommonBQInput((EObject)rowObject, (EStructuralFeature)this.featureMap.get(rowObject.eClass().getName()))).collect(Collectors.toList());
    }

    public void setEditorValue(Object editorValue) {
        if (editorValue instanceof String) {
            this.editorValueText.setText((String)editorValue);
        }
    }

    public Object getEditorValue() {
        EObject currentCanonicalValue = this.getCanonicalValue();
        return this.getDisplayConverterValue(currentCanonicalValue);
    }

    public EObject getCanonicalValue() {
        return this.canonicalValue;
    }

    public void setCanonicalValue(Object value) {
        if (value instanceof EObject) {
            this.canonicalValue = (EObject)value;
            Object editorValue = this.getDisplayConverterValue(this.canonicalValue);
            this.setEditorValue(editorValue);
            Image image = EObjectImageProvider.getInstance().getImage((Object)this.canonicalValue);
            this.editorIconToolItem.setDisabledImage(image);
            this.editorIconToolItem.setImage(image);
        }
    }
}

