/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.dialect.common.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionChangeDescription;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.synchronizer.ChildCreationSupport;
import org.eclipse.sirius.synchronizer.Mapping;
import org.eclipse.sirius.synchronizer.OutputDescriptor;
import org.eclipse.sirius.synchronizer.RefreshPlan;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.AbstractCreatedDTreeItemContainer;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.OutputTreeItemDescriptor;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.RTreeItemMapping;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeItemContainerChildSupport;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeRefreshContext;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.business.internal.refresh.DTreeElementSynchronizerSpec;
import org.eclipse.sirius.tree.tools.internal.Messages;

class CreatedTreeItem
extends AbstractCreatedDTreeItemContainer {
    private DTreeItem tItem;
    private OutputTreeItemDescriptor descriptor;
    private int newIndex;
    private Option<Mapping> newMapping = Options.newNone();

    CreatedTreeItem(GlobalContext ctx, DTreeItem tItem, OutputTreeItemDescriptor descriptor) {
        super(ctx);
        this.tItem = tItem;
        this.descriptor = descriptor;
        this.newIndex = descriptor.getIndex();
    }

    public OutputTreeItemDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setNewIndex(int nextIndex) {
        this.newIndex = nextIndex;
    }

    public int getNewIndex() {
        return this.newIndex;
    }

    public EObject getCreatedElement() {
        return this.tItem;
    }

    public void updateMapping() {
        if (!this.newMapping.some()) {
            throw new RuntimeException(Messages.DTreeRefresh_noMapping);
        }
        this.tItem.setActualMapping(((RTreeItemMapping)this.newMapping.get()).getDescription());
    }

    public void refresh() {
        DTreeElementSynchronizerSpec sync = new DTreeElementSynchronizerSpec(this.getGlobalContext().getInterpreter(), this.getGlobalContext().getModelAccessor());
        sync.refresh(this.tItem);
    }

    public void setNewMapping(Mapping map) {
        this.newMapping = Options.newSome((Object)map);
    }

    public Option<? extends ChildCreationSupport> getChildSupport() {
        return Options.newSome((Object)new TreeItemContainerChildSupport(this.getGlobalContext(), this.tItem));
    }

    public boolean synchronizeChildren(RefreshPlan refreshPlan) {
        boolean synchronizeChildren = this.tItem.isExpanded();
        if (!synchronizeChildren && !refreshPlan.getDescriptorsToCreate().isEmpty() && this.willBeExpandedOnSelection(refreshPlan)) {
            this.tItem.setExpanded(true);
            synchronizeChildren = true;
        }
        return synchronizeChildren;
    }

    private boolean willBeExpandedOnSelection(RefreshPlan refreshPlan) {
        Collection<EObject> createdObjects = CreatedTreeItem.getCreatedObjects(this);
        for (OutputDescriptor descriptorToCreate : refreshPlan.getDescriptorsToCreate()) {
            if (!EcoreUtil.isAncestor(createdObjects, (EObject)descriptorToCreate.getSourceElement())) continue;
            return true;
        }
        return false;
    }

    private static Collection<EObject> getCreatedObjects(CreatedTreeItem item) {
        InternalTransaction transaction;
        TransactionChangeDescription changeDescription;
        GlobalContext ctx = item.getGlobalContext();
        if (ctx instanceof TreeRefreshContext) {
            return ((TreeRefreshContext)ctx).getCreatedObjects();
        }
        EList result = Collections.emptySet();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)item.tItem);
        if (domain instanceof InternalTransactionalEditingDomain && (changeDescription = (transaction = ((InternalTransactionalEditingDomain)domain).getActiveTransaction().getRoot()).getChangeDescription()) != null) {
            result = changeDescription.getObjectsToDetach();
        }
        return result;
    }

    public List<Mapping> getChildMappings() {
        return this.getDescriptor().getMapping().getChildMappings();
    }
}

