/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.generic.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergeSelector;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.impl.policies.DefaultMatchPolicy;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.structures.common.FHashMap;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.ecore.EObject;

public class TemplatePatternComparison
extends EComparisonImpl {
    private final TemplatePattern _pattern;
    private final EMap<EObject, IMatch<EObject>> _updatedMatches;

    public TemplatePatternComparison(TemplatePattern pattern_p, IEditableModelScope patternScope_p, IEditableModelScope modelScope_p) {
        super((IEditableTreeDataScope)modelScope_p, (IEditableTreeDataScope)patternScope_p);
        this._pattern = pattern_p;
        this._updatedMatches = new FHashMap();
    }

    protected void collectUpdatedMatches() {
        for (IMatch match : this.getMapping().getCompletedMatches(TemplatePatternComparison.getEvolvingRole())) {
            this._updatedMatches.put((Object)((EObject)match.get(TemplatePatternComparison.getEvolvingRole())), (Object)match);
        }
        for (IMatch match : this.getMapping().getCompletedMatches(TemplatePatternComparison.getEvolvingRole().opposite())) {
            this._updatedMatches.put((Object)((EObject)match.get(TemplatePatternComparison.getEvolvingRole())), (Object)match);
        }
    }

    private static final Role getEvolvingRole() {
        return TemplatePatternComparison.getPatternRole().opposite();
    }

    public Collection<IMatch<EObject>> getLastUpdatedMatches() {
        FOrderedSet result = new FOrderedSet();
        result.addAll(this.getMapping().getCompletedMatches(TemplatePatternComparison.getPatternRole()));
        result.addAll(this.getMapping().getCompletedMatches(TemplatePatternComparison.getPatternRole().opposite()));
        return Collections.unmodifiableCollection(result);
    }

    public TemplatePattern getPattern() {
        return this._pattern;
    }

    public static Role getPatternRole() {
        return Role.REFERENCE;
    }

    public Collection<IMatch<EObject>> getUpdatedMatches() {
        return this._updatedMatches.values();
    }

    public IStatus update(final LinkedHashMap<EObject, EObject> noIdsMap_p) {
        final EMap existingMapping = this.getMapping().toMap(TemplatePatternComparison.getEvolvingRole().opposite(), TemplatePatternComparison.getEvolvingRole());
        final IMatchPolicy previousMatchPolicy = this.getLastMatchPolicy();
        IDiffPolicy previousDiffPolicy = this.getLastDiffPolicy();
        IMergePolicy previousMergePolicy = this.getLastMergePolicy();
        this.clear();
        DefaultMatchPolicy wrappingMatchPolicy = new DefaultMatchPolicy(){

            public Object getMatchID(EObject element_p, ITreeDataScope<EObject> scope_p) {
                Object result;
                EObject idProvider = element_p;
                EObject existingCounterPart = (EObject)existingMapping.get((Object)element_p);
                if (existingCounterPart != null) {
                    idProvider = existingCounterPart;
                }
                if ((result = previousMatchPolicy.getMatchID((Object)idProvider, scope_p)) == null && noIdsMap_p != null) {
                    existingCounterPart = (EObject)noIdsMap_p.get(element_p);
                    result = previousMatchPolicy.getMatchID((Object)existingCounterPart, scope_p);
                }
                return result;
            }
        };
        IStatus result = this.compute((IMatchPolicy)wrappingMatchPolicy, previousDiffPolicy, previousMergePolicy, null);
        return result;
    }

    public Collection<IDifference<EObject>> merge(Collection<? extends IDifference<EObject>> differences_p, Role destination_p, boolean updateReferences_p, IProgressMonitor monitor_p) {
        Collection result = super.merge(differences_p, destination_p, updateReferences_p, monitor_p);
        this.collectUpdatedMatches();
        return result;
    }

    public Collection<IDifference<EObject>> merge(IMergeSelector<EObject> merger_p, boolean updateReferences_p, IProgressMonitor monitor_p) {
        Collection result = super.merge(merger_p, updateReferences_p, monitor_p);
        this.collectUpdatedMatches();
        return result;
    }
}

