/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.service;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.polarsys.capella.core.commands.preferences.service.IFieldEditorPropertyPreferencePage;
import org.polarsys.capella.core.commands.preferences.service.PropertyStore;
import org.polarsys.capella.core.preferences.Activator;

public abstract class FieldEditorPropertyPreferencePage
extends FieldEditorPreferencePage
implements IFieldEditorPropertyPreferencePage,
IWorkbenchPropertyPage,
IWorkbenchPreferencePage {
    private List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private IAdaptable element;

    public FieldEditorPropertyPreferencePage(int style) {
        super(style);
    }

    public FieldEditorPropertyPreferencePage(String title, int style) {
        super(title, style);
    }

    public FieldEditorPropertyPreferencePage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public boolean isPropertyPage() {
        return this.getElement() instanceof IResource;
    }

    protected void addField(FieldEditor editor) {
        this.editors.add(editor);
        super.addField(editor);
    }

    public void createControl(Composite parent) {
        if (this.isPropertyPage()) {
            PropertyStore store = new PropertyStore((IResource)this.getElement(), Activator.getDefault().getPreferenceStore());
            this.setPreferenceStore((IPreferenceStore)store);
        } else {
            ScopedPreferenceStore store = (ScopedPreferenceStore)this.doGetPreferenceStore();
            this.setPreferenceStore((IPreferenceStore)store);
        }
        super.createControl(parent);
    }

    public void dispose() {
        IPreferenceStore store;
        super.dispose();
        if (this.isPropertyPage() && (store = this.getPreferenceStore()) instanceof PropertyStore) {
            ((PropertyStore)store).dispose();
        }
    }

    public void setPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        for (FieldEditor editor : this.editors) {
            editor.setPreferenceStore(store);
        }
    }

    protected void updateFieldEditors(boolean enabled) {
        Composite parent = this.getFieldEditorParent();
        for (FieldEditor editor : this.editors) {
            editor.setEnabled(enabled, parent);
        }
    }

    public boolean performCancel() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store instanceof PropertyStore) {
            ((PropertyStore)store).setCanceled(true);
        }
        return true;
    }

    public void init(IWorkbench workbench) {
    }
}

