/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.preferences.transferer;

import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.preferences.PreferenceTransferElement;
import org.eclipse.ui.internal.wizards.preferences.WizardPreferencesExportPage1;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.preferences.transferer.PreferenceProjectSelectionDialog;
import org.polarsys.capella.core.preferences.transferer.PreferencesProjectFilter;

public class WizardPreferencesTransfererExportPage
extends WizardPreferencesExportPage1 {
    private static final String CONFIGURABLE_PROJECT_SELECTION_TITLE = "Project Selection";
    private static final String CONFIGURABLE_PROJECT_SELECTION_MESSAGE = "Select the project destination form the tree :";
    private static final String CAPELLA_PERSPECTIVE = "capella.sirius.perspective";
    private Button destinationBrowseButton;
    private Button destinationExplorerBrowseButton;

    protected void createDestinationGroup(Composite parent) {
        String activePerspectiveId = PreferencesHelper.getActivePerpectiveId();
        if (CAPELLA_PERSPECTIVE.equals(activePerspectiveId)) {
            this.createCustomDestinationGroup(parent);
        } else {
            super.createDestinationGroup(parent);
        }
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.destinationBrowseButton) {
            this.handleProjectSelectionButtonPressed();
        } else if (source == this.destinationExplorerBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        }
        this.updatePageCompletion();
    }

    protected void createCustomDestinationGroup(Composite parent) {
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        Label dest = new Label(destinationSelectionGroup, 0);
        dest.setText(this.getDestinationLabel());
        this.destinationNameField = new Combo(destinationSelectionGroup, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.destinationBrowseButton.setText("Workspace...");
        this.setButtonLayoutData(this.destinationBrowseButton);
        this.destinationBrowseButton.setToolTipText("B&rowse Workspace ...");
        this.destinationBrowseButton.addListener(13, (Listener)this);
        this.destinationExplorerBrowseButton = new Button(destinationSelectionGroup, 8);
        this.destinationExplorerBrowseButton.setText("File System...");
        this.setButtonLayoutData(this.destinationExplorerBrowseButton);
        this.destinationExplorerBrowseButton.addListener(13, (Listener)this);
        this.destinationExplorerBrowseButton.setToolTipText("B&rowse File System...");
        new Label(parent, 0);
    }

    protected PreferenceTransferElement[] getTransfers() {
        PreferenceTransferElement[] parents = super.getTransfers();
        String activePerspectiveId = PreferencesHelper.getActivePerpectiveId();
        if (CAPELLA_PERSPECTIVE.equals(activePerspectiveId)) {
            PreferenceTransferElement[] transfers = parents != null ? parents : new PreferenceTransferElement[]{};
            ArrayList<PreferenceTransferElement> capellaTransfers = new ArrayList<PreferenceTransferElement>();
            PreferenceTransferElement[] preferenceTransferElementArray = transfers;
            int n = transfers.length;
            int n2 = 0;
            while (n2 < n) {
                PreferenceTransferElement currentPreferenceTransferElement = preferenceTransferElementArray[n2];
                if (currentPreferenceTransferElement.getID().contains("capella")) {
                    capellaTransfers.add(currentPreferenceTransferElement);
                }
                ++n2;
            }
            return capellaTransfers.toArray(new PreferenceTransferElement[0]);
        }
        return parents;
    }

    protected void handleProjectSelectionButtonPressed() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        PreferenceProjectSelectionDialog dialog = new PreferenceProjectSelectionDialog(this, window.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle(CONFIGURABLE_PROJECT_SELECTION_TITLE);
        dialog.setMessage(CONFIGURABLE_PROJECT_SELECTION_MESSAGE);
        dialog.setInput(ResourcesPlugin.getWorkspace().getRoot());
        dialog.addFilter(new PreferencesProjectFilter());
        dialog.open();
    }

    protected void addDestinationItem(String value) {
        super.addDestinationItem(value);
        this.setDestinationValue(value);
        this.updatePageCompletion();
    }
}

