/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.endo;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.diffmerge.structures.IPropertyValue;
import org.eclipse.emf.diffmerge.structures.PropertyValue;
import org.eclipse.emf.diffmerge.structures.binary.IRangedBinaryRelation;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.diffmerge.structures.endo.BreadthFirstIterator;
import org.eclipse.emf.diffmerge.structures.endo.EditableEndorelation;
import org.eclipse.emf.diffmerge.structures.endo.ICachingEndorelation;
import org.eclipse.emf.diffmerge.structures.endo.IEndorelation;
import org.eclipse.emf.diffmerge.structures.endo.IGraphIterator;
import org.eclipse.emf.diffmerge.structures.endo.IRangedEndorelation;
import org.eclipse.emf.diffmerge.structures.endo.RecursivelyDefinedEndorelation;

public class CachingEndorelation<T>
extends RecursivelyDefinedEndorelation<T>
implements ICachingEndorelation<T> {
    private IGraphIterator<T> _explorationIterator;
    private final IRangedEndorelation.Editable<T> _exploredSubset;
    protected final Set<T> _coveredElements;

    public CachingEndorelation(Collection<? extends T> origins_p, IEndorelation<T> rule_p) {
        this(origins_p, rule_p, false);
    }

    public CachingEndorelation(Collection<? extends T> origins_p, IEndorelation<T> rule_p, boolean noMultipleInverseOrCycles_p) {
        super(origins_p, rule_p, noMultipleInverseOrCycles_p);
        this.setExplorationIterator(this.newExplorationIterator());
        this._exploredSubset = this.newExploredSubset();
        this._coveredElements = new FHashSet<T>(this.getEqualityTester());
    }

    @Override
    public long explore() {
        IGraphIterator<T> explorationIterator = this.getExplorationIterator();
        while (explorationIterator.hasNext()) {
            explorationIterator.next();
        }
        return explorationIterator.maxDepth();
    }

    @Override
    public long exploreNext(long depthSteps_p) {
        long targetDepth = this.getExplorationIterator().lastDepth() + depthSteps_p;
        return this.exploreUntil(targetDepth);
    }

    @Override
    public long exploreUntil(long depth_p) {
        IGraphIterator<T> explorationIterator = this.getExplorationIterator();
        long initialDepth = explorationIterator.lastDepth();
        while (explorationIterator.hasNext() && explorationIterator.nextDepth() <= depth_p) {
            explorationIterator.next();
        }
        return explorationIterator.lastDepth() - initialDepth;
    }

    @Override
    public Collection<T> get(T element_p) {
        Collection<Object> result;
        IRangedBinaryRelation.Editable<T, T> explored = this.getEditableExploredSubset();
        if (this._coveredElements.contains(element_p)) {
            result = explored.get(element_p);
        } else {
            result = super.get(element_p);
            explored.addAll(element_p, result);
            this._coveredElements.add(element_p);
        }
        return result;
    }

    protected IRangedBinaryRelation.Editable<T, T> getEditableExploredSubset() {
        return this._exploredSubset;
    }

    @Override
    public Collection<T> getElements() {
        return this.getExploredSubset().getElements();
    }

    @Override
    public long getExplorationDepth() {
        return this.getExplorationIterator().lastDepth();
    }

    @Override
    public IRangedEndorelation<T> getExploredSubset() {
        return this._exploredSubset;
    }

    public IGraphIterator<T> getExplorationIterator() {
        return this._explorationIterator;
    }

    @Override
    public IPropertyValue<Collection<T>> getMinimalElements() {
        IPropertyValue result;
        if (this.isExplored()) {
            FHashSet mins = new FHashSet(this.getOrigins(), this.getEqualityTester());
            mins.removeAll(this.getExploredSubset().getTargets());
            result = new PropertyValue(Collections.unmodifiableCollection(mins));
        } else {
            result = super.getMinimalElements();
        }
        return result;
    }

    @Override
    public Collection<T> getSources() {
        return this.getExploredSubset().getSources();
    }

    @Override
    public Collection<T> getTargets() {
        return this.getExploredSubset().getTargets();
    }

    @Override
    public boolean isExplored() {
        return !this.getExplorationIterator().hasNext();
    }

    protected IGraphIterator<T> newExplorationIterator() {
        return new BreadthFirstIterator<T>(this){

            @Override
            protected void update() {
                super.update();
                if (this._next == null && CachingEndorelation.this._coveredElements != null) {
                    CachingEndorelation.this._coveredElements.clear();
                }
            }
        };
    }

    protected IRangedEndorelation.Editable<T> newExploredSubset() {
        return new EditableEndorelation(this.getEqualityTester());
    }

    @Override
    public void resetExploration() {
        this.getEditableExploredSubset().clear();
        this._coveredElements.clear();
        this.setExplorationIterator(this.newExplorationIterator());
    }

    protected void setExplorationIterator(IGraphIterator<T> iterator_p) {
        this._explorationIterator = iterator_p;
    }
}

