/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.AbstractUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IStatusMonitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class AsynchronousViewer
extends StructuredViewer
implements Listener {
    private AsynchronousModel fModel;
    private Map<ImageDescriptor, Image> fImageCache = new HashMap<ImageDescriptor, Image>();
    private Map<FontData, Font> fFontCache = new HashMap<FontData, Font>();
    private Map<RGB, Color> fColorCache = new HashMap<RGB, Color>();
    private IPresentationContext fContext;
    private ISelection fPendingSelection;
    private ISelection fCurrentSelection;
    private int[] fSetDataIndicies = new int[5];
    private AbstractUpdatePolicy fUpdatePolicy;
    protected static final String OLD_LABEL = "old_label";
    protected static final String OLD_IMAGE = "old_image";

    protected AsynchronousViewer() {
        this.setContentProvider((IContentProvider)new NullContentProvider());
        this.setUseHashlookup(true);
    }

    public final void setUseHashlookup(boolean enable) {
        Assert.isTrue((boolean)enable);
        super.setUseHashlookup(enable);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        control.addListener(36, (Listener)this);
    }

    public synchronized void dispose() {
        for (Image image : this.fImageCache.values()) {
            image.dispose();
        }
        this.fImageCache.clear();
        for (Font font : this.fFontCache.values()) {
            font.dispose();
        }
        this.fFontCache.clear();
        for (Color color : this.fColorCache.values()) {
            color.dispose();
        }
        this.fColorCache.clear();
        if (this.fModel != null) {
            this.fModel.dispose();
        }
        if (this.fUpdatePolicy != null) {
            this.fUpdatePolicy.dispose();
        }
        if (this.fContext != null) {
            ((PresentationContext)this.fContext).dispose();
        }
    }

    public void update(Object element) {
        ModelNode[] nodes = this.getModel().getNodes(element);
        if (nodes != null) {
            ModelNode[] modelNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ModelNode node = modelNodeArray[n2];
                this.updateLabel(node);
                ++n2;
            }
        }
    }

    protected void updateLabel(ModelNode node) {
        if (!node.getElement().equals(this.getInput())) {
            this.getModel().updateLabel(node);
        }
    }

    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    protected synchronized void unmapAllElements() {
        super.unmapAllElements();
        AsynchronousModel model = this.getModel();
        if (model != null) {
            model.dispose();
        }
    }

    protected synchronized void inputChanged(Object input, Object oldInput) {
        this.fPendingSelection = null;
        if (this.fCurrentSelection != null) {
            this.updateSelection((ISelection)new StructuredSelection());
            this.fCurrentSelection = null;
        }
        if (this.fUpdatePolicy == null) {
            this.fUpdatePolicy = this.createUpdatePolicy();
            this.fUpdatePolicy.init(this);
        }
        if (this.fModel != null) {
            this.fModel.dispose();
        }
        this.fModel = this.createModel();
        this.fModel.init(input);
        if (input != null) {
            this.mapElement(this.fModel.getRootNode(), (Widget)this.getControl());
            this.getControl().setData(this.fModel.getRootNode().getElement());
        } else {
            this.unmapAllElements();
            this.getControl().setData(null);
        }
        this.refresh();
    }

    protected abstract AsynchronousModel createModel();

    public abstract AbstractUpdatePolicy createUpdatePolicy();

    Image[] getImages(ImageDescriptor[] descriptors) {
        if (descriptors == null || descriptors.length == 0) {
            String[] columns = this.getPresentationContext().getColumns();
            if (columns == null) {
                return new Image[1];
            }
            return new Image[columns.length];
        }
        Image[] images = new Image[descriptors.length];
        int i = 0;
        while (i < images.length) {
            images[i] = this.getImage(descriptors[i]);
            ++i;
        }
        return images;
    }

    protected Image getImage(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Image image = this.fImageCache.get(descriptor);
        if (image == null) {
            image = new Image((Device)this.getControl().getDisplay(), descriptor.getImageData());
            this.fImageCache.put(descriptor, image);
        }
        return image;
    }

    protected Font[] getFonts(FontData[] fontDatas) {
        if (fontDatas == null || fontDatas.length == 0) {
            String[] columns = this.getPresentationContext().getColumns();
            if (columns == null) {
                return new Font[1];
            }
            return new Font[columns.length];
        }
        Font[] fonts = new Font[fontDatas.length];
        int i = 0;
        while (i < fonts.length) {
            fonts[i] = this.getFont(fontDatas[i]);
            ++i;
        }
        return fonts;
    }

    protected Font getFont(FontData fontData) {
        if (fontData == null) {
            return null;
        }
        Font font = this.fFontCache.get(fontData);
        if (font == null) {
            font = new Font((Device)this.getControl().getDisplay(), fontData);
            this.fFontCache.put(fontData, font);
        }
        return font;
    }

    protected Color[] getColors(RGB[] rgb) {
        if (rgb == null || rgb.length == 0) {
            String[] columns = this.getPresentationContext().getColumns();
            if (columns == null) {
                return new Color[1];
            }
            return new Color[columns.length];
        }
        Color[] colors = new Color[rgb.length];
        int i = 0;
        while (i < colors.length) {
            colors[i] = this.getColor(rgb[i]);
            ++i;
        }
        return colors;
    }

    protected Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        Color color = this.fColorCache.get(rgb);
        if (color == null) {
            color = new Color((Device)this.getControl().getDisplay(), rgb);
            this.fColorCache.put(rgb, color);
        }
        return color;
    }

    public void setContext(IPresentationContext context) {
        this.fContext = context;
    }

    protected Widget doFindItem(Object element) {
        AsynchronousModel model = this.getModel();
        if (model != null) {
            if (element.equals(model.getRootNode())) {
                return this.doFindInputItem(element);
            }
            Widget[] widgets = this.findItems(element);
            if (widgets.length > 0) {
                return widgets[0];
            }
        }
        return null;
    }

    protected Widget doFindInputItem(Object element) {
        ModelNode node;
        if (element instanceof ModelNode && (node = (ModelNode)element).getElement().equals(this.getInput())) {
            return this.getControl();
        }
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    protected void internalRefresh(Object element) {
        ModelNode[] nodes;
        AsynchronousModel model = this.getModel();
        if (model != null && (nodes = model.getNodes(element)) != null) {
            ModelNode[] modelNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ModelNode node = modelNodeArray[n2];
                Widget item = this.findItem(node);
                if (item != null) {
                    this.internalRefresh(node);
                }
                ++n2;
            }
        }
    }

    protected void internalRefresh(ModelNode node) {
        this.updateLabel(node);
    }

    public synchronized void setSelection(ISelection selection, boolean reveal) {
        this.setSelection(selection, reveal, false);
    }

    public synchronized void setSelection(ISelection selection, final boolean reveal, boolean force) {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        if (!this.acceptsSelection(selection)) {
            selection = this.getEmptySelection();
        }
        if (!force && !this.overrideSelection(this.fCurrentSelection, selection)) {
            return;
        }
        this.fPendingSelection = selection;
        if (this.getControl().getDisplay().getThread() == Thread.currentThread()) {
            this.attemptSelection(reveal);
        } else {
            WorkbenchJob job = new WorkbenchJob("attemptSelection"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AsynchronousViewer.this.attemptSelection(reveal);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    protected boolean overrideSelection(ISelection current, ISelection candidate) {
        IModelSelectionPolicy selectionPolicy = this.getSelectionPolicy(current);
        if (selectionPolicy == null) {
            return true;
        }
        if (selectionPolicy.contains(candidate, this.getPresentationContext())) {
            return selectionPolicy.overrides(current, candidate, this.getPresentationContext());
        }
        return !selectionPolicy.isSticky(current, this.getPresentationContext());
    }

    public ISelection getSelection() {
        Control control = this.getControl();
        if (control == null || control.isDisposed() || this.fCurrentSelection == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fCurrentSelection;
    }

    protected void handleSelect(SelectionEvent event) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            this.updateSelection(this.newSelectionFromWidget());
        }
    }

    protected void handlePostSelect(SelectionEvent e) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.newSelectionFromWidget());
        this.firePostSelectionChanged(event);
    }

    protected abstract ISelection newSelectionFromWidget();

    protected IModelSelectionPolicy getSelectionPolicy(ISelection selection) {
        IAdaptable adaptable;
        IModelSelectionPolicyFactory factory;
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (factory = (IModelSelectionPolicyFactory)(adaptable = (IAdaptable)element).getAdapter(IModelSelectionPolicyFactory.class)) != null) {
            return factory.createModelSelectionPolicyAdapter(adaptable, this.getPresentationContext());
        }
        return null;
    }

    protected final void setSelectionToWidget(ISelection selection, boolean reveal) {
        throw new IllegalArgumentException("This method should not be called");
    }

    protected final void setSelectionToWidget(List l, boolean reveal) {
        throw new IllegalArgumentException("This method should not be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attemptSelection(boolean reveal) {
        ISelection currentSelection = null;
        AsynchronousViewer asynchronousViewer = this;
        synchronized (asynchronousViewer) {
            if (this.fPendingSelection != null) {
                ISelection remaining = this.doAttemptSelectionToWidget(this.fPendingSelection, reveal);
                if (remaining.isEmpty()) {
                    remaining = null;
                }
                if (!this.fPendingSelection.equals(remaining)) {
                    this.fPendingSelection = remaining;
                    currentSelection = this.newSelectionFromWidget();
                    if (this.isSuppressEqualSelections() && currentSelection.equals(this.fCurrentSelection)) {
                        return;
                    }
                }
            }
        }
        if (currentSelection != null) {
            this.updateSelection(currentSelection);
            this.firePostSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, currentSelection));
        }
    }

    protected boolean isSuppressEqualSelections() {
        return true;
    }

    protected abstract ISelection doAttemptSelectionToWidget(ISelection var1, boolean var2);

    protected abstract boolean acceptsSelection(ISelection var1);

    protected abstract ISelection getEmptySelection();

    protected void handlePresentationFailure(IStatusMonitor monitor, IStatus status) {
    }

    protected synchronized void preservingSelection(Runnable updateCode) {
        if (this.fPendingSelection == null || this.fPendingSelection.isEmpty()) {
            ISelection oldSelection = null;
            try {
                oldSelection = this.fCurrentSelection;
                updateCode.run();
            }
            catch (Throwable throwable) {
                if (oldSelection == null) {
                    oldSelection = new StructuredSelection();
                }
                if (this.getControl().getDisplay().getThread() == Thread.currentThread()) {
                    if (!oldSelection.equals(this.newSelectionFromWidget())) {
                        this.restoreSelection(oldSelection);
                    }
                } else {
                    WorkbenchJob job = new WorkbenchJob("attemptSelection"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            AsynchronousViewer asynchronousViewer = AsynchronousViewer.this;
                            synchronized (asynchronousViewer) {
                                if (!AsynchronousViewer.this.getControl().isDisposed() && (AsynchronousViewer.this.fPendingSelection == null || AsynchronousViewer.this.fPendingSelection.isEmpty())) {
                                    ISelection tempSelection = AsynchronousViewer.this.fCurrentSelection;
                                    if (tempSelection == null) {
                                        tempSelection = new StructuredSelection();
                                    }
                                    if (!tempSelection.equals(AsynchronousViewer.this.newSelectionFromWidget())) {
                                        AsynchronousViewer.this.restoreSelection(tempSelection);
                                    }
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                }
                throw throwable;
            }
            if (oldSelection == null) {
                oldSelection = new StructuredSelection();
            }
            if (this.getControl().getDisplay().getThread() == Thread.currentThread()) {
                if (!oldSelection.equals(this.newSelectionFromWidget())) {
                    this.restoreSelection(oldSelection);
                }
            } else {
                WorkbenchJob job = new /* invalid duplicate definition of identical inner class */;
                job.setSystem(true);
                job.schedule();
            }
        } else {
            updateCode.run();
        }
    }

    protected synchronized void restoreSelection(ISelection oldSelection) {
        ISelection remaining = this.doAttemptSelectionToWidget(oldSelection, false);
        this.fCurrentSelection = this.newSelectionFromWidget();
        if (!this.selectionExists(this.fCurrentSelection)) {
            this.fCurrentSelection = this.selectionExists(oldSelection) ? oldSelection : this.getEmptySelection();
        }
        if (!this.fCurrentSelection.equals(oldSelection)) {
            this.handleInvalidSelection(oldSelection, this.fCurrentSelection);
            if (this.selectionExists(remaining)) {
                this.setSelection(remaining);
            }
        }
    }

    protected boolean selectionExists(ISelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object element : ss) {
                if (this.getModel().getNodes(element) != null) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract void setColors(Widget var1, RGB[] var2, RGB[] var3);

    protected abstract void setLabels(Widget var1, String[] var2, ImageDescriptor[] var3);

    protected abstract void setFonts(Widget var1, FontData[] var2);

    protected synchronized void updateSelection(ISelection selection) {
        this.fCurrentSelection = selection;
        super.updateSelection(selection);
    }

    protected void modelProxyAdded(IModelProxy proxy) {
        if (this.fUpdatePolicy instanceof IModelChangedListener) {
            proxy.addModelChangedListener((IModelChangedListener)((Object)this.fUpdatePolicy));
        }
    }

    protected void modelProxyRemoved(IModelProxy proxy) {
        if (this.fUpdatePolicy instanceof IModelChangedListener) {
            proxy.removeModelChangedListener((IModelChangedListener)((Object)this.fUpdatePolicy));
        }
    }

    protected AsynchronousModel getModel() {
        return this.fModel;
    }

    protected void nodeChanged(ModelNode node) {
        Widget widget = this.findItem(node);
        if (widget != null) {
            this.clear(widget);
            this.attemptPendingUpdates();
        }
    }

    public synchronized boolean hasPendingUpdates() {
        return this.getModel().hasPendingUpdates();
    }

    protected void updateComplete(IStatusMonitor monitor) {
    }

    protected abstract void clear(Widget var1);

    protected abstract void clearChildren(Widget var1);

    protected abstract void clearChild(Widget var1, int var2);

    protected abstract Widget getChildWidget(Widget var1, int var2);

    protected abstract void setItemCount(Widget var1, int var2);

    protected void attemptPendingUpdates() {
        this.attemptSelection(false);
    }

    protected void nodeChildrenChanged(ModelNode parentNode) {
        Widget widget = this.findItem(parentNode);
        if (widget != null && !widget.isDisposed()) {
            int childCount = parentNode.getChildCount();
            this.setItemCount(widget, childCount);
            this.clearChildren(widget);
            this.attemptPendingUpdates();
        }
    }

    protected void nodeChildrenAdded(ModelNode parentNode) {
        Widget widget = this.findItem(parentNode);
        if (widget != null && !widget.isDisposed()) {
            int childCount = parentNode.getChildCount();
            this.setItemCount(widget, childCount);
            this.attemptPendingUpdates();
        }
    }

    protected void nodeChildRemoved(ModelNode parentNode, int index) {
        Widget widget = this.findItem(parentNode);
        if (widget != null && !widget.isDisposed()) {
            Widget childWidget = this.getChildWidget(widget, index);
            int childCount = parentNode.getChildCount();
            if (childWidget == null) {
                this.setItemCount(widget, childCount);
            } else {
                childWidget.dispose();
            }
            int i = index;
            while (i < childCount) {
                this.clearChild(widget, i);
                ++i;
            }
            this.attemptPendingUpdates();
        }
    }

    protected void unmapNode(ModelNode node) {
        this.unmapElement(node);
        ModelNode[] childrenNodes = node.getChildrenNodes();
        if (childrenNodes != null) {
            ModelNode[] modelNodeArray = childrenNodes;
            int n = childrenNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ModelNode childNode = modelNodeArray[n2];
                this.unmapNode(childNode);
                ++n2;
            }
        }
    }

    protected ModelNode findNode(Widget widget) {
        ModelNode[] nodes = this.getModel().getNodes(widget.getData());
        if (nodes != null) {
            ModelNode[] modelNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ModelNode node = modelNodeArray[n2];
                Widget item = this.findItem(node);
                if (widget == item) {
                    return node;
                }
                ++n2;
            }
        }
        return null;
    }

    protected Widget findItem(ModelNode node) {
        return this.findItem(node);
    }

    public void handleEvent(Event event) {
        this.update((Item)event.item, event.index);
    }

    protected void update(Item item, int index) {
        ModelNode[] nodes;
        this.restoreLabels(item);
        int level = 0;
        Widget parentItem = this.getParentWidget((Widget)item);
        if (DebugUIPlugin.DEBUG_VIEWER) {
            DebugUIPlugin.trace("SET DATA [" + index + "]: " + parentItem);
        }
        ModelNode node = null;
        if (parentItem != null && (nodes = this.getModel().getNodes(parentItem.getData())) != null) {
            ModelNode[] modelNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ModelNode[] childrenNodes;
                ModelNode parentNode = modelNodeArray[n2];
                Widget parentWidget = this.findItem(parentNode);
                if (parentWidget == parentItem && (childrenNodes = parentNode.getChildrenNodes()) != null && index < childrenNodes.length) {
                    node = childrenNodes[index];
                }
                ++n2;
            }
        }
        if (node == null) {
            this.setNodeIndex(index, level);
            while (parentItem instanceof Item) {
                ++level;
                Widget parent = this.getParentWidget(parentItem);
                int pindex = this.indexOf(parent, parentItem);
                if (pindex < 0) {
                    return;
                }
                this.setNodeIndex(pindex, level);
                parentItem = parent;
            }
            node = this.getModel().getRootNode();
            if (node == null) {
                if (DebugUIPlugin.DEBUG_VIEWER) {
                    DebugUIPlugin.trace("\tFAILED - root model node is null");
                }
                return;
            }
            int i = level;
            while (i >= 0) {
                ModelNode[] childrenNodes = node.getChildrenNodes();
                if (childrenNodes == null) {
                    if (DebugUIPlugin.DEBUG_VIEWER) {
                        DebugUIPlugin.trace("\tFAILED - no children nodes for " + node);
                    }
                    return;
                }
                int pindex = this.getNodeIndex(i);
                if (pindex >= childrenNodes.length) {
                    if (DebugUIPlugin.DEBUG_VIEWER) {
                        DebugUIPlugin.trace("\tFAILED - no children nodes for " + node);
                    }
                    return;
                }
                node = childrenNodes[pindex];
                --i;
            }
        }
        if (node != null) {
            this.mapElement(node, (Widget)item);
            item.setData(node.getElement());
            if (DebugUIPlugin.DEBUG_VIEWER) {
                DebugUIPlugin.trace("\titem mapped: " + node);
            }
            this.internalRefresh(node);
        } else if (DebugUIPlugin.DEBUG_VIEWER) {
            DebugUIPlugin.trace("\tFAILED - unable to find corresponding node");
        }
    }

    private void setNodeIndex(int nodeIndex, int level) {
        if (level > this.fSetDataIndicies.length - 1) {
            int[] next = new int[level + 5];
            System.arraycopy(this.fSetDataIndicies, 0, next, 0, this.fSetDataIndicies.length);
            this.fSetDataIndicies = next;
        }
        this.fSetDataIndicies[level] = nodeIndex;
    }

    private int getNodeIndex(int level) {
        return this.fSetDataIndicies[level];
    }

    protected abstract int indexOf(Widget var1, Widget var2);

    protected abstract void restoreLabels(Item var1);

    protected abstract Widget getParentWidget(Widget var1);

    protected void updateChildren(ModelNode parent) {
        this.getModel().updateChildren(parent);
    }

    private class NullContentProvider
    implements IStructuredContentProvider {
        private NullContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return null;
        }
    }
}

