/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.config.persistence;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.capella.common.tools.report.config.persistence.ConfigurationInstance;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReportConfigurationFile {
    protected List<ConfigurationInstance> configurationInstance;
    protected String fileFormatVersion;
    protected String reportManagerVersion;

    public ReportConfigurationFile() {
    }

    public ReportConfigurationFile(Element element) {
        this.setFileFormatVersion(element.getAttribute("fileFormatVersion"));
        this.setReportManagerVersion(element.getAttribute("reportManagerVersion"));
        NodeList configInstanceList = element.getElementsByTagName("ConfigurationInstance");
        this.configurationInstance = new ArrayList<ConfigurationInstance>();
        int i = 0;
        while (i < configInstanceList.getLength()) {
            this.configurationInstance.add(new ConfigurationInstance((Element)configInstanceList.item(i)));
            ++i;
        }
    }

    public List<ConfigurationInstance> getConfigurationInstance() {
        if (this.configurationInstance == null) {
            this.configurationInstance = new ArrayList<ConfigurationInstance>(1);
        }
        return this.configurationInstance;
    }

    public void setConfigurationInstance(List<ConfigurationInstance> configurationInstance) {
        this.configurationInstance = configurationInstance;
    }

    public String getFileFormatVersion() {
        return this.fileFormatVersion;
    }

    public void setFileFormatVersion(String value) {
        this.fileFormatVersion = value;
    }

    public String getReportManagerVersion() {
        return this.reportManagerVersion;
    }

    public void setReportManagerVersion(String value) {
        this.reportManagerVersion = value;
    }

    public Element convertToElement(Document document) {
        Element element = document.createElement("ReportConfigurationFile");
        Attr fileFormatVersionAttr = document.createAttribute("fileFormatVersion");
        fileFormatVersionAttr.setValue(this.getFileFormatVersion());
        element.setAttributeNode(fileFormatVersionAttr);
        Attr reportManagerVersionAttr = document.createAttribute("reportManagerVersion");
        reportManagerVersionAttr.setValue(this.getFileFormatVersion());
        element.setAttributeNode(reportManagerVersionAttr);
        this.getConfigurationInstance().forEach(configInstance -> {
            Element outputConfigElement = configInstance.convertToElement(document);
            element.appendChild(outputConfigElement);
        });
        return element;
    }
}

