/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.tiger.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.ITransfoRule;
import org.polarsys.capella.core.tiger.TransfoException;
import org.polarsys.capella.core.tiger.helpers.Query;
import org.polarsys.capella.core.tiger.helpers.TigerRelationshipHelper;

public abstract class TransfoRule
implements ITransfoRule,
Comparable<TransfoRule> {
    public static String __cr = System.getProperty("line.separator");
    public static String __br = "<br/>";
    private String _longName;
    private String _shortName;
    private EClass _eSourceType;
    private EClass _eTargetType;
    private EClass _eSpecificLinkKind;
    private boolean _active = true;
    private boolean _abstract = false;
    private boolean _deprecated = false;
    private boolean _needsContext = false;
    protected List<String> _updatedAttributes = new ArrayList<String>();
    protected Logger _logger = ReportManagerRegistry.getInstance().subscribe("Refinement");

    public TransfoRule(EClass sourceType, EClass targetType) {
        this._eSourceType = sourceType;
        this._eTargetType = targetType;
        this.setShortName(this.getClass().getSimpleName());
        this.setLongName(" (" + this._eSourceType.getName() + " -> " + this._eTargetType.getName() + ")");
        if (ModellingcorePackage.eINSTANCE.getAbstractNamedElement().isSuperTypeOf(targetType)) {
            this._updatedAttributes.add(ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME.getName());
            this._updatedAttributes.add(CapellacorePackage.Literals.CAPELLA_ELEMENT__DESCRIPTION.getName());
            this._updatedAttributes.add(CapellacorePackage.Literals.CAPELLA_ELEMENT__SUMMARY.getName());
        }
    }

    public TransfoRule(EClass sourceType, EClass targetType, EClass specificLinkKind) {
        this(sourceType, targetType);
        this._eSpecificLinkKind = specificLinkKind;
    }

    public TransfoRule(EClass eclass) {
        this(eclass, eclass);
    }

    @Override
    public String getName() {
        return String.valueOf(this._shortName) + " " + this._longName;
    }

    @Override
    public String getDescription() {
        String sourceType = this.getSourceType().getName();
        String targetType = this.getTargetType().getName();
        String description = "<b>Transforms a " + sourceType + " into a " + targetType;
        if (sourceType == targetType) {
            description = String.valueOf(description) + " (Clone)";
        }
        description = String.valueOf(description) + "</b>";
        return description;
    }

    @Override
    public boolean isActive() {
        return this._active && !this._abstract && !this._deprecated;
    }

    @Override
    public void setLongName(String name) {
        this._longName = name;
    }

    @Override
    public String getShortName() {
        return this._shortName;
    }

    @Override
    public void setShortName(String shortName) {
        this._shortName = shortName;
    }

    @Override
    public EClass getSourceType() {
        return this._eSourceType;
    }

    @Override
    public EClass getTargetType() {
        return this._eTargetType;
    }

    @Override
    public String toString() {
        return this._longName;
    }

    @Override
    public boolean when(EObject element, ITransfo transfo) {
        return this._eSourceType.isInstance((Object)element);
    }

    @Override
    public final List<EObject> retrieveRelatedElements(EObject element, ITransfo transfo) {
        List<EObject> relatedElements = this.retrieveRelatedElements_(element, transfo);
        return relatedElements;
    }

    public abstract List<EObject> retrieveRelatedElements_(EObject var1, ITransfo var2);

    @Override
    public boolean requireTransformation(EObject element, ITransfo transfo) {
        Object transformedElement = Query.retrieveTransformedElement(element, transfo);
        return transformedElement == null || transformedElement instanceof List && ((List)transformedElement).size() == 0 || transformedElement instanceof EObject && !EcoreUtil2.isEqualOrSuperClass((EClass)this.getTargetType(), (EClass)((EObject)transformedElement).eClass());
    }

    @Override
    public final Object transform(EObject element, ITransfo transfo) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("     - Transform " + EObjectExt.getText((EObject)element) + " by " + this.getName()));
        }
        return this.transform_(element, transfo);
    }

    public abstract Object transform_(EObject var1, ITransfo var2);

    @Override
    public final void update(EObject element, ITransfo transfo) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("     - Update " + EObjectExt.getText((EObject)element) + " by " + this.getName()));
        }
        this.update_(element, transfo);
    }

    public void update_(EObject element, ITransfo transfo) {
        if (element instanceof AbstractNamedElement) {
            TigerRelationshipHelper.updateElementByProperty(element, this._updatedAttributes, transfo);
        }
    }

    @Override
    public final void attach(EObject element, ITransfo transfo) throws TransfoException {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("     - Attach " + EObjectExt.getText((EObject)element) + " by " + this.getName()));
        }
        this.attach_(element, transfo);
    }

    public abstract void attach_(EObject var1, ITransfo var2) throws TransfoException;

    @Override
    public boolean isAbstract() {
        return this._abstract;
    }

    @Override
    public void setAbstract(boolean isAbstract) {
        this._abstract = isAbstract;
    }

    @Override
    public boolean isDeprecated() {
        return this._deprecated;
    }

    @Override
    public void setDeprecated(boolean deprecated) {
        this._deprecated = deprecated;
    }

    @Override
    public void setActive(boolean active) {
        this._active = active;
    }

    protected boolean isNeedsContext() {
        return this._needsContext;
    }

    protected void setNeedsContext(boolean needsContext) {
        this._needsContext = needsContext;
    }

    @Override
    public String toHtml(boolean standalone) {
        String superclassName;
        StringBuilder htmlDoc = new StringBuilder();
        Class<?> class_ = this.getClass();
        htmlDoc.append("<td valign='top' id='").append(class_.getSimpleName()).append("'><b>").append(__cr);
        htmlDoc.append(this.getShortName());
        htmlDoc.append("</b></td>").append(__cr);
        htmlDoc.append("<td valign='top'>").append(__cr);
        Class<?> superClass = this.getClass().getSuperclass();
        String string = superclassName = TransfoRule.class != superClass ? superClass.getSimpleName() : "";
        if (!superclassName.equals("")) {
            htmlDoc.append("<a href='#").append(superclassName).append("'>").append(__cr);
            htmlDoc.append(superclassName);
            htmlDoc.append("</a>").append(__cr);
        } else {
            htmlDoc.append("-");
        }
        htmlDoc.append("</td>").append(__cr);
        htmlDoc.append("<td valign='top'>").append(__cr);
        htmlDoc.append(this.isActive() ? "X" : "-");
        htmlDoc.append("</td>").append(__cr);
        htmlDoc.append("<td valign='top'>").append(__cr);
        htmlDoc.append(this.isNeedsContext() ? "C" : "-");
        htmlDoc.append("</td>").append(__cr);
        htmlDoc.append("<td valign='top'>").append(__cr);
        htmlDoc.append(this.isAbstract() ? "A" : "-");
        htmlDoc.append("</td>").append(__cr);
        htmlDoc.append("<td valign='top'>").append(__cr);
        htmlDoc.append(this.isDeprecated() ? "D" : "-");
        htmlDoc.append("</td>").append(__cr);
        htmlDoc.append("<td valign='top'>").append(__cr);
        for (String updatedAttribute : this._updatedAttributes) {
            htmlDoc.append(updatedAttribute).append(__br).append(__cr);
        }
        htmlDoc.append("</td>").append(__cr);
        htmlDoc.append("<td valign='top'>").append(__cr);
        htmlDoc.append(this.getDescription());
        htmlDoc.append("</td>").append(__cr);
        return htmlDoc.toString();
    }

    @Override
    public int compareTo(TransfoRule arg0) {
        return this.getName().compareTo(arg0.getName());
    }

    @Override
    public EClass getSpecificLinkKind() {
        return this._eSpecificLinkKind;
    }

    protected void registerAttributeUpdate(EAttribute att) {
        this._updatedAttributes.add(att.getName());
    }
}

