/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.common.validation.project;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.SemanticResourcesScope;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;

public class UnkownFeaturesRule
extends AbstractValidationRule {
    public static final String ID = "org.polarsys.capella.core.data.common.validation.I_44";

    public IStatus validate(IValidationContext validationContext) {
        Resource targetResource;
        EObject target = validationContext.getTarget();
        ArrayList<IStatus> errorStatuses = new ArrayList<IStatus>();
        if (target instanceof SystemEngineering && (targetResource = target.eResource()) != null) {
            ResourceSet resourceSet = targetResource.getResourceSet();
            SemanticResourcesScope resourceSetScope = new SemanticResourcesScope(resourceSet);
            if (resourceSet != null) {
                for (Resource resource : resourceSet.getResources()) {
                    if (!this.requiresAnalysis(resource) || !(resource instanceof XMLResource)) continue;
                    XMLResource xmlResource = (XMLResource)resource;
                    URI xmlResourceURI = xmlResource.getURI();
                    String resourceName = URI.decode((String)xmlResourceURI.lastSegment());
                    Map objectToExtensionMap = xmlResource.getEObjectToExtensionMap();
                    for (Map.Entry entry : objectToExtensionMap.entrySet()) {
                        EObject modelElement = (EObject)entry.getKey();
                        String modelElementName = EObjectLabelProviderHelper.getText((Object)modelElement);
                        AnyType anyType = (AnyType)entry.getValue();
                        if (anyType == null) continue;
                        FeatureMap attributeMap = anyType.getAnyAttribute();
                        for (FeatureMap.Entry attributeEntry : attributeMap) {
                            EStructuralFeature unknownFeature = attributeEntry.getEStructuralFeature();
                            Object unknownFeatureValue = this.formatFeatureValue(attributeEntry.getValue(), resourceSetScope);
                            IStatus status = this.createFailureStatus(validationContext, modelElement, unknownFeature, xmlResource, modelElementName, resourceName, unknownFeature.getName(), unknownFeatureValue);
                            errorStatuses.add(status);
                        }
                    }
                }
            }
        }
        return !errorStatuses.isEmpty() ? ConstraintStatus.createMultiStatus((IValidationContext)validationContext, errorStatuses) : Status.OK_STATUS;
    }

    private Object formatFeatureValue(Object featureValue, SemanticResourcesScope resourceSetScope) {
        if (featureValue instanceof String) {
            String value = ((String)featureValue).replaceAll("#", "");
            EObject object = IdManager.getInstance().getEObject(value, (IScope)resourceSetScope);
            if (object != null) {
                return EObjectLabelProviderHelper.getText((Object)object);
            }
        }
        return featureValue;
    }

    private boolean requiresAnalysis(Resource resource) {
        return CapellaResourceHelper.isCapellaResource((Resource)resource) || CapellaResourceHelper.isAirdResource((URI)resource.getURI());
    }

    private IStatus createFailureStatus(IValidationContext validationContext, EObject target, EStructuralFeature unknownFeature, XMLResource resource, Object ... messageArguments) {
        IConstraintDescriptor constraintDescriptor = ConstraintRegistry.getInstance().getDescriptor(validationContext.getCurrentConstraintId());
        HashSet<Object> localResultLocus = new HashSet<Object>();
        localResultLocus.add(target);
        UnknownFeatureData unknownFeatureData = new UnknownFeatureData(target, unknownFeature, resource);
        localResultLocus.add((Object)unknownFeatureData);
        return ConstraintStatus.createStatus((IValidationContext)validationContext, (EObject)target, localResultLocus, (String)constraintDescriptor.getMessagePattern(), (Object[])messageArguments);
    }

    public static class UnknownFeatureData
    extends BasicEObjectImpl {
        public final EObject modelElement;
        public final EStructuralFeature unknownFeature;
        public final XMLResource resource;

        public UnknownFeatureData(EObject modelElement, EStructuralFeature unknownFeature, XMLResource resource) {
            this.modelElement = modelElement;
            this.unknownFeature = unknownFeature;
            this.resource = resource;
        }

        public Resource eResource() {
            return this.resource;
        }
    }
}

