/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.ui.pref;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.capella.common.tools.report.config.persistence.ConfigurationInstance;
import org.polarsys.capella.common.tools.report.config.persistence.LogLevel;
import org.polarsys.capella.common.tools.report.config.persistence.OutputConfiguration;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.common.tools.report.ui.pref.IReportManagerPrefPage;

public class CreateBaseComponentTable {
    private ReportManagerRegistry _registry;
    private List<String> _appendersName = new ArrayList<String>();
    private String[] _lineLevelNames;
    private Map<String, Control> _stackMapping = new HashMap<String, Control>();
    private Map<String, Button> _buttons = new HashMap<String, Button>();
    private StackLayout _stackLayout = new StackLayout();

    public CreateBaseComponentTable(Composite composite, int style, ReportManagerRegistry registry, IReportManagerPrefPage page, String[] levelsName) {
        this._registry = registry;
        this._lineLevelNames = levelsName;
        this._appendersName.addAll(registry.getAppenderKinds());
        this.createLoggingTable(composite, registry, levelsName);
    }

    private void createLoggingTable(Composite composite, ReportManagerRegistry registry, String[] levelsName) {
        Group group = new Group(composite, 8);
        group.setText("Report options");
        this._stackLayout = new StackLayout();
        group.setLayout((Layout)this._stackLayout);
        Object[] objectArray = registry.getComponentsList();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            String componentName = (String)obj;
            Composite componentGroup = new Composite((Composite)group, 0);
            GridLayout grid = new GridLayout();
            grid.numColumns = this._appendersName.size() + 1;
            grid.horizontalSpacing = 5;
            grid.makeColumnsEqualWidth = true;
            componentGroup.setLayout((Layout)grid);
            this._stackLayout.topControl = componentGroup;
            Label levelLabel = new Label(componentGroup, 0);
            levelLabel.setText(" ");
            this._stackMapping.put(componentName, (Control)componentGroup);
            for (String appender : this._appendersName) {
                Label titleLabel = new Label(componentGroup, 0);
                titleLabel.setText(appender);
            }
            String[] stringArray = levelsName;
            int n3 = levelsName.length;
            int n4 = 0;
            while (n4 < n3) {
                String levelName = stringArray[n4];
                Label levelLabel2 = new Label(componentGroup, 0);
                levelLabel2.setText(levelName);
                for (String appender : this._appendersName) {
                    Button tickBox = new Button(componentGroup, 0x1000020);
                    String key = this.computeButtonKey(componentName, levelName, appender);
                    this._buttons.put(key, tickBox);
                }
                ++n4;
            }
            ++n2;
        }
        this.initializeValuesForReport();
    }

    private String computeButtonKey(String componentName, String levelName, String appenderName) {
        StringBuilder builder = new StringBuilder();
        builder.append(componentName);
        builder.append(levelName);
        builder.append(appenderName);
        return builder.toString();
    }

    private void initializeValuesForReport() {
        Object[] objectArray = this._registry.getComponentsList();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object componentName_obj = objectArray[n2];
            String componentName = (String)componentName_obj;
            ConfigurationInstance instance = (ConfigurationInstance)this._registry.getConfigurations().get(componentName);
            List confList = instance.getOutputConfiguration();
            ListIterator opConfIter = confList.listIterator();
            while (opConfIter.hasNext()) {
                OutputConfiguration opConfiguration = (OutputConfiguration)opConfIter.next();
                List loglevel = opConfiguration.getLogLevel();
                ListIterator logLevelIter = loglevel.listIterator();
                while (logLevelIter.hasNext()) {
                    LogLevel ll = (LogLevel)logLevelIter.next();
                    this.setButtonState(componentName, opConfiguration.getOutputName(), ll.getName(), ll.isValue());
                }
            }
            ++n2;
        }
    }

    private void setButtonState(String componentName, String appenderName, String levelName, boolean value) {
        String key = this.computeButtonKey(componentName, levelName, appenderName);
        Button button = this._buttons.get(key);
        if (button != null) {
            button.setSelection(value);
        }
    }

    public void updateConfigurationHashMap(Map<String, ConfigurationInstance> configurationMap) {
        Object[] objectArray = this._registry.getComponentsList();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object componentName_obj = objectArray[n2];
            String componentName = (String)componentName_obj;
            this.updateConfigurationHashMap(componentName, configurationMap);
            ++n2;
        }
    }

    public void updateConfigurationHashMap(String componentName, Map<String, ConfigurationInstance> configurationMap) {
        ConfigurationInstance instance = configurationMap.get(componentName);
        List opConf = instance.getOutputConfiguration();
        ListIterator opConfIter = opConf.listIterator();
        while (opConfIter.hasNext()) {
            OutputConfiguration opConfiguration = (OutputConfiguration)opConfIter.next();
            this.updateConfigurationHashMap(componentName, opConfiguration);
        }
    }

    public void updateConfigurationHashMap(String componentName, OutputConfiguration configuration) {
        List logLevel = configuration.getLogLevel();
        ListIterator logLevelIter = logLevel.listIterator();
        try {
            while (logLevelIter.hasNext()) {
                LogLevel ll = (LogLevel)logLevelIter.next();
                String key = this.computeButtonKey(componentName, ll.getName(), configuration.getOutputName());
                Button button = this._buttons.get(key);
                boolean state = button.getSelection();
                ll.setValue(state);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectPage(String text) {
        Control page;
        this._stackLayout.topControl = page = this._stackMapping.get(text);
        page.getParent().layout();
    }

    public void defaultValues() {
        Object[] objectArray = this._registry.getComponentsList();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object componentName_obj = objectArray[n2];
            String componentName = (String)componentName_obj;
            for (String currentAppenderName : this._appendersName) {
                String[] stringArray = this._lineLevelNames;
                int n3 = this._lineLevelNames.length;
                int n4 = 0;
                while (n4 < n3) {
                    String currentLevelName = stringArray[n4];
                    String key = this.computeButtonKey(componentName, currentLevelName, currentAppenderName);
                    Button button = this._buttons.get(key);
                    if (button != null) {
                        button.setSelection(!currentLevelName.equals("DEBUG") && !currentAppenderName.equals("File"));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }
}

