/**
 * Copyright (c) 2007, 2013 THALES GLOBAL SERVICES.
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *
 */
package org.eclipse.sirius.viewpoint.description.tool.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.sirius.viewpoint.description.tool.util.ToolAdapterFactory;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The adapters generated by this
 * factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}. The adapters
 * also support Eclipse property sheets. Note that most of the adapters are shared among multiple instances. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 *
 * @generated
 */
public class ToolItemProviderAdapterFactory extends ToolAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This helps manage the child creation extenders. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(SiriusEditPlugin.INSTANCE, ToolPackage.eNS_URI);

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public ToolItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.ToolDescription} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected ToolDescriptionItemProvider toolDescriptionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.ToolDescription}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createToolDescriptionAdapter() {
        if (toolDescriptionItemProvider == null) {
            toolDescriptionItemProvider = new ToolDescriptionItemProvider(this);
        }

        return toolDescriptionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.PasteDescription} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected PasteDescriptionItemProvider pasteDescriptionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.PasteDescription}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createPasteDescriptionAdapter() {
        if (pasteDescriptionItemProvider == null) {
            pasteDescriptionItemProvider = new PasteDescriptionItemProvider(this);
        }

        return pasteDescriptionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected SelectionWizardDescriptionItemProvider selectionWizardDescriptionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createSelectionWizardDescriptionAdapter() {
        if (selectionWizardDescriptionItemProvider == null) {
            selectionWizardDescriptionItemProvider = new SelectionWizardDescriptionItemProvider(this);
        }

        return selectionWizardDescriptionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected PaneBasedSelectionWizardDescriptionItemProvider paneBasedSelectionWizardDescriptionItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createPaneBasedSelectionWizardDescriptionAdapter() {
        if (paneBasedSelectionWizardDescriptionItemProvider == null) {
            paneBasedSelectionWizardDescriptionItemProvider = new PaneBasedSelectionWizardDescriptionItemProvider(this);
        }

        return paneBasedSelectionWizardDescriptionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.MenuItemDescriptionReference} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected MenuItemDescriptionReferenceItemProvider menuItemDescriptionReferenceItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.MenuItemDescriptionReference}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createMenuItemDescriptionReferenceAdapter() {
        if (menuItemDescriptionReferenceItemProvider == null) {
            menuItemDescriptionReferenceItemProvider = new MenuItemDescriptionReferenceItemProvider(this);
        }

        return menuItemDescriptionReferenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.OperationAction} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected OperationActionItemProvider operationActionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.OperationAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createOperationActionAdapter() {
        if (operationActionItemProvider == null) {
            operationActionItemProvider = new OperationActionItemProvider(this);
        }

        return operationActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected ExternalJavaActionItemProvider externalJavaActionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createExternalJavaActionAdapter() {
        if (externalJavaActionItemProvider == null) {
            externalJavaActionItemProvider = new ExternalJavaActionItemProvider(this);
        }

        return externalJavaActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.ExternalJavaActionCall} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    protected ExternalJavaActionCallItemProvider externalJavaActionCallItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.ExternalJavaActionCall}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createExternalJavaActionCallAdapter() {
        if (externalJavaActionCallItemProvider == null) {
            externalJavaActionCallItemProvider = new ExternalJavaActionCallItemProvider(this);
        }

        return externalJavaActionCallItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.sirius.viewpoint.description.tool.PopupMenu}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected PopupMenuItemProvider popupMenuItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.PopupMenu}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createPopupMenuAdapter() {
        if (popupMenuItemProvider == null) {
            popupMenuItemProvider = new PopupMenuItemProvider(this);
        }

        return popupMenuItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.AcceleoVariable} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected AcceleoVariableItemProvider acceleoVariableItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.AcceleoVariable}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createAcceleoVariableAdapter() {
        if (acceleoVariableItemProvider == null) {
            acceleoVariableItemProvider = new AcceleoVariableItemProvider(this);
        }

        return acceleoVariableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.ElementDropVariable} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected ElementDropVariableItemProvider elementDropVariableItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.ElementDropVariable}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createElementDropVariableAdapter() {
        if (elementDropVariableItemProvider == null) {
            elementDropVariableItemProvider = new ElementDropVariableItemProvider(this);
        }

        return elementDropVariableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.ElementSelectVariable} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    protected ElementSelectVariableItemProvider elementSelectVariableItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.ElementSelectVariable}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createElementSelectVariableAdapter() {
        if (elementSelectVariableItemProvider == null) {
            elementSelectVariableItemProvider = new ElementSelectVariableItemProvider(this);
        }

        return elementSelectVariableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.ElementVariable} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected ElementVariableItemProvider elementVariableItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.ElementVariable}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createElementVariableAdapter() {
        if (elementVariableItemProvider == null) {
            elementVariableItemProvider = new ElementVariableItemProvider(this);
        }

        return elementVariableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.ElementViewVariable} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected ElementViewVariableItemProvider elementViewVariableItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.ElementViewVariable}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createElementViewVariableAdapter() {
        if (elementViewVariableItemProvider == null) {
            elementViewVariableItemProvider = new ElementViewVariableItemProvider(this);
        }

        return elementViewVariableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.ElementDeleteVariable} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    protected ElementDeleteVariableItemProvider elementDeleteVariableItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.ElementDeleteVariable}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createElementDeleteVariableAdapter() {
        if (elementDeleteVariableItemProvider == null) {
            elementDeleteVariableItemProvider = new ElementDeleteVariableItemProvider(this);
        }

        return elementDeleteVariableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.DropContainerVariable} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    protected DropContainerVariableItemProvider dropContainerVariableItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.DropContainerVariable}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDropContainerVariableAdapter() {
        if (dropContainerVariableItemProvider == null) {
            dropContainerVariableItemProvider = new DropContainerVariableItemProvider(this);
        }

        return dropContainerVariableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.SelectContainerVariable} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    protected SelectContainerVariableItemProvider selectContainerVariableItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.SelectContainerVariable}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createSelectContainerVariableAdapter() {
        if (selectContainerVariableItemProvider == null) {
            selectContainerVariableItemProvider = new SelectContainerVariableItemProvider(this);
        }

        return selectContainerVariableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.ContainerViewVariable} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    protected ContainerViewVariableItemProvider containerViewVariableItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.ContainerViewVariable}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createContainerViewVariableAdapter() {
        if (containerViewVariableItemProvider == null) {
            containerViewVariableItemProvider = new ContainerViewVariableItemProvider(this);
        }

        return containerViewVariableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.SelectModelElementVariable} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected SelectModelElementVariableItemProvider selectModelElementVariableItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.SelectModelElementVariable}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createSelectModelElementVariableAdapter() {
        if (selectModelElementVariableItemProvider == null) {
            selectModelElementVariableItemProvider = new SelectModelElementVariableItemProvider(this);
        }

        return selectModelElementVariableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.EditMaskVariables} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected EditMaskVariablesItemProvider editMaskVariablesItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.EditMaskVariables}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createEditMaskVariablesAdapter() {
        if (editMaskVariablesItemProvider == null) {
            editMaskVariablesItemProvider = new EditMaskVariablesItemProvider(this);
        }

        return editMaskVariablesItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.InitialNodeCreationOperation} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected InitialNodeCreationOperationItemProvider initialNodeCreationOperationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.InitialNodeCreationOperation}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createInitialNodeCreationOperationAdapter() {
        if (initialNodeCreationOperationItemProvider == null) {
            initialNodeCreationOperationItemProvider = new InitialNodeCreationOperationItemProvider(this);
        }

        return initialNodeCreationOperationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.InitialOperation} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected InitialOperationItemProvider initialOperationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.InitialOperation}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createInitialOperationAdapter() {
        if (initialOperationItemProvider == null) {
            initialOperationItemProvider = new InitialOperationItemProvider(this);
        }

        return initialOperationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.InitEdgeCreationOperation} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected InitEdgeCreationOperationItemProvider initEdgeCreationOperationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.InitEdgeCreationOperation}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createInitEdgeCreationOperationAdapter() {
        if (initEdgeCreationOperationItemProvider == null) {
            initEdgeCreationOperationItemProvider = new InitEdgeCreationOperationItemProvider(this);
        }

        return initEdgeCreationOperationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.InitialContainerDropOperation} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected InitialContainerDropOperationItemProvider initialContainerDropOperationItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.eclipse.sirius.viewpoint.description.tool.InitialContainerDropOperation}. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createInitialContainerDropOperationAdapter() {
        if (initialContainerDropOperationItemProvider == null) {
            initialContainerDropOperationItemProvider = new InitialContainerDropOperationItemProvider(this);
        }

        return initialContainerDropOperationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.CreateInstance} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected CreateInstanceItemProvider createInstanceItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.CreateInstance}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createCreateInstanceAdapter() {
        if (createInstanceItemProvider == null) {
            createInstanceItemProvider = new CreateInstanceItemProvider(this);
        }

        return createInstanceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.ChangeContext} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected ChangeContextItemProvider changeContextItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.ChangeContext}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createChangeContextAdapter() {
        if (changeContextItemProvider == null) {
            changeContextItemProvider = new ChangeContextItemProvider(this);
        }

        return changeContextItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.sirius.viewpoint.description.tool.SetValue}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected SetValueItemProvider setValueItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.SetValue}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createSetValueAdapter() {
        if (setValueItemProvider == null) {
            setValueItemProvider = new SetValueItemProvider(this);
        }

        return setValueItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.sirius.viewpoint.description.tool.SetObject}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected SetObjectItemProvider setObjectItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.SetObject}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createSetObjectAdapter() {
        if (setObjectItemProvider == null) {
            setObjectItemProvider = new SetObjectItemProvider(this);
        }

        return setObjectItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.sirius.viewpoint.description.tool.Unset}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected UnsetItemProvider unsetItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.Unset}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createUnsetAdapter() {
        if (unsetItemProvider == null) {
            unsetItemProvider = new UnsetItemProvider(this);
        }

        return unsetItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.MoveElement} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected MoveElementItemProvider moveElementItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.MoveElement}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createMoveElementAdapter() {
        if (moveElementItemProvider == null) {
            moveElementItemProvider = new MoveElementItemProvider(this);
        }

        return moveElementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.RemoveElement} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected RemoveElementItemProvider removeElementItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.RemoveElement}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createRemoveElementAdapter() {
        if (removeElementItemProvider == null) {
            removeElementItemProvider = new RemoveElementItemProvider(this);
        }

        return removeElementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.sirius.viewpoint.description.tool.For}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ForItemProvider forItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.For}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createForAdapter() {
        if (forItemProvider == null) {
            forItemProvider = new ForItemProvider(this);
        }

        return forItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.sirius.viewpoint.description.tool.If}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IfItemProvider ifItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.If}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createIfAdapter() {
        if (ifItemProvider == null) {
            ifItemProvider = new IfItemProvider(this);
        }

        return ifItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.sirius.viewpoint.description.tool.DeleteView}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DeleteViewItemProvider deleteViewItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.DeleteView}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDeleteViewAdapter() {
        if (deleteViewItemProvider == null) {
            deleteViewItemProvider = new DeleteViewItemProvider(this);
        }

        return deleteViewItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.NameVariable} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected NameVariableItemProvider nameVariableItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.NameVariable}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createNameVariableAdapter() {
        if (nameVariableItemProvider == null) {
            nameVariableItemProvider = new NameVariableItemProvider(this);
        }

        return nameVariableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.ExternalJavaActionParameter} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ExternalJavaActionParameterItemProvider externalJavaActionParameterItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.ExternalJavaActionParameter}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createExternalJavaActionParameterAdapter() {
        if (externalJavaActionParameterItemProvider == null) {
            externalJavaActionParameterItemProvider = new ExternalJavaActionParameterItemProvider(this);
        }

        return externalJavaActionParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.ToolFilterDescription} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    protected ToolFilterDescriptionItemProvider toolFilterDescriptionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.ToolFilterDescription}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createToolFilterDescriptionAdapter() {
        if (toolFilterDescriptionItemProvider == null) {
            toolFilterDescriptionItemProvider = new ToolFilterDescriptionItemProvider(this);
        }

        return toolFilterDescriptionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.eclipse.sirius.viewpoint.description.tool.FeatureChangeListener} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    protected FeatureChangeListenerItemProvider featureChangeListenerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.FeatureChangeListener}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createFeatureChangeListenerAdapter() {
        if (featureChangeListenerItemProvider == null) {
            featureChangeListenerItemProvider = new FeatureChangeListenerItemProvider(this);
        }

        return featureChangeListenerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.sirius.viewpoint.description.tool.Case}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected CaseItemProvider caseItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.Case}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createCaseAdapter() {
        if (caseItemProvider == null) {
            caseItemProvider = new CaseItemProvider(this);
        }

        return caseItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.sirius.viewpoint.description.tool.Default}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DefaultItemProvider defaultItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.Default}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDefaultAdapter() {
        if (defaultItemProvider == null) {
            defaultItemProvider = new DefaultItemProvider(this);
        }

        return defaultItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.sirius.viewpoint.description.tool.Switch}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected SwitchItemProvider switchItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.Switch}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createSwitchAdapter() {
        if (switchItemProvider == null) {
            switchItemProvider = new SwitchItemProvider(this);
        }

        return switchItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.sirius.viewpoint.description.tool.Let}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected LetItemProvider letItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.Let}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createLetAdapter() {
        if (letItemProvider == null) {
            letItemProvider = new LetItemProvider(this);
        }

        return letItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.sirius.viewpoint.description.tool.GroupMenu}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected GroupMenuItemProvider groupMenuItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.sirius.viewpoint.description.tool.GroupMenu}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createGroupMenuAdapter() {
        if (groupMenuItemProvider == null) {
            groupMenuItemProvider = new GroupMenuItemProvider(this);
        }

        return groupMenuItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public List<IChildCreationExtender> getChildCreationExtenders() {
        return childCreationExtenderManager.getChildCreationExtenders();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
        return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ResourceLocator getResourceLocator() {
        return childCreationExtenderManager;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void dispose() {
        if (toolDescriptionItemProvider != null) {
            toolDescriptionItemProvider.dispose();
        }
        if (pasteDescriptionItemProvider != null) {
            pasteDescriptionItemProvider.dispose();
        }
        if (selectionWizardDescriptionItemProvider != null) {
            selectionWizardDescriptionItemProvider.dispose();
        }
        if (paneBasedSelectionWizardDescriptionItemProvider != null) {
            paneBasedSelectionWizardDescriptionItemProvider.dispose();
        }
        if (menuItemDescriptionReferenceItemProvider != null) {
            menuItemDescriptionReferenceItemProvider.dispose();
        }
        if (operationActionItemProvider != null) {
            operationActionItemProvider.dispose();
        }
        if (externalJavaActionItemProvider != null) {
            externalJavaActionItemProvider.dispose();
        }
        if (externalJavaActionCallItemProvider != null) {
            externalJavaActionCallItemProvider.dispose();
        }
        if (popupMenuItemProvider != null) {
            popupMenuItemProvider.dispose();
        }
        if (acceleoVariableItemProvider != null) {
            acceleoVariableItemProvider.dispose();
        }
        if (elementDropVariableItemProvider != null) {
            elementDropVariableItemProvider.dispose();
        }
        if (elementSelectVariableItemProvider != null) {
            elementSelectVariableItemProvider.dispose();
        }
        if (elementVariableItemProvider != null) {
            elementVariableItemProvider.dispose();
        }
        if (elementViewVariableItemProvider != null) {
            elementViewVariableItemProvider.dispose();
        }
        if (elementDeleteVariableItemProvider != null) {
            elementDeleteVariableItemProvider.dispose();
        }
        if (dropContainerVariableItemProvider != null) {
            dropContainerVariableItemProvider.dispose();
        }
        if (selectContainerVariableItemProvider != null) {
            selectContainerVariableItemProvider.dispose();
        }
        if (containerViewVariableItemProvider != null) {
            containerViewVariableItemProvider.dispose();
        }
        if (selectModelElementVariableItemProvider != null) {
            selectModelElementVariableItemProvider.dispose();
        }
        if (editMaskVariablesItemProvider != null) {
            editMaskVariablesItemProvider.dispose();
        }
        if (initialNodeCreationOperationItemProvider != null) {
            initialNodeCreationOperationItemProvider.dispose();
        }
        if (initialOperationItemProvider != null) {
            initialOperationItemProvider.dispose();
        }
        if (initEdgeCreationOperationItemProvider != null) {
            initEdgeCreationOperationItemProvider.dispose();
        }
        if (initialContainerDropOperationItemProvider != null) {
            initialContainerDropOperationItemProvider.dispose();
        }
        if (createInstanceItemProvider != null) {
            createInstanceItemProvider.dispose();
        }
        if (changeContextItemProvider != null) {
            changeContextItemProvider.dispose();
        }
        if (setValueItemProvider != null) {
            setValueItemProvider.dispose();
        }
        if (setObjectItemProvider != null) {
            setObjectItemProvider.dispose();
        }
        if (unsetItemProvider != null) {
            unsetItemProvider.dispose();
        }
        if (moveElementItemProvider != null) {
            moveElementItemProvider.dispose();
        }
        if (removeElementItemProvider != null) {
            removeElementItemProvider.dispose();
        }
        if (forItemProvider != null) {
            forItemProvider.dispose();
        }
        if (ifItemProvider != null) {
            ifItemProvider.dispose();
        }
        if (deleteViewItemProvider != null) {
            deleteViewItemProvider.dispose();
        }
        if (nameVariableItemProvider != null) {
            nameVariableItemProvider.dispose();
        }
        if (externalJavaActionParameterItemProvider != null) {
            externalJavaActionParameterItemProvider.dispose();
        }
        if (toolFilterDescriptionItemProvider != null) {
            toolFilterDescriptionItemProvider.dispose();
        }
        if (featureChangeListenerItemProvider != null) {
            featureChangeListenerItemProvider.dispose();
        }
        if (caseItemProvider != null) {
            caseItemProvider.dispose();
        }
        if (defaultItemProvider != null) {
            defaultItemProvider.dispose();
        }
        if (switchItemProvider != null) {
            switchItemProvider.dispose();
        }
        if (letItemProvider != null) {
            letItemProvider.dispose();
        }
        if (groupMenuItemProvider != null) {
            groupMenuItemProvider.dispose();
        }
    }

}
