/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.extension.genchain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternFactory;
import org.eclipse.egf.model.pattern.Substitution;
import org.eclipse.egf.portfolio.genchain.extension.DefaultEmfGenerationExtension;
import org.eclipse.egf.portfolio.genchain.generationChain.EmfGeneration;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChainPackage;
import org.eclipse.egf.portfolio.genchain.utils.StringUtils;
import org.eclipse.emf.common.util.URI;
import org.polarsys.capella.extension.genchain.capellaextension.CapellaExtensionFactory;
import org.polarsys.kitalpha.ad.common.utils.URIFix;

public class CapellaGenerationExtension
extends DefaultEmfGenerationExtension {
    private static final URI PATTERN_ECORE = URIFix.createPlatformPluginURI((String)"/org.polarsys.capella.extension.genchain/egf/capellaExtension.fcore#__Az0wCIVEeCuNfuGnuOPDw", (boolean)false);
    private static final URI PATTERN_GENMODEL = URIFix.createPlatformPluginURI((String)"/org.polarsys.capella.extension.genchain/egf/capellaExtension.fcore#_bvRiUCIsEeCkc_7OLLz7bw", (boolean)false);
    private static final List<String> CONFLICT_LIST = Arrays.asList("basic.emf.generation", "emde.emf.generation");

    public List<String> getConflictingExtensions() {
        return CONFLICT_LIST;
    }

    public String getLabel() {
        return "Capella Emf Generation";
    }

    protected void computeDefaultProperties(Map<String, String> context) {
        super.computeDefaultProperties(context);
        String project = context.get("ctx.current.project.name");
        String modelName = context.get("ctx.model.path");
        if (project != null && modelName != null) {
            String base = project;
            int idx = project.lastIndexOf(".");
            if (idx != -1) {
                base = String.valueOf(project.substring(0, idx)) + ".model";
                project = String.valueOf(base) + '.' + modelName;
            }
            this.properties.put(GenerationChainPackage.eINSTANCE.getEmfGeneration_BasePackage(), base.toLowerCase());
            this.properties.put(GenerationChainPackage.eINSTANCE.getEmfGeneration_PluginName(), StringUtils.format1((String)project).toLowerCase());
        }
    }

    public List<Substitution> getSubstitutions() {
        TargetPlatformResourceSet set = new TargetPlatformResourceSet();
        ArrayList<Substitution> substitutions = new ArrayList<Substitution>();
        Substitution substitution = PatternFactory.eINSTANCE.createSubstitution();
        Pattern pattern = (Pattern)set.getEObject(PATTERN_GENMODEL, true);
        substitution.getReplacement().add((Object)pattern);
        pattern = (Pattern)set.getEObject(PATTERN_ECORE, true);
        substitution.getReplacement().add((Object)pattern);
        substitutions.add(substitution);
        return substitutions;
    }

    protected EmfGeneration doCreateEcoreElement() {
        return CapellaExtensionFactory.eINSTANCE.createCapellaEmfGeneration();
    }
}

