/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.studio.product;

import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.splash.BasicSplashHandler;
import org.osgi.framework.Version;

public class CapellaStudioSplashHandler
extends BasicSplashHandler {
    public void init(Shell splash) {
        int foregroundColorInteger;
        super.init(splash);
        String progressRectString = null;
        String messageRectString = null;
        String foregroundColorString = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            progressRectString = product.getProperty("startupProgressRect");
            messageRectString = product.getProperty("startupMessageRect");
            foregroundColorString = product.getProperty("startupForegroundColor");
        }
        Rectangle progressRect = StringConverter.asRectangle((String)progressRectString, (Rectangle)new Rectangle(1, 10, 452, 15));
        this.setProgressRect(progressRect);
        Rectangle messageRect = StringConverter.asRectangle((String)messageRectString, (Rectangle)new Rectangle(10, 35, 300, 25));
        this.setMessageRect(messageRect);
        try {
            foregroundColorInteger = Integer.parseInt(foregroundColorString, 16);
        }
        catch (Exception exception) {
            foregroundColorInteger = 7498662;
        }
        this.setForeground(new RGB((foregroundColorInteger & 0xFF0000) >> 16, (foregroundColorInteger & 0xFF00) >> 8, foregroundColorInteger & 0xFF));
        Version studioVersion = product.getDefiningBundle().getVersion();
        String capellaVersion = "n/a";
        String kitalphaVersion = "n/a";
        IBundleGroupProvider[] iBundleGroupProviderArray = Platform.getBundleGroupProviders();
        int n = iBundleGroupProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleGroupProvider bundleGroupProvider = iBundleGroupProviderArray[n2];
            IBundleGroup[] iBundleGroupArray = bundleGroupProvider.getBundleGroups();
            int n3 = iBundleGroupArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IBundleGroup bundleGroups = iBundleGroupArray[n4];
                if ("org.polarsys.capella.core.advance.feature".equals(bundleGroups.getIdentifier())) {
                    capellaVersion = this.trunkQualifier(bundleGroups.getVersion());
                } else if ("org.polarsys.kitalpha.sdk.feature".equals(bundleGroups.getIdentifier())) {
                    kitalphaVersion = this.trunkQualifier(bundleGroups.getVersion());
                }
                ++n4;
            }
            ++n2;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(studioVersion.getMajor()).append('.');
        builder.append(studioVersion.getMinor()).append('.');
        builder.append(studioVersion.getMicro()).append('.');
        builder.append(studioVersion.getQualifier());
        final String text = builder.toString();
        final String fCapellaVersion = "Capella  " + capellaVersion;
        final String fKitalphaVersion = "Kitalpha " + kitalphaVersion;
        this.getContent().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(new Color((Device)CapellaStudioSplashHandler.this.getSplash().getShell().getDisplay(), new RGB(38, 32, 87)));
                Font newFont = this.computeFont(e, 11);
                e.gc.setFont(newFont);
                e.gc.drawText(text, 325, 185, true);
                e.gc.setForeground(CapellaStudioSplashHandler.this.getForeground());
                newFont = this.computeFont(e, 9);
                e.gc.setFont(newFont);
                e.gc.drawText(fCapellaVersion, 10, 255, true);
                e.gc.drawText(fKitalphaVersion, 10, 275, true);
                newFont.dispose();
            }

            private Font computeFont(PaintEvent e, int height) {
                FontData[] fontData = e.gc.getFont().getFontData();
                int i = 0;
                while (i < fontData.length) {
                    fontData[i].setHeight(height);
                    ++i;
                }
                Font newFont = new Font((Device)e.display, fontData);
                return newFont;
            }
        });
    }

    private String trunkQualifier(String version) {
        int index = version.lastIndexOf(46);
        if (index < 0) {
            return version;
        }
        return version.substring(0, index);
    }
}

