/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.extension.tools.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.portfolio.genchain.generationChain.EmfGeneration;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChain;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChainFactory;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationElement;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.polarsys.capella.extension.tools.ui.Activator;
import org.polarsys.capella.extension.tools.ui.NewExtensionProjectPage;
import org.polarsys.capella.extension.tools.ui.ResourceHelper;

public abstract class NewExtensionProjectWizard
extends Wizard
implements INewWizard {
    protected final TransactionalEditingDomain EDITING_DOMAIN = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
    private final ResourceSet RESOURCE_SET = this.EDITING_DOMAIN.getResourceSet();
    protected NewExtensionProjectPage page;
    protected ISelection selection;
    private static final List<String> ECORE_VIEWPOINTS = new ArrayList<String>();

    static {
        ECORE_VIEWPOINTS.add("Extensibility");
        ECORE_VIEWPOINTS.add("Thales Documentation");
    }

    public NewExtensionProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        final String fileName = this.page.getFileName();
        final String ecorePath = this.page.getEcoreModelPath();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewExtensionProjectWizard.this.doFinish(fileName, ecorePath, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.extension.tools.ui", "", realException));
            return false;
        }
        return true;
    }

    private void doFinish(final String projectName, final String ecorePath, final IProgressMonitor monitor) throws CoreException {
        this.EDITING_DOMAIN.getCommandStack().execute((Command)new RecordingCommand(this.EDITING_DOMAIN){

            protected void doExecute() {
                monitor.beginTask("Creating artifacts for extension " + projectName, 4);
                IProject project = ResourceHelper.createProject(projectName);
                monitor.worked(1);
                String fileName = NewExtensionProjectWizard.this.getFileName(projectName);
                List ecoreResources = NewExtensionProjectWizard.this.getEcoreModel(project, fileName, ecorePath);
                monitor.worked(1);
                Resource genChainResource = NewExtensionProjectWizard.this.getGenChainResource(project, fileName, ecoreResources);
                monitor.worked(1);
                NewExtensionProjectWizard.this.generateDiagrams(project, fileName, ecoreResources, genChainResource);
                monitor.worked(1);
            }
        });
    }

    private String getFileName(String projectName) {
        String[] split = projectName.split("\\.");
        if (split == null || split.length == 0) {
            return projectName;
        }
        return split[split.length - 1];
    }

    private void generateDiagrams(IProject project, String fileName, List<Resource> ecoreResources, Resource genChainResource) {
    }

    private Resource getGenChainResource(IProject project, String fileName, List<Resource> ecoreResources) {
        Resource resource = this.RESOURCE_SET.createResource(URI.createPlatformResourceURI((String)(String.valueOf(project.getName()) + "/model/" + fileName + ".generationchain"), (boolean)false));
        GenerationChain root = GenerationChainFactory.eINSTANCE.createGenerationChain();
        resource.getContents().add((Object)root);
        root.setName(fileName);
        root.setFactoryComponentName(String.valueOf(project.getName()) + ".fc");
        for (Resource ecoreResource : ecoreResources) {
            final GenerationChain chain = GenerationChainFactory.eINSTANCE.createGenerationChain();
            EPackage ePackage = (EPackage)ecoreResource.getContents().get(0);
            chain.setName(ePackage.getName());
            root.getElements().add((Object)chain);
            ArrayList<URI> uriList = new ArrayList<URI>();
            uriList.add(ecoreResource.getURI());
            CompoundCommand command = new CompoundCommand();
            this.addGenerationCommands(chain, uriList, command);
            RecordingCommand command3 = new RecordingCommand(this.EDITING_DOMAIN){

                protected void doExecute() {
                    NewExtensionProjectWizard.this.patch(chain);
                }
            };
            command.append((Command)command3);
            this.EDITING_DOMAIN.getCommandStack().execute((Command)command);
        }
        try {
            resource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resource;
    }

    protected abstract void addGenerationCommands(GenerationChain var1, List<URI> var2, CompoundCommand var3);

    private void patch(GenerationChain chain) {
        for (GenerationElement element : chain.getElements()) {
            if (!(element instanceof EmfGeneration)) continue;
            EmfGeneration model = (EmfGeneration)element;
            model.setGenerateEditor(false);
        }
    }

    private List<Resource> getEcoreModel(IProject project, String resourceName, String ecorePath) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (ecorePath != null && ecorePath.length() != 0) {
            StringTokenizer tokenizer = new StringTokenizer(ecorePath);
            while (tokenizer.hasMoreTokens()) {
                String uri = tokenizer.nextToken();
                Resource resource = this.RESOURCE_SET.getResource(URI.createURI((String)uri), true);
                if (resource == null) continue;
                result.add(resource);
            }
        } else {
            Resource resource = this.RESOURCE_SET.createResource(URI.createPlatformResourceURI((String)(String.valueOf(project.getName()) + "/model/" + resourceName + ".ecore"), (boolean)false));
            EClass elementExtensionCls = (EClass)this.RESOURCE_SET.getEObject(URI.createURI((String)"platform:/plugin/org.polarsys.kitalpha.emde/model/eMDE.ecore#//ElementExtension"), true);
            EClass lcCls = (EClass)this.RESOURCE_SET.getEObject(URI.createURI((String)"platform:/plugin/org.polarsys.capella.core.data.gen/model/LogicalArchitecture.ecore#//LogicalComponent"), true);
            EClass namedElementCls = (EClass)this.RESOURCE_SET.getEObject(URI.createURI((String)"platform:/plugin/org.polarsys.capella.core.data.gen/model/CapellaCore.ecore#//NamedElement"), true);
            EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
            ePackage.setName(resourceName);
            ePackage.setNsPrefix(resourceName);
            ePackage.setNsURI("http://" + resourceName + "/1.0.0");
            EAnnotation anno = EcoreFactory.eINSTANCE.createEAnnotation();
            anno.setSource("http://www.polarsys.org/kitalpha/emde/1.0.0/extension");
            anno.getDetails().put((Object)"extensibleProviderFactory", (Object)"true");
            anno.getDetails().put((Object)"childCreationExtenders", (Object)"true");
            anno.getDetails().put((Object)"useUUIDs", (Object)"true");
            anno.getDetails().put((Object)"useIDAttributes", (Object)"false");
            ePackage.getEAnnotations().add((Object)anno);
            EClass cls1 = EcoreFactory.eINSTANCE.createEClass();
            cls1.setName("InheritanceSample");
            cls1.getESuperTypes().add((Object)lcCls);
            cls1.getESuperTypes().add((Object)elementExtensionCls);
            EClass cls2 = EcoreFactory.eINSTANCE.createEClass();
            cls2.setName("AggregationSample");
            cls2.getESuperTypes().add((Object)namedElementCls);
            cls2.getESuperTypes().add((Object)elementExtensionCls);
            anno = EcoreFactory.eINSTANCE.createEAnnotation();
            anno.setSource("http://www.polarsys.org/kitalpha/emde/1.0.0/constraint");
            anno.getDetails().put((Object)"ExtendedElement", (Object)(String.valueOf(lcCls.getEPackage().getNsURI()) + "#//LogicalComponent"));
            cls2.getEAnnotations().add((Object)anno);
            ePackage.getEClassifiers().add((Object)cls1);
            ePackage.getEClassifiers().add((Object)cls2);
            try {
                resource.getContents().add((Object)ePackage);
                resource.save(null);
                result.add(resource);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

