/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.extension.tools.ui;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Stack;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ResourceHelper {
    private static final String SUFFIX = ",\\";
    private static final String BUILD_PROPERTIES = "build.properties";
    private static final NullProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();
    private static final String SLASH = "/";
    private static final String PREFIX = "source.. =";
    private static final String NEW_LINE = "\n";

    public static boolean checkResource(String path) {
        String outputPath;
        String projectName = ResourceHelper.getProjectName(path);
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        ResourceHelper.createProject(project, true);
                    }
                    catch (Exception exception) {}
                }
            });
        }
        if ((outputPath = ResourceHelper.getOutputPath(projectName, path)).length() > 0) {
            final IFolder folder = project.getFolder((IPath)new Path(outputPath));
            if (!folder.exists()) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ResourceHelper.createFolder(folder, (IProgressMonitor)NULL_PROGRESS_MONITOR);
                        }
                        catch (Exception exception) {}
                    }
                });
            } else {
                return true;
            }
        }
        return false;
    }

    private static IStatus makeFilesWritable(IFile[] files, Object display_p) {
        IStatus result = Status.CANCEL_STATUS;
        Shell shell = null;
        if (display_p instanceof Display) {
            shell = ((Display)display_p).getActiveShell();
        }
        Object context = shell == null ? IWorkspace.VALIDATE_PROMPT : shell;
        result = ResourcesPlugin.getWorkspace().validateEdit(files, context);
        if (!result.isOK()) {
            System.out.println(result.getMessage());
        }
        return result;
    }

    public static IStatus makeFolderWritable(IFolder folder) {
        try {
            int size;
            Collection<IFile> fileList = ResourceHelper.getFiles(folder);
            if (fileList != null && (size = fileList.size()) > 0) {
                File[] files = new File[size];
                Object[] fileArrays = fileList.toArray();
                int i = 0;
                while (i < size) {
                    files[i] = (IFile)fileArrays[i];
                    ++i;
                }
                return ResourceHelper.makeFilesWritable((IFile[])files, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Collection<IFile> getFiles(IFolder folder) throws CoreException {
        if (folder != null && folder.exists()) {
            ArrayList<IFile> list = new ArrayList<IFile>();
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder) {
                    list.addAll(ResourceHelper.getFiles((IFolder)resource));
                }
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    list.add(file);
                }
                ++n2;
            }
            return list;
        }
        return Collections.emptyList();
    }

    private static String getOutputPath(String projectName, String outputDirectoryPath) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = outputDirectoryPath.split(SLASH);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && s.length() > 0 && !s.equals(projectName)) {
                builder.append(SLASH);
                builder.append(s);
            }
            ++n2;
        }
        return builder.toString();
    }

    private static String getProjectName(String outputDirectoryPath) {
        String[] split;
        String[] stringArray = split = outputDirectoryPath.split(SLASH);
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && s.length() > 0) {
                return s;
            }
            ++n2;
        }
        return null;
    }

    private static void createFolder(IFolder folder, IProgressMonitor monitor) throws Exception {
        Stack<IFolder> folderStack = ResourceHelper.getStack(folder);
        while (!folderStack.isEmpty()) {
            IFolder newFolder = folderStack.pop();
            newFolder.create(true, true, monitor);
        }
    }

    private static Stack<IFolder> getStack(IFolder folder) {
        Stack<IFolder> stack = new Stack<IFolder>();
        if (folder != null && !folder.exists()) {
            stack.push(folder);
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                stack.addAll(ResourceHelper.getStack((IFolder)parent));
            }
        }
        return stack;
    }

    private static IProject createProject(IProject project, boolean pde) throws CoreException, JavaModelException {
        project.create(null);
        project.open(null);
        if (pde) {
            ResourceHelper.addNatureToProject(project, "org.eclipse.pde.PluginNature", null);
            ResourceHelper.setupJava(project, true);
            IFolder metaFolder = project.getFolder("META-INF");
            metaFolder.create(true, true, null);
            IFolder modelFolder = project.getFolder("model");
            modelFolder.create(true, true, null);
            ResourceHelper.createManifest(metaFolder, project.getName());
            ResourceHelper.createBuildProperties(project);
        } else {
            ResourceHelper.setupJava(project, false);
        }
        return project;
    }

    public static IProject createProject(String name) {
        block4: {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (!project.exists()) {
                try {
                    return ResourceHelper.createProject(project, true);
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                    break block4;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    break block4;
                }
            }
            return project;
        }
        return null;
    }

    private static void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    private static void setupJava(IProject project, boolean pde) throws CoreException, JavaModelException {
        ResourceHelper.addNatureToProject(project, "org.eclipse.jdt.core.javanature", null);
        IFolder srcFolder = project.getFolder("src");
        srcFolder.create(true, true, null);
        IFolder binFolder = project.getFolder("bin");
        if (!binFolder.exists()) {
            binFolder.create(true, true, null);
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        javaProject.setOutputLocation(binFolder.getFullPath(), null);
        IClasspathEntry[] entries = new IClasspathEntry[pde ? 3 : 1];
        if (pde) {
            String executionEnvironment = "J2SE-1.5";
            ClasspathComputer.setComplianceOptions((IJavaProject)javaProject, (String)executionEnvironment);
            entries[0] = ClasspathComputer.createJREEntry((String)executionEnvironment);
            entries[1] = ClasspathComputer.createContainerEntry();
        }
        entries[entries.length - 1] = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath());
        javaProject.setRawClasspath(entries, null);
    }

    private static void createManifest(IFolder metaFolder, String name) throws CoreException {
        IFile manifest = metaFolder.getFile("MANIFEST.MF");
        StringBuffer contents = new StringBuffer();
        contents.append("Manifest-Version: 1.0\n");
        contents.append("Bundle-ManifestVersion: 2\n");
        contents.append("Bundle-Name: " + name + NEW_LINE);
        contents.append("Bundle-SymbolicName: " + name + ";singleton:=true\n");
        contents.append("Bundle-Version: 1.0.0.qualifier\n");
        contents.append("Bundle-RequiredExecutionEnvironment: J2SE-1.5\n");
        contents.append(NEW_LINE);
        manifest.create((InputStream)new ByteArrayInputStream(contents.toString().getBytes()), false, null);
    }

    private static void createBuildProperties(IProject project) throws CoreException {
        IFile buildProperties = project.getFile(BUILD_PROPERTIES);
        StringBuffer contents = new StringBuffer();
        contents.append("source.. = src/\n");
        contents.append("output.. = bin/\n");
        contents.append("bin.includes = META-INF/,\\\n");
        contents.append("\t\t\t\t.,\\\n");
        contents.append("\t\t\t\tmodel/");
        buildProperties.create((InputStream)new ByteArrayInputStream(contents.toString().getBytes()), false, null);
    }

    public static void addNewSourceFolder(IProject project, IFolder sourceFolder, IProgressMonitor monitor) throws CoreException, IOException {
        if (!sourceFolder.exists()) {
            sourceFolder.create(true, true, monitor);
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] oldRawClasspath = javaProject.getRawClasspath();
        int oldLength = oldRawClasspath.length;
        IClasspathEntry[] newRawClasspath = new IClasspathEntry[oldLength + 1];
        IClasspathEntry newSourceEntry = JavaCore.newSourceEntry((IPath)sourceFolder.getFullPath());
        int i = 0;
        while (i < oldLength) {
            IClasspathEntry entry = oldRawClasspath[i];
            if (entry.equals(newSourceEntry)) {
                return;
            }
            newRawClasspath[i] = entry;
            ++i;
        }
        newRawClasspath[oldLength] = newSourceEntry;
        javaProject.setRawClasspath(newRawClasspath, null);
        IFile file = project.getFile(BUILD_PROPERTIES);
        InputStream inputStream = file.getContents();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line = reader.readLine();
        StringBuilder builder = new StringBuilder();
        while (line != null) {
            builder.append(line);
            if (line.startsWith(PREFIX)) {
                if (!line.endsWith(SUFFIX)) {
                    builder.append(SUFFIX);
                    builder.append(NEW_LINE);
                    builder.append(sourceFolder.getName());
                    builder.append(SLASH);
                } else {
                    builder.append(NEW_LINE);
                    builder.append(sourceFolder.getName());
                    builder.append(SUFFIX);
                }
            }
            builder.append(NEW_LINE);
            line = reader.readLine();
        }
        reader.close();
        file.delete(true, monitor);
        file.create((InputStream)new ByteArrayInputStream(builder.toString().getBytes()), true, monitor);
    }
}

