/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ad.viewpoint.dsl.generation.ui.util;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractFeature;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Class;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.FieldMapping;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIContainer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIField;

public class UISectionUtility {
    public static boolean canGenerateSelectionForContainer(UIContainer container) {
        boolean isSingleClassSection = UISectionUtility.getAssociatedClasses(container).size() == 1;
        boolean isSectionAssociatedToExtension = UISectionUtility.isSectionAssociatedToExtension(container);
        return isSingleClassSection && isSectionAssociatedToExtension;
    }

    public static boolean isSectionAssociatedToExtension(UIContainer container) {
        List<Class> classes = UISectionUtility.getAssociatedClasses(container);
        if (classes != null && classes.size() == 1) {
            Class clazz = classes.get(0);
            return clazz.getExtends() != null && !clazz.getExtends().isEmpty();
        }
        return false;
    }

    private static List<Class> getAssociatedClasses(UIContainer container) {
        BasicEList result = new BasicEList();
        for (UIField iUIField : container.getUI_fields()) {
            Class clazz;
            FieldMapping mapping = iUIField.getMapping();
            if (mapping == null) continue;
            AbstractFeature feature = mapping.getUI_Field_Mapped_To();
            Class clazz2 = clazz = feature != null && feature.eContainer() != null ? (Class)feature.eContainer() : null;
            if (clazz == null || result.contains(clazz)) continue;
            result.add(clazz);
        }
        for (UIContainer subContainer : container.getSubContainers()) {
            List<Class> classes = UISectionUtility.getAssociatedClasses(subContainer);
            for (Class clazz : classes) {
                if (result.contains(clazz)) continue;
                result.add(clazz);
            }
        }
        return result;
    }

    private UISectionUtility() {
    }
}

