/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ad.viewpoint.dsl.generation.ui.util;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnumLiteral;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.capella.ad.viewpoint.dsl.generation.ui.util.GenmodelUtility;
import org.polarsys.capella.ad.viewpoint.dsl.generation.ui.util.PluginExtensionEntry;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractAttributeType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractFeature;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Attribute;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Enumeration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.ExternalAttributeType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.LocalAttributeType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.NamedElement;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.FieldMapping;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UI;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIContainer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIField;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UI_Field_Type;

public class DataWidget {
    public UIField uiField;
    public String widgetName;
    public String widgetLabel;
    public String widgetParentName;
    public String widgetGraphicalClassName;
    public String widgetFieldAccessorName;
    public String widgetFieldGetter;
    public String widgetFieldContainerAccessorName;
    public String widgetFieldContainerLiteral;
    public WidgetEnumerator widgetFieldTypeEnumerator;
    public String widgetFieldETypeName;
    public String widgetFieldETypeLiteral;
    public ArrayList<String> widgetSemanticImports;
    public ArrayList<String> widgetGraphicalImports;
    public ArrayList<String> generatedClassesImports;
    public ArrayList<String> additionalImports;
    public ArrayList<PluginExtensionEntry> PluginExtensionEntries;

    public DataWidget(UIField field) {
        this.uiField = field;
        this.widgetName = this.computeWidgetName();
        this.widgetLabel = this.computeWidgetLabel();
        this.widgetGraphicalClassName = this.computeWidgetClassName();
        this.widgetFieldAccessorName = this.computeWidgetFieldAccessorName();
        this.widgetFieldGetter = this.computeWidgetFieldGetterName();
        this.widgetSemanticImports = this.computeSematicImports();
        this.widgetFieldETypeName = this.computeWidgetFieldETypeName();
        this.widgetFieldETypeLiteral = this.computeWidgetFieldETypeLiteral();
        this.widgetFieldContainerAccessorName = this.computeWidgetFieldContainerAccessorName();
        this.widgetFieldContainerLiteral = this.computeWidgetFieldContainerLiteral();
        this.widgetParentName = this.computeWidgetParentName();
        this.widgetFieldTypeEnumerator = this.initEnumerator();
        this.generatedClassesImports = new ArrayList();
        this.additionalImports = this.computeAdditionalImports();
        this.PluginExtensionEntries = new ArrayList();
    }

    private ArrayList<String> computeAdditionalImports() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.uiField.getType().equals((Object)UI_Field_Type.RICHTEXT)) {
            result.add("org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget");
            result.add("org.polarsys.kitalpha.richtext.widget.factory.MDERichTextFactory");
            result.add("org.polarsys.kitalpha.richtext.common.intf.SaveStrategy");
            result.add("org.polarsys.capella.core.ui.properties.helpers.NotificationHelper");
            result.add("org.polarsys.capella.common.ef.command.AbstractReadWriteCommand");
            result.add("org.polarsys.capella.common.ef.command.ICommand");
            result.add("java.util.Collection");
            result.add("java.util.Collections");
            result.add("org.polarsys.capella.common.helpers.TransactionHelper");
            result.add("org.eclipse.emf.ecore.EStructuralFeature");
            result.add("org.eclipse.swt.SWT");
            result.add("org.eclipse.ui.ISelectionListener");
            result.add("org.eclipse.ui.PlatformUI");
            result.add("org.polarsys.kitalpha.richtext.common.intf.BrowserBasedMDERichTextWidget");
            result.add("org.eclipse.swt.events.DisposeListener");
            result.add("org.eclipse.swt.events.DisposeEvent");
        }
        return result;
    }

    private String computeWidgetParentName() {
        UIContainer uiContainer = (UIContainer)this.uiField.eContainer();
        if (uiContainer.eContainer() instanceof UI) {
            switch (this.uiField.getType()) {
                case SIMPLE_CHOICE_LIST: 
                case MULTIPLE_CHOICE_LIST: {
                    return "getReferencesGroup()";
                }
                case CHECKBOX: {
                    return "getCheckGroup()";
                }
            }
            return "rootParentComposite";
        }
        return uiContainer.getName();
    }

    public WidgetEnumerator initEnumerator() {
        FieldMapping mapping = this.uiField.getMapping();
        AbstractFeature mappedAttribute = mapping.getUI_Field_Mapped_To();
        if (!(mappedAttribute instanceof Attribute)) {
            return null;
        }
        Attribute attribute = (Attribute)mappedAttribute;
        AbstractAttributeType attributeType = attribute.getOwned_type();
        String enumName = "";
        GenEnum genEnum = null;
        if (attributeType instanceof LocalAttributeType) {
            LocalAttributeType localAttributeType = (LocalAttributeType)attributeType;
            Enumeration type = localAttributeType.getType();
            enumName = type.getName();
            genEnum = GenmodelUtility.getInstance().getGenEnum(enumName);
        } else {
            EDataType externalAttributeType = ((ExternalAttributeType)attributeType).getType();
            String attributeTypeName = externalAttributeType.getName();
            if (!attributeTypeName.equals("EEnumerator") && !(externalAttributeType instanceof EEnum)) {
                return null;
            }
            if (attributeTypeName.equals("EEnumerator")) {
                enumName = String.valueOf(attribute.getName()) + "_Type";
                genEnum = GenmodelUtility.getInstance().getGenEnum(enumName);
            } else {
                enumName = attributeTypeName;
                String enumEPackageNSURI = externalAttributeType.getEPackage().getNsURI().toString();
                URI genModelURI = (URI)EcorePlugin.getEPackageNsURIToGenModelLocationMap().get(enumEPackageNSURI);
                ResourceSetImpl rs = new ResourceSetImpl();
                Resource r = rs.createResource(genModelURI);
                try {
                    r.load(null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (GenPackage genPackage : ((GenModel)r.getContents().get(0)).getGenPackages()) {
                    for (GenEnum iGenEnum : genPackage.getGenEnums()) {
                        if (!iGenEnum.getName().toLowerCase().equals(enumName.toLowerCase()) || !enumEPackageNSURI.equals(genPackage.getEcorePackage().getNsURI())) continue;
                        genEnum = iGenEnum;
                        break;
                    }
                    if (genEnum != null) break;
                    block4: for (GenPackage nestedGenPackage : genPackage.getNestedGenPackages()) {
                        for (GenEnum nestedGenEnum : nestedGenPackage.getGenEnums()) {
                            if (!nestedGenEnum.getName().toLowerCase().equals(enumName.toLowerCase())) continue;
                            genEnum = nestedGenEnum;
                            continue block4;
                        }
                    }
                    if (genEnum != null) break;
                }
            }
        }
        if (genEnum == null) {
            return null;
        }
        String genEnumName = genEnum.getClassifierAccessorName();
        String importName = genEnum.getQualifiedName();
        ArrayList<String> genEnumLiteralsList = new ArrayList<String>();
        for (GenEnumLiteral iGenEnumLiteral : genEnum.getGenEnumLiterals()) {
            genEnumLiteralsList.add(iGenEnumLiteral.getEnumLiteralInstanceConstantName());
        }
        return new WidgetEnumerator(genEnumName, importName, genEnumLiteralsList);
    }

    public String computeWidgetFieldETypeEPackage() {
        String ePackageImport = "";
        try {
            ePackageImport = GenmodelUtility.getInstance().getFeatureETypeEPackageImport((NamedElement)this.uiField.getMapping().getUI_Field_Mapped_To());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ePackageImport;
    }

    private String computeWidgetFieldContainerAccessorName() {
        String containerAccessorName = "";
        try {
            containerAccessorName = GenmodelUtility.getInstance().getFeatureContainerAccessorName(this.uiField.getMapping().getUI_Field_Mapped_To());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return containerAccessorName;
    }

    private String computeWidgetFieldContainerLiteral() {
        String containerLiteral = "";
        try {
            containerLiteral = GenmodelUtility.getInstance().getFeatureContainerLiteral(this.uiField.getMapping().getUI_Field_Mapped_To());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return containerLiteral;
    }

    private String computeWidgetFieldETypeLiteral() {
        String eTypeName = "";
        try {
            eTypeName = GenmodelUtility.getInstance().getFeatureETypeLiteral((NamedElement)this.uiField.getMapping().getUI_Field_Mapped_To());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return eTypeName;
    }

    private String computeWidgetFieldETypeName() {
        String eTypeName = "";
        try {
            eTypeName = GenmodelUtility.getInstance().getFeatureETypeName((NamedElement)this.uiField.getMapping().getUI_Field_Mapped_To());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return eTypeName;
    }

    private String computeWidgetFieldGetterName() {
        String accessorName = "";
        try {
            accessorName = GenmodelUtility.getInstance().getFeatureShortAccessorName(this.uiField.getMapping().getUI_Field_Mapped_To());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "get" + accessorName + "()";
    }

    private String computeWidgetFieldAccessorName() {
        String accessorName = "";
        try {
            accessorName = GenmodelUtility.getInstance().getFeatureLongAccessorName((NamedElement)this.uiField.getMapping().getUI_Field_Mapped_To());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(GenmodelUtility.getInstance().getPackageAccessorName()) + ".eINSTANCE.get" + accessorName + "()";
    }

    private ArrayList<String> computeSematicImports() {
        String sematicEClassImport;
        ArrayList<String> result = new ArrayList<String>();
        String packageImport = GenmodelUtility.getInstance().getPackageImport();
        if (packageImport != null) {
            result.add(packageImport);
        }
        if ((sematicEClassImport = GenmodelUtility.getInstance().getSemanticEClassImport((NamedElement)this.uiField.getMapping().getUI_Field_Mapped_To())) != null) {
            result.add(sematicEClassImport);
        }
        return result;
    }

    private String computeWidgetLabel() {
        String label = this.uiField.getLabel();
        return label != null && label.trim().length() > 0 ? label : this.widgetName;
    }

    private String computeWidgetName() {
        String widgetNameTmp = this.uiField.getName();
        if (widgetNameTmp == null || widgetNameTmp.trim().length() == 0) {
            widgetNameTmp = String.valueOf(this.uiField.getMapping().getUI_Field_Mapped_To().getName()) + "__" + this.uiField.getType().toString();
        }
        char first = Character.toUpperCase(widgetNameTmp.charAt(0));
        widgetNameTmp = String.valueOf(first) + widgetNameTmp.substring(1);
        return widgetNameTmp;
    }

    private String computeWidgetClassName() {
        switch (this.uiField.getType()) {
            case TEXT: {
                return "TextValueGroup";
            }
            case TEXTAREA: {
                return "TextAreaValueGroup";
            }
            case RICHTEXT: {
                return "MDERichTextWidget";
            }
            case CHECKBOX: {
                String checkbox_name = String.valueOf(this.uiField.getName()) + "_semanticCheckboxGroup";
                char checkbox_first = Character.toUpperCase(checkbox_name.charAt(0));
                checkbox_name = String.valueOf(checkbox_first) + checkbox_name.substring(1);
                return checkbox_name;
            }
            case RADIOBOX: {
                String radiobox_name = String.valueOf(this.uiField.getName()) + "_semanticKindGroup";
                char radiobox_first = Character.toUpperCase(radiobox_name.charAt(0));
                radiobox_name = String.valueOf(radiobox_first) + radiobox_name.substring(1);
                return radiobox_name;
            }
            case SIMPLE_CHOICE_LIST: {
                return "SimpleSemanticField";
            }
            case MULTIPLE_CHOICE_LIST: {
                return "MultipleSemanticField";
            }
        }
        return null;
    }

    public class WidgetEnumerator {
        public String enumName;
        public String enumImportName;
        public ArrayList<String> enumLiterals;

        public WidgetEnumerator(String name, String importName, ArrayList<String> literals) {
            this.enumName = name;
            this.enumImportName = importName;
            this.enumLiterals = literals;
        }
    }
}

