/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.extension.tools;

import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.extension.tools.HelperClassGenerator;
import org.polarsys.capella.extension.tools.MenuContributorClassGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SectionClassGenerator {
    public static boolean needSection(GenClass model) {
        for (EClass parent : model.getEcoreClass().getESuperTypes()) {
            if (!CapellacorePackage.eINSTANCE.getNsURI().equals(parent.getEPackage().getNsURI()) || !CapellacorePackage.eINSTANCE.getNamedElement().getName().equals(parent.getName())) continue;
            return true;
        }
        return false;
    }

    public static String getClassname(GenClass model) {
        return String.valueOf(model.getInterfaceName()) + "Section";
    }

    public static String getFilterTest(GenClass model) {
        GenPackage genPackage = model.getGenPackage();
        return "obj != null && obj.eClass().equals(" + genPackage.getInterfacePackageName() + '.' + genPackage.getBasicPackageName() + ".eINSTANCE.get" + model.getEcoreClass().getName() + "())";
    }

    public static String getPackagename(GenClass model) {
        return String.valueOf(model.getGenPackage().getProviderPackageName()) + ".sections";
    }

    public static String getFullClassname(GenClass model) {
        return String.valueOf(model.getGenPackage().getQualifiedPackageName()) + '.' + model.getEcoreClass().getName();
    }

    public static String getFullSectionClassname(GenClass model) {
        return String.valueOf(SectionClassGenerator.getPackagename(model)) + '.' + model.getEcoreClass().getName() + "Section";
    }

    public static void declareSections(Element root, GenModel genModel) {
        GenClass genClass;
        HelperClassGenerator.HelperInfo info;
        EObject obj;
        Document doc = root.getOwnerDocument();
        Element extension = SectionClassGenerator.createExtensionNode(root, doc);
        Element itemContribution = doc.createElement("propertySections");
        itemContribution.setAttribute("contributorId", "org.polarsys.capella.core.data.capellamodeller.properties");
        itemContribution.appendChild(doc.createTextNode("\n"));
        TreeIterator eAllContents = genModel.eAllContents();
        while (eAllContents.hasNext()) {
            obj = (EObject)eAllContents.next();
            if (!(obj instanceof GenClass) || (info = HelperClassGenerator.getInfo((genClass = (GenClass)obj).getEcoreClass())) == null || info.getSectionClass() == null) continue;
            Element subItemContribution = doc.createElement("propertySection");
            subItemContribution.setAttribute("class", info.getSectionClass());
            subItemContribution.setAttribute("filter", SectionClassGenerator.getFullSectionClassname(genClass));
            subItemContribution.setAttribute("id", String.valueOf(MenuContributorClassGenerator.getFullClassname(genClass)) + ".section");
            subItemContribution.setAttribute("tab", "BaseCapella");
            itemContribution.appendChild(doc.createTextNode("        "));
            itemContribution.appendChild(subItemContribution);
            itemContribution.appendChild(doc.createTextNode("\n"));
            Element input = doc.createElement("input");
            GenPackage genPackage = genClass.getGenPackage();
            input.setAttribute("type", String.valueOf(genPackage.getInterfacePackageName()) + "." + genClass.getName());
            subItemContribution.appendChild(doc.createTextNode("\n"));
            subItemContribution.appendChild(doc.createTextNode("            "));
            subItemContribution.appendChild(input);
            subItemContribution.appendChild(doc.createTextNode("\n"));
            subItemContribution.appendChild(doc.createTextNode("        "));
        }
        extension.appendChild(itemContribution);
        extension.appendChild(doc.createTextNode("\n"));
        extension.appendChild(doc.createTextNode("    "));
        extension = SectionClassGenerator.createExtensionNode(root, doc);
        itemContribution = doc.createElement("propertySections");
        itemContribution.setAttribute("contributorId", "org.eclipse.sirius.diagram.ui");
        itemContribution.appendChild(doc.createTextNode("\n"));
        eAllContents = genModel.eAllContents();
        while (eAllContents.hasNext()) {
            obj = (EObject)eAllContents.next();
            if (!(obj instanceof GenClass) || (info = HelperClassGenerator.getInfo((genClass = (GenClass)obj).getEcoreClass())) == null || info.getSectionClass() == null) continue;
            boolean needSection = SectionClassGenerator.needSection(genClass);
            Element subItemContribution = doc.createElement("propertySection");
            subItemContribution.setAttribute("class", needSection ? SectionClassGenerator.getFullSectionClassname(genClass) : info.getSectionClass());
            subItemContribution.setAttribute("filter", SectionClassGenerator.getFullSectionClassname(genClass));
            subItemContribution.setAttribute("id", String.valueOf(SectionClassGenerator.getFullSectionClassname(genClass)) + ".section");
            subItemContribution.setAttribute("tab", "BaseSiriusDiagram");
            itemContribution.appendChild(doc.createTextNode("        "));
            itemContribution.appendChild(subItemContribution);
            itemContribution.appendChild(doc.createTextNode("\n"));
            subItemContribution.appendChild(doc.createTextNode("\n"));
            subItemContribution.appendChild(doc.createTextNode("        "));
        }
        extension.appendChild(itemContribution);
        extension.appendChild(doc.createTextNode("\n"));
        extension.appendChild(doc.createTextNode("    "));
    }

    private static Element createExtensionNode(Element root, Document doc) {
        root.appendChild(doc.createTextNode("\n"));
        root.appendChild(doc.createComment("@generated"));
        root.appendChild(doc.createTextNode("\n  "));
        Element extension = doc.createElement("extension");
        extension.setAttribute("point", "org.eclipse.ui.views.properties.tabbed.propertySections");
        extension.appendChild(doc.createTextNode("\n"));
        extension.appendChild(doc.createTextNode("    "));
        root.appendChild(extension);
        root.appendChild(doc.createTextNode("\n"));
        return extension;
    }

    private SectionClassGenerator() {
    }
}

