/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.extension.tools.ui;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.presentation.EcoreActionBarContributor;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.extension.tools.ui.Activator;

public class NewExtensionProjectPage
extends WizardPage {
    private static final String SPACE = " ";
    private static final String ECORE_EXTENSION = "ecore";
    private Text fileText;
    private ISelection selection;
    private Text ecoreText;
    private final String defaultProjectName;

    public NewExtensionProjectPage(ISelection selection, String defaultProjectName) {
        super("wizardPage");
        this.setTitle("Capella extension wizard");
        this.setDescription("This wizard creates a Capella metamodel extension.");
        this.setImageDescriptor(Activator.getImageDescriptor("icons/capellaExtensionProject.png"));
        this.selection = selection;
        this.defaultProjectName = defaultProjectName;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        this.createFirstLine(container);
        this.createSecondLine(container);
        this.dialogChanged();
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.initialize();
    }

    private void createSecondLine(Composite container) {
        GridData gd = new GridData(768);
        Label label = new Label(container, 0);
        label.setText("&Extension model:");
        this.ecoreText = new Text(container, 2052);
        this.ecoreText.setLayoutData((Object)gd);
        this.ecoreText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewExtensionProjectPage.this.ecoreDialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("Load ...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = NewExtensionProjectPage.this.ecoreText.getText();
                String result = NewExtensionProjectPage.this.loadEcoreResource(text);
                NewExtensionProjectPage.this.ecoreText.setText(result);
            }
        });
    }

    private String loadEcoreResource(String string) {
        MyExtendedLoadResourceDialog loadResourceDialog = new MyExtendedLoadResourceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null);
        loadResourceDialog.create();
        if (string != null) {
            loadResourceDialog.setText(string);
        }
        loadResourceDialog.open();
        return loadResourceDialog.getURIText();
    }

    private void createFirstLine(Composite container) {
        GridData gd = new GridData(768);
        Label label = new Label(container, 0);
        label.setText("&Project name:");
        this.fileText = new Text(container, 2052);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewExtensionProjectPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("");
    }

    private void initialize() {
        this.fileText.setText(this.defaultProjectName);
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            Iterator iterator = ssel.iterator();
            StringBuilder builder = new StringBuilder();
            while (iterator.hasNext()) {
                IFile file;
                Object next = iterator.next();
                if (!(next instanceof IFile) || !ECORE_EXTENSION.equals((file = (IFile)next).getFileExtension())) continue;
                URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
                builder.append(uri.toString());
                builder.append(SPACE);
            }
            this.ecoreText.setText(builder.toString());
        }
    }

    private void dialogChanged() {
        String fileName = this.getFileName();
        if (fileName.length() == 0) {
            this.updateStatus("Extension name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("Extension name must be valid");
            return;
        }
        if (fileName.contains(SPACE)) {
            this.updateStatus("Extension name must be valid");
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(fileName);
        if (project != null && project.exists()) {
            this.updateStatus("Project is already existing.");
            return;
        }
        this.updateStatus(null);
    }

    private void ecoreDialogChanged() {
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getEcoreModelPath() {
        return this.ecoreText.getText();
    }

    private static class MyExtendedLoadResourceDialog
    extends EcoreActionBarContributor.ExtendedLoadResourceAction.ExtendedLoadResourceDialog {
        public MyExtendedLoadResourceDialog(Shell arg0, EditingDomain arg1) {
            super(arg0, arg1);
        }

        public void setText(String text) {
            this.uriField.setText(text);
        }
    }
}

