/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.p2.maven.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.b3.util.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;

public class VersionUtil {
    private static Pattern versionRangePattern = Pattern.compile("^(\\([)([^,]+),([^,]+)(\\)])$");
    private static final Pattern timestampPattern = Pattern.compile("^((?:19|20)\\d{2}(?:0[1-9]|1[012])(?:0[1-9]|[12][0-9]|3[01]))(?:\\.((?:[01][0-9]|2[0-3])[0-5][0-9][0-5][0-9]))?$");
    private static final Pattern mavenTrickPattern = Pattern.compile("^\\d+\\.\\d+\\.\\d+(?:\\.\\d+-[a-zA-Z][a-zA-Z0-9_]*)?$");
    private static final Pattern osgiPattern = Pattern.compile("^(\\d+\\.\\d+\\.\\d+)\\.([a-zA-Z0-9_-]+)$");

    public static Version createVersion(String versionStr) throws CoreException {
        if ((versionStr = StringUtils.trimmedOrNull((String)versionStr)) == null) {
            return null;
        }
        Matcher m = timestampPattern.matcher(versionStr);
        if (m.matches()) {
            return VersionUtil.createVersionFromFormatAndOriginal("S=[0-9];={8};[.S=[0-9];={6};='000000';]", versionStr);
        }
        try {
            return VersionUtil.createVersionFromFormatAndOriginal("n[.n=0;[.n=0;]][d?S=M;]", versionStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return VersionUtil.createVersionFromFormatAndOriginal("S", versionStr);
        }
    }

    public static Version createVersionFromFormatAndOriginal(String format, String versionStr) {
        return Version.parseVersion((String)("format(" + format + "):" + versionStr));
    }

    public static VersionRange createVersionRange(String versionRangeString) throws CoreException {
        String vr = StringUtils.trimmedOrNull((String)versionRangeString);
        if (vr == null) {
            return VersionRange.emptyRange;
        }
        Matcher m = versionRangePattern.matcher(vr);
        if (m.matches()) {
            return new VersionRange(VersionUtil.createVersion(m.group(2)), "[".equals(m.group(1)), VersionUtil.createVersion(m.group(3)), "[".equals(m.group(4)));
        }
        Version v = VersionUtil.createVersion(vr);
        return new VersionRange(v, true, Version.MAX_VERSION, true);
    }

    public static String getVersionString(Version version) {
        String versionString = version.getOriginal();
        if (versionString == null) {
            versionString = version.toString();
        }
        return versionString;
    }

    public static String getVersionString(Version version, boolean strictMavenVersions) {
        String versionString = VersionUtil.getVersionString(version);
        if (!strictMavenVersions) {
            return versionString;
        }
        Matcher m = mavenTrickPattern.matcher(versionString);
        if (m.matches()) {
            return versionString;
        }
        m = osgiPattern.matcher(versionString);
        if (!m.matches()) {
            return versionString;
        }
        StringBuilder bld = new StringBuilder();
        bld.append(m.group(1));
        bld.append('-');
        bld.append(m.group(2));
        return bld.toString();
    }
}

