/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.impl;

import java.util.Collection;
import org.eclipse.b3.aggregator.Aggregation;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.AggregatorPackage;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.DescriptionProvider;
import org.eclipse.b3.aggregator.IdentificationProvider;
import org.eclipse.b3.aggregator.InfosProvider;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.Status;
import org.eclipse.b3.aggregator.StatusCode;
import org.eclipse.b3.aggregator.StatusProvider;
import org.eclipse.b3.aggregator.ValidationSet;
import org.eclipse.b3.aggregator.impl.ContributionImpl;
import org.eclipse.b3.aggregator.util.GeneralUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class ValidationSetImpl
extends MinimalEObjectImpl.Container
implements ValidationSet {
    protected int eFlags = 0;
    protected static final boolean BRANCH_ENABLED_EDEFAULT = false;
    protected static final boolean ENABLED_EDEFAULT = true;
    protected static final int ENABLED_EFLAG = 1;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    protected EList<String> errors;
    protected EList<String> warnings;
    protected EList<String> infos;
    protected static final boolean ABSTRACT_EDEFAULT = false;
    protected static final boolean EXTENSION_EDEFAULT = false;
    protected static final String LABEL_EDEFAULT = null;
    protected String label = LABEL_EDEFAULT;
    protected EList<Contribution> contributions;
    protected EList<MetadataRepositoryReference> validationRepositories;
    protected EList<ValidationSet> extends_;

    protected ValidationSetImpl() {
        this.eFlags |= 1;
    }

    private void addContributions(EList<Contribution> receiver) {
        for (Contribution contrib : this.getContributions()) {
            if (!contrib.isEnabled()) continue;
            receiver.add((Object)contrib);
        }
        if (this.extends_ != null) {
            for (ValidationSet ex : this.extends_) {
                if (!ex.isEnabled()) continue;
                ((ValidationSetImpl)ex).addContributions(receiver);
            }
        }
    }

    private void addValidationRepositories(EList<MetadataRepositoryReference> receiver) {
        for (MetadataRepositoryReference repo : this.getValidationRepositories()) {
            if (!repo.isEnabled()) continue;
            receiver.add((Object)repo);
        }
        if (this.extends_ != null) {
            for (ValidationSet ex : this.extends_) {
                if (!ex.isEnabled()) continue;
                ((ValidationSetImpl)ex).addValidationRepositories(receiver);
            }
        }
    }

    void clearStatus() {
        Status oldStatus = this.getStatus();
        for (Contribution contribution : this.getContributions()) {
            ((ContributionImpl)contribution).setStatus(null);
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldStatus, null));
        }
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == DescriptionProvider.class) {
            switch (derivedFeatureID) {
                case 2: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == StatusProvider.class) {
            switch (derivedFeatureID) {
                case 3: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == InfosProvider.class) {
            switch (derivedFeatureID) {
                case 4: {
                    return 0;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 2;
                }
            }
            return -1;
        }
        if (baseClass == IdentificationProvider.class) {
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == DescriptionProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 2;
                }
            }
            return -1;
        }
        if (baseClass == StatusProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 3;
                }
            }
            return -1;
        }
        if (baseClass == InfosProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 4;
                }
                case 1: {
                    return 5;
                }
                case 2: {
                    return 6;
                }
            }
            return -1;
        }
        if (baseClass == IdentificationProvider.class) {
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isBranchEnabled();
            }
            case 1: {
                return this.isEnabled();
            }
            case 2: {
                return this.getDescription();
            }
            case 3: {
                return this.getStatus();
            }
            case 4: {
                return this.getErrors();
            }
            case 5: {
                return this.getWarnings();
            }
            case 6: {
                return this.getInfos();
            }
            case 7: {
                return this.isAbstract();
            }
            case 8: {
                return this.isExtension();
            }
            case 9: {
                return this.getLabel();
            }
            case 10: {
                return this.getContributions();
            }
            case 11: {
                return this.getValidationRepositories();
            }
            case 12: {
                return this.getExtends();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 10: {
                return ((InternalEList)this.getContributions()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return ((InternalEList)this.getValidationRepositories()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.isSetBranchEnabled();
            }
            case 1: {
                return (this.eFlags & 1) == 0;
            }
            case 2: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 3: {
                return this.getStatus() != null;
            }
            case 4: {
                return this.errors != null && !this.errors.isEmpty();
            }
            case 5: {
                return this.warnings != null && !this.warnings.isEmpty();
            }
            case 6: {
                return this.infos != null && !this.infos.isEmpty();
            }
            case 7: {
                return this.isSetAbstract();
            }
            case 8: {
                return this.isSetExtension();
            }
            case 9: {
                return LABEL_EDEFAULT == null ? this.label != null : !LABEL_EDEFAULT.equals(this.label);
            }
            case 10: {
                return this.contributions != null && !this.contributions.isEmpty();
            }
            case 11: {
                return this.validationRepositories != null && !this.validationRepositories.isEmpty();
            }
            case 12: {
                return this.extends_ != null && !this.extends_.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setEnabled((Boolean)newValue);
                return;
            }
            case 2: {
                this.setDescription((String)newValue);
                return;
            }
            case 4: {
                this.getErrors().clear();
                this.getErrors().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getWarnings().clear();
                this.getWarnings().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getInfos().clear();
                this.getInfos().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.setLabel((String)newValue);
                return;
            }
            case 10: {
                this.getContributions().clear();
                this.getContributions().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.getValidationRepositories().clear();
                this.getValidationRepositories().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getExtends().clear();
                this.getExtends().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    protected EClass eStaticClass() {
        return AggregatorPackage.Literals.VALIDATION_SET;
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setEnabled(true);
                return;
            }
            case 2: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 4: {
                this.getErrors().clear();
                return;
            }
            case 5: {
                this.getWarnings().clear();
                return;
            }
            case 6: {
                this.getInfos().clear();
                return;
            }
            case 9: {
                this.setLabel(LABEL_EDEFAULT);
                return;
            }
            case 10: {
                this.getContributions().clear();
                return;
            }
            case 11: {
                this.getValidationRepositories().clear();
                return;
            }
            case 12: {
                this.getExtends().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public Aggregation getAggregation() {
        return (Aggregation)this.eContainer();
    }

    @Override
    public EList<Contribution> getAllContributions() {
        if (this.extends_ == null || this.extends_.isEmpty()) {
            return this.getDeclaredContributions();
        }
        UniqueEList.FastCompare all = new UniqueEList.FastCompare();
        this.addContributions((EList<Contribution>)all);
        return all;
    }

    @Override
    public EList<MetadataRepositoryReference> getAllValidationRepositories() {
        if (this.extends_ == null || this.extends_.isEmpty()) {
            return this.getDeclaredValidationRepositories();
        }
        UniqueEList.FastCompare all = new UniqueEList.FastCompare();
        this.addValidationRepositories((EList<MetadataRepositoryReference>)all);
        return all;
    }

    @Override
    public EList<Contribution> getContributions() {
        if (this.contributions == null) {
            this.contributions = new EObjectContainmentEList.Resolving(Contribution.class, (InternalEObject)this, 10);
        }
        return this.contributions;
    }

    @Override
    public EList<Contribution> getDeclaredContributions() {
        return GeneralUtils.getEnabled(this.getContributions());
    }

    @Override
    public EList<MetadataRepositoryReference> getDeclaredValidationRepositories() {
        return GeneralUtils.getEnabled(this.getValidationRepositories());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public EList<String> getErrors() {
        if (this.errors == null) {
            this.errors = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 4);
        }
        return this.errors;
    }

    @Override
    public EList<ValidationSet> getExtends() {
        if (this.extends_ == null) {
            this.extends_ = new EObjectResolvingEList(ValidationSet.class, (InternalEObject)this, 12);
        }
        return this.extends_;
    }

    @Override
    public String getIdentification() {
        return this.getLabel();
    }

    @Override
    public EList<String> getInfos() {
        if (this.infos == null) {
            this.infos = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 6);
        }
        return this.infos;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Status getStatus() {
        StatusCode statusCode;
        if (this.extends_ != null) {
            for (ValidationSet ex : this.extends_) {
                if (!ex.isEnabled() || (statusCode = ex.getStatus().getCode()) == StatusCode.OK || statusCode == StatusCode.WAITING) continue;
                return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
            }
        }
        for (Contribution contribution : this.getDeclaredContributions()) {
            statusCode = contribution.getStatus().getCode();
            if (statusCode == StatusCode.OK || statusCode == StatusCode.WAITING) continue;
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
        }
        for (MetadataRepositoryReference repo : this.getDeclaredValidationRepositories()) {
            statusCode = repo.getStatus().getCode();
            if (statusCode == StatusCode.OK || statusCode == StatusCode.WAITING) continue;
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
        }
        return AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);
    }

    @Override
    public EList<MetadataRepositoryReference> getValidationRepositories() {
        if (this.validationRepositories == null) {
            this.validationRepositories = new EObjectContainmentEList.Resolving(MetadataRepositoryReference.class, (InternalEObject)this, 11);
        }
        return this.validationRepositories;
    }

    @Override
    public EList<String> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 5);
        }
        return this.warnings;
    }

    @Override
    public boolean isAbstract() {
        if (this.isEnabled()) {
            for (ValidationSet vs : this.getAggregation().getValidationSets(true)) {
                if (vs == this || !vs.isExtensionOf(this)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isBranchEnabled() {
        return GeneralUtils.isBranchEnabled(this);
    }

    @Override
    public boolean isEnabled() {
        return (this.eFlags & 1) != 0;
    }

    @Override
    public boolean isExtension() {
        return this.extends_ != null && !this.extends_.isEmpty();
    }

    @Override
    public boolean isExtensionOf(ValidationSet validationSet) {
        if (validationSet == null) {
            return false;
        }
        if (validationSet == this) {
            return true;
        }
        if (this.extends_ == null) {
            return false;
        }
        for (ValidationSet vs : this.extends_) {
            if (!vs.isExtensionOf(validationSet)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSetAbstract() {
        return true;
    }

    @Override
    public boolean isSetBranchEnabled() {
        return true;
    }

    @Override
    public boolean isSetExtension() {
        return true;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldDescription, (Object)this.description));
        }
    }

    @Override
    public void setEnabled(boolean newEnabled) {
        boolean oldEnabled;
        boolean bl = oldEnabled = (this.eFlags & 1) != 0;
        this.eFlags = newEnabled ? (this.eFlags |= 1) : (this.eFlags &= 0xFFFFFFFE);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldEnabled, newEnabled));
        }
    }

    @Override
    public void setLabel(String newLabel) {
        String oldLabel = this.label;
        this.label = newLabel;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldLabel, (Object)this.label));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (enabled: ");
        result.append((this.eFlags & 1) != 0);
        result.append(", description: ");
        result.append(this.description);
        result.append(", errors: ");
        result.append(this.errors);
        result.append(", warnings: ");
        result.append(this.warnings);
        result.append(", infos: ");
        result.append(this.infos);
        result.append(", label: ");
        result.append(this.label);
        result.append(')');
        return result.toString();
    }
}

