/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.p2.loader.impl;

import java.io.IOException;
import java.net.URI;
import org.eclipse.b3.p2.impl.MetadataRepositoryImpl;
import org.eclipse.b3.p2.loader.IRepositoryLoader;
import org.eclipse.b3.p2.util.P2Bridge;
import org.eclipse.b3.p2.util.P2Utils;
import org.eclipse.b3.util.LogUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class P2RepositoryLoader
implements IRepositoryLoader {
    private IProvisioningAgent agent;
    private URI location;
    private MetadataRepositoryImpl repository;
    private IMetadataRepositoryManager mdrMgr;

    @Override
    public void close() {
        P2Utils.ungetRepositoryManager(this.agent, this.mdrMgr);
    }

    @Override
    public IArtifactRepository getArtifactRepository(IMetadataRepository mdr, IProgressMonitor monitor) throws CoreException {
        IArtifactRepositoryManager arMgr = null;
        try {
            arMgr = P2Utils.getRepositoryManager(this.agent, IArtifactRepositoryManager.class);
            IArtifactRepository iArtifactRepository = arMgr.loadRepository(mdr.getLocation(), monitor);
            return iArtifactRepository;
        }
        finally {
            P2Utils.ungetRepositoryManager(this.agent, arMgr);
        }
    }

    @Override
    public void load(IProgressMonitor monitor) throws CoreException {
        this.load(monitor, false);
    }

    private void load(IProgressMonitor monitor, boolean avoidCache) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IMetadataRepository repo = null;
        int i = 2;
        while (i >= 0) {
            try {
                if (avoidCache) {
                    if (this.mdrMgr.contains(this.location)) {
                        repo = this.mdrMgr.refreshRepository(this.location, (IProgressMonitor)subMon.newChild(80));
                        break;
                    }
                    try {
                        this.mdrMgr.refreshRepository(this.location, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (ProvisionException provisionException) {}
                    repo = this.mdrMgr.loadRepository(this.location, (IProgressMonitor)subMon.newChild(80));
                    break;
                }
                repo = this.mdrMgr.loadRepository(this.location, (IProgressMonitor)subMon.newChild(80));
                break;
            }
            catch (ProvisionException e) {
                Throwable t = e.getCause();
                if (i > 0 && t instanceof IOException && t.getMessage() != null && t.getMessage().contains("SAX parser service")) {
                    LogUtils.warning((String)"Error loading repository: %s Trying to recover (attempts remaining: %d)", (Object[])new Object[]{t.getMessage(), i});
                    try {
                        Thread.sleep(1000 * (3 - i));
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    throw e;
                }
                --i;
            }
        }
        P2Bridge.importToModel(this.mdrMgr, repo, this.repository, (IProgressMonitor)subMon.newChild(20), true);
    }

    @Override
    public void open(URI location, IProvisioningAgent agent, MetadataRepositoryImpl mdr) throws CoreException {
        this.agent = agent;
        this.location = location;
        this.repository = mdr;
        this.mdrMgr = P2Utils.getRepositoryManager(agent, IMetadataRepositoryManager.class);
    }

    @Override
    public void reload(IProgressMonitor monitor) throws CoreException {
        this.load(monitor, true);
    }
}

