/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.p2.maven.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtil {
    public static final MessageDigest[] MESSAGE_DIGESTERS;

    static {
        String[] algorithms = new String[]{"MD5", "SHA1"};
        MESSAGE_DIGESTERS = new MessageDigest[algorithms.length];
        int i = 0;
        String[] stringArray = algorithms;
        int n = algorithms.length;
        int n2 = 0;
        while (n2 < n) {
            String checkSumAlgorithm = stringArray[n2];
            try {
                DigestUtil.MESSAGE_DIGESTERS[i++] = MessageDigest.getInstance(checkSumAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Unable to create checksum algorithm for " + checkSumAlgorithm + ": " + e.getMessage());
            }
            ++n2;
        }
    }

    public static String[] createCheckSum(byte[] content, MessageDigest[] digests) {
        String[] result = new String[digests.length];
        int i = 0;
        StringBuilder checkSumStr = new StringBuilder(32);
        MessageDigest[] messageDigestArray = digests;
        int n = digests.length;
        int n2 = 0;
        while (n2 < n) {
            MessageDigest digest = messageDigestArray[n2];
            digest.reset();
            byte[] checkSum = digest.digest(content);
            checkSumStr.setLength(0);
            byte[] byArray = checkSum;
            int n3 = checkSum.length;
            int n4 = 0;
            while (n4 < n3) {
                byte b = byArray[n4];
                checkSumStr.append(String.format("%02x", b));
                ++n4;
            }
            result[i++] = checkSumStr.toString();
            ++n2;
        }
        return result;
    }

    public static String encodeMD5(String str) {
        return DigestUtil.encode(str, 0);
    }

    public static String encodeSHA1(String str) {
        return DigestUtil.encode(str, 1);
    }

    private static String encode(String str, int algorithmIndex) {
        byte[] digest = MESSAGE_DIGESTERS[algorithmIndex].digest(str.getBytes());
        return DigestUtil.formatDigest(digest);
    }

    private static String formatDigest(byte[] digest) {
        StringBuilder result = new StringBuilder(digest.length << 1);
        byte[] byArray = digest;
        int n = digest.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            result.append(String.format("%02x", b));
            ++n2;
        }
        return result.toString();
    }
}

