/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.b3.aggregator.Aggregation;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.PackedStrategy;
import org.eclipse.b3.aggregator.ValidationSet;
import org.eclipse.b3.aggregator.engine.Builder;
import org.eclipse.b3.aggregator.engine.BuilderPhase;
import org.eclipse.b3.aggregator.util.ResourceUtils;
import org.eclipse.b3.p2.MetadataRepository;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.b3.util.LogUtils;
import org.eclipse.b3.util.MonitorUtils;
import org.eclipse.b3.util.TimeUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.RawMirrorRequest;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;

public class MirrorGenerator
extends BuilderPhase {
    private final ValidationSet validationSet;

    private static boolean checkIfTargetPresent(IArtifactRepository destination, IArtifactKey key, boolean packed) {
        IArtifactDescriptor found = MirrorGenerator.getArtifactDescriptor(destination, key, packed);
        if (found != null) {
            LogUtils.debug((String)"    %s artifact is already present", (Object[])new Object[]{packed ? "optimized" : "canonical"});
            return true;
        }
        return false;
    }

    private static IStatus extractDeeperRootCause(IStatus status) {
        IStatus deeper;
        Throwable t;
        if (status == null) {
            return null;
        }
        if (status.isMultiStatus()) {
            IStatus[] children = ((MultiStatus)status).getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus deeper2 = MirrorGenerator.extractDeeperRootCause(children[i]);
                if (deeper2 != null) {
                    return deeper2;
                }
                ++i;
            }
        }
        if ((t = status.getException()) instanceof CoreException && (deeper = MirrorGenerator.extractDeeperRootCause(((CoreException)t).getStatus())) != null) {
            return deeper;
        }
        return status.getSeverity() == 4 ? status : null;
    }

    private static IStatus extractRootCause(IStatus status) {
        IStatus rootCause = MirrorGenerator.extractDeeperRootCause(status);
        return rootCause == null ? status : rootCause;
    }

    private static IArtifactDescriptor getArtifactDescriptor(IArtifactRepository destination, IArtifactKey key, boolean packed) {
        IArtifactDescriptor[] iArtifactDescriptorArray = destination.getArtifactDescriptors(key);
        int n = iArtifactDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactDescriptor candidate = iArtifactDescriptorArray[n2];
            if (MirrorGenerator.isPacked(candidate) ? packed : !packed) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isPacked(IArtifactDescriptor desc) {
        return desc != null && "packed".equals(desc.getProperty("format")) && ProcessingStepHandler.canProcess((IArtifactDescriptor)desc);
    }

    static void mirror(Collection<IArtifactKey> keysToInstall, IArtifactRepository cache, IArtifactRepository source, IFileArtifactRepository dest, Transport transport, PackedStrategy strategy, List<String> errors, IProgressMonitor monitor) {
        IQueryResult result = source.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        IArtifactKey[] keys = (IArtifactKey[])result.toArray(IArtifactKey.class);
        MonitorUtils.begin((IProgressMonitor)monitor, (int)(keys.length * 100));
        IArtifactKey[] iArtifactKeyArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactKey key = iArtifactKeyArray[n2];
            boolean found = false;
            Iterator<IArtifactKey> keyIterator = keysToInstall.iterator();
            while (keyIterator.hasNext()) {
                IArtifactKey keyToInstall = keyIterator.next();
                if (!keyToInstall.equals(key)) continue;
                found = true;
                keyIterator.remove();
                break;
            }
            if (found) {
                LogUtils.info((String)"- mirroring artifact %s", (Object[])new Object[]{key});
                IArtifactRepository sourceForCopy = cache != null && cache.contains(key) ? cache : source;
                PackedStrategy keyStrategy = !"osgi.bundle".equals(key.getClassifier()) ? PackedStrategy.SKIP : strategy;
                try {
                    IArtifactDescriptor[] aDescs = sourceForCopy.getArtifactDescriptors(key);
                    IArtifactDescriptor optimized = null;
                    IArtifactDescriptor canonical = null;
                    IArtifactDescriptor[] iArtifactDescriptorArray = aDescs;
                    int n3 = aDescs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IArtifactDescriptor desc = iArtifactDescriptorArray[n4];
                        if (MirrorGenerator.isPacked(desc)) {
                            optimized = desc;
                        } else {
                            canonical = desc;
                        }
                        ++n4;
                    }
                    if (optimized == null && canonical == null) {
                        throw ExceptionUtils.fromMessage((String)"Found no usable descriptor for artifact %s in repository %s", (Object[])new Object[]{key, dest.getLocation()});
                    }
                    if (keyStrategy == PackedStrategy.SKIP && canonical == null) {
                        LogUtils.warning((String)"    canonical artifact unavailable, using optimized one instead", (Object[])new Object[0]);
                        keyStrategy = PackedStrategy.COPY;
                    } else if (keyStrategy != PackedStrategy.SKIP && optimized == null) {
                        keyStrategy = PackedStrategy.SKIP;
                    }
                    switch (keyStrategy) {
                        case SKIP: {
                            if (!MirrorGenerator.checkIfTargetPresent((IArtifactRepository)dest, key, false)) {
                                LogUtils.debug((String)"    doing copy of canonical artifact", (Object[])new Object[0]);
                                MirrorGenerator.mirror(sourceForCopy, (IArtifactRepository)dest, canonical, (IArtifactDescriptor)new ArtifactDescriptor(canonical), transport, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                            }
                            break;
                        }
                        case COPY: {
                            if (!MirrorGenerator.checkIfTargetPresent((IArtifactRepository)dest, key, true)) {
                                LogUtils.debug((String)"    doing copy of optimized artifact", (Object[])new Object[0]);
                                MirrorGenerator.mirror(sourceForCopy, (IArtifactRepository)dest, optimized, (IArtifactDescriptor)new ArtifactDescriptor(optimized), transport, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                            }
                            break;
                        }
                        default: {
                            boolean isVerify;
                            if (keyStrategy == PackedStrategy.UNPACK) {
                                if (!MirrorGenerator.checkIfTargetPresent((IArtifactRepository)dest, key, false)) {
                                    LogUtils.debug((String)"    doing copy of optimized artifact into canonical target", (Object[])new Object[0]);
                                    MirrorGenerator.unpack(sourceForCopy, dest, optimized, transport, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                                }
                                break;
                            }
                            boolean bl = isVerify = keyStrategy == PackedStrategy.VERIFY;
                            if (MirrorGenerator.checkIfTargetPresent((IArtifactRepository)dest, key, true)) {
                                if (isVerify) {
                                    break;
                                }
                            } else {
                                LogUtils.debug((String)"    doing copy of optimized artifact", (Object[])new Object[0]);
                                MirrorGenerator.mirror(sourceForCopy, (IArtifactRepository)dest, optimized, (IArtifactDescriptor)new ArtifactDescriptor(optimized), transport, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)70));
                            }
                            if (isVerify) {
                                LogUtils.debug((String)"    unpacking optimized artifact for verification", (Object[])new Object[0]);
                            } else {
                                if (MirrorGenerator.checkIfTargetPresent((IArtifactRepository)dest, key, false)) break;
                                LogUtils.debug((String)"    unpacking optimized artifact", (Object[])new Object[0]);
                            }
                            MirrorGenerator.unpackToSibling(dest, MirrorGenerator.getArtifactDescriptor((IArtifactRepository)dest, key, true), transport, isVerify, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                            break;
                        }
                    }
                }
                catch (CoreException e) {
                    LogUtils.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                    errors.add(Builder.getExceptionMessages(e));
                    dest.removeDescriptor(key, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)2));
                }
            }
            ++n2;
        }
        for (IArtifactKey key : keysToInstall) {
            String msg = "Artifact " + key + " could not be found in the artifact repository (" + source.getLocation() + ")";
            LogUtils.error((String)msg, (Object[])new Object[0]);
            errors.add(msg);
        }
        MonitorUtils.done((IProgressMonitor)monitor);
    }

    static IArtifactDescriptor mirror(IArtifactRepository source, IArtifactRepository dest, IArtifactDescriptor sourceDesc, IArtifactDescriptor targetDesc, Transport transport, IProgressMonitor monitor) throws CoreException {
        if (dest.contains(targetDesc)) {
            return targetDesc;
        }
        RawMirrorRequest request = new RawMirrorRequest(sourceDesc, targetDesc, dest, transport);
        request.perform(source, monitor);
        IStatus result = request.getResult();
        switch (result.getSeverity()) {
            case 1: {
                LogUtils.info((String)result.getMessage(), (Object[])new Object[0]);
            }
            case 0: {
                if (MirrorGenerator.getArtifactDescriptor(dest, targetDesc.getArtifactKey(), MirrorGenerator.isPacked(targetDesc)) != null) {
                    return targetDesc;
                }
                result = new Status(4, "org.eclipse.b3.aggregator.engine", "Zero bytes copied");
                break;
            }
            case 8: {
                LogUtils.warning((String)"Aggregation cancelled while mirroring artifact %s", (Object[])new Object[]{sourceDesc.getArtifactKey()});
                throw new OperationCanceledException();
            }
            default: {
                if (result.getCode() == 1201) {
                    LogUtils.warning((String)"  copy failed. Artifact %s is already present", (Object[])new Object[]{sourceDesc.getArtifactKey()});
                    return targetDesc;
                }
                result = MirrorGenerator.extractRootCause(result);
            }
        }
        throw ExceptionUtils.fromMessage((Throwable)result.getException(), (String)"Unable to mirror artifact %s from repository %s: %s", (Object[])new Object[]{sourceDesc.getArtifactKey(), source.getLocation(), result.getMessage()});
    }

    private static void unpack(IArtifactRepository source, IFileArtifactRepository target, IArtifactDescriptor optimized, Transport transport, IProgressMonitor monitor) throws CoreException {
        CanonicalizeRequest request = new CanonicalizeRequest(optimized, source, target, transport);
        request.perform(source, monitor);
        IStatus result = request.getResult();
        if (result.getSeverity() != 4 || result.getCode() == 1201) {
            return;
        }
        result = MirrorGenerator.extractRootCause(result);
        throw ExceptionUtils.fromMessage((Throwable)result.getException(), (String)"Unable to unpack artifact %s in repository %s: %s", (Object[])new Object[]{optimized.getArtifactKey(), target.getLocation(), result.getMessage()});
    }

    private static void unpackToSibling(IFileArtifactRepository target, IArtifactDescriptor optimized, Transport transport, boolean verifyOnly, IProgressMonitor monitor) throws CoreException {
        CanonicalizeRequest request = new CanonicalizeRequest(optimized, target, transport);
        MonitorUtils.begin((IProgressMonitor)monitor, (int)20);
        try {
            request.perform((IArtifactRepository)target, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)18));
            IStatus result = request.getResult();
            if (result.getSeverity() != 4 || result.getCode() == 1201) {
                if (verifyOnly) {
                    target.removeDescriptor(MirrorGenerator.getArtifactDescriptor((IArtifactRepository)target, optimized.getArtifactKey(), false), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)2));
                }
                return;
            }
            result = MirrorGenerator.extractRootCause(result);
            throw ExceptionUtils.fromMessage((Throwable)result.getException(), (String)"Unable to unpack artifact %s in repository %s: %s", (Object[])new Object[]{optimized.getArtifactKey(), target.getLocation(), result.getMessage()});
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    public MirrorGenerator(Builder builder, ValidationSet validationSet) {
        super(builder);
        this.validationSet = validationSet;
    }

    private Transport getTransport() {
        return this.getBuilder().getTransport();
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        LogUtils.info((String)"Starting artifacts mirroring", (Object[])new Object[0]);
        long start = TimeUtils.getNow();
        Builder builder = this.getBuilder();
        Aggregation aggregation = builder.getAggregation();
        PackedStrategy packedStrategy = aggregation.getPackedStrategy();
        EList contribs = this.validationSet.getAllContributions();
        Set<IInstallableUnit> unitsToAggregate = builder.getUnitsToAggregate(this.validationSet);
        Set<IArtifactKey> keysToExclude = builder.getArtifactKeysToExcludeFromMirroring();
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)(20 + 100 * contribs.size()));
        boolean artifactErrors = false;
        try {
            IArtifactRepository tempAr = builder.getTemporaryArtifactRepository((IProgressMonitor)subMon.newChild(10));
            IFileArtifactRepository aggregationAr = builder.getAggregationArtifactRepository((IProgressMonitor)subMon.newChild(10));
            for (Contribution contrib : contribs) {
                SubMonitor contribMonitor = subMon.newChild(100);
                EList repos = contrib.getRepositories(true);
                ArrayList<String> errors = new ArrayList<String>();
                MonitorUtils.begin((IProgressMonitor)contribMonitor, (int)(repos.size() * 100));
                for (MappedRepository repo : repos) {
                    if (builder.isMapVerbatim(repo) || !repo.isMirrorArtifacts()) {
                        MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)100);
                        continue;
                    }
                    MetadataRepository childMdr = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo);
                    ArrayList<IArtifactKey> keysToMirror = null;
                    for (IInstallableUnit iu : childMdr.getInstallableUnits()) {
                        if (!unitsToAggregate.contains(iu)) continue;
                        for (IArtifactKey ak : iu.getArtifacts()) {
                            if (!keysToExclude.add(ak)) continue;
                            if (keysToMirror == null) {
                                keysToMirror = new ArrayList<IArtifactKey>();
                            }
                            keysToMirror.add(ak);
                        }
                    }
                    if (keysToMirror != null) {
                        String msg = String.format("Mirroring artifacts from %s", childMdr.getLocation());
                        LogUtils.info((String)msg, (Object[])new Object[0]);
                        contribMonitor.subTask(msg);
                        IArtifactRepository childAr = builder.getArtifactRepository((MetadataRepositoryReference)repo, (IProgressMonitor)contribMonitor.newChild(1, 6));
                        MirrorGenerator.mirror(keysToMirror, tempAr, childAr, aggregationAr, this.getTransport(), packedStrategy, errors, (IProgressMonitor)contribMonitor.newChild(94, 6));
                        continue;
                    }
                    MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)95);
                }
                if (errors.size() > 0) {
                    artifactErrors = true;
                    builder.sendEmail(contrib, errors);
                    for (String err : errors) {
                        LogUtils.error((String)("Error during mirroring: " + err), (Object[])new Object[0]);
                    }
                }
                MonitorUtils.done((IProgressMonitor)contribMonitor);
            }
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
        LogUtils.info((String)"Done. Took %s", (Object[])new Object[]{TimeUtils.getFormattedDuration((long)start)});
        if (artifactErrors) {
            throw ExceptionUtils.fromMessage((String)"Not all artifacts could be mirrored, see log for details", (Object[])new Object[0]);
        }
    }

    private static class CanonicalizeRequest
    extends MirrorRequest {
        private IArtifactDescriptor optimizedDescriptor;

        public CanonicalizeRequest(IArtifactDescriptor optimizedDescriptor, IArtifactRepository sourceRepository, IFileArtifactRepository targetRepository, Transport transport) {
            super(optimizedDescriptor.getArtifactKey(), (IArtifactRepository)targetRepository, null, null, transport);
            this.optimizedDescriptor = optimizedDescriptor;
            this.setSourceRepository(sourceRepository);
        }

        public CanonicalizeRequest(IArtifactDescriptor optimizedDescriptor, IFileArtifactRepository targetRepository, Transport transport) {
            this(optimizedDescriptor, (IArtifactRepository)targetRepository, targetRepository, transport);
        }

        /*
         * Exception decompiling
         */
        public void perform(IArtifactRepository sourceRepository, IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

