/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AggregationType implements Enumerator
{
    STABLE(3, "Stable", "S"),
    INTEGRATION(2, "Integration", "I"),
    NIGHTLY(1, "Nightly", "N"),
    MAINTENANCE(5, "Maintenance", "M"),
    CONTINUOUS(0, "Continuous", "C"),
    RELEASE(4, "Release", "R");

    public static final int STABLE_VALUE = 3;
    public static final int INTEGRATION_VALUE = 2;
    public static final int NIGHTLY_VALUE = 1;
    public static final int MAINTENANCE_VALUE = 5;
    public static final int CONTINUOUS_VALUE = 0;
    public static final int RELEASE_VALUE = 4;
    private static final AggregationType[] VALUES_ARRAY;
    public static final List<AggregationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AggregationType[]{STABLE, INTEGRATION, NIGHTLY, MAINTENANCE, CONTINUOUS, RELEASE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AggregationType get(int value) {
        switch (value) {
            case 3: {
                return STABLE;
            }
            case 2: {
                return INTEGRATION;
            }
            case 1: {
                return NIGHTLY;
            }
            case 5: {
                return MAINTENANCE;
            }
            case 0: {
                return CONTINUOUS;
            }
            case 4: {
                return RELEASE;
            }
        }
        return null;
    }

    public static AggregationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AggregationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AggregationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AggregationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private AggregationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

