/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AvailableFrom implements Enumerator
{
    REPOSITORY(0, "REPOSITORY", "repository"),
    CONTRIBUTION(1, "CONTRIBUTION", "contribution"),
    VALIDATION_SET(2, "VALIDATION_SET", "validationSet"),
    AGGREGATION(3, "AGGREGATION", "aggregation");

    public static final int REPOSITORY_VALUE = 0;
    public static final int CONTRIBUTION_VALUE = 1;
    public static final int VALIDATION_SET_VALUE = 2;
    public static final int AGGREGATION_VALUE = 3;
    private static final AvailableFrom[] VALUES_ARRAY;
    public static final List<AvailableFrom> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AvailableFrom[]{REPOSITORY, CONTRIBUTION, VALIDATION_SET, AGGREGATION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AvailableFrom get(int value) {
        switch (value) {
            case 0: {
                return REPOSITORY;
            }
            case 1: {
                return CONTRIBUTION;
            }
            case 2: {
                return VALIDATION_SET;
            }
            case 3: {
                return AGGREGATION;
            }
        }
        return null;
    }

    public static AvailableFrom get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AvailableFrom result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AvailableFrom getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AvailableFrom result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private AvailableFrom(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

