/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.util;

import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.IAggregatorConstants;
import org.eclipse.b3.aggregator.InstallableUnitType;
import org.eclipse.b3.aggregator.Status;
import org.eclipse.b3.aggregator.StatusCode;
import org.eclipse.b3.p2.InstallableUnit;
import org.eclipse.b3.util.StringUtils;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;

public class InstallableUnitUtils {
    public static void appendIdentifier(StringBuilder bld, IInstallableUnit iu) {
        InstallableUnitType riuType = InstallableUnitUtils.getType(iu);
        bld.append(riuType.toString());
        bld.append('(');
        bld.append(iu.getId());
        Version v = iu.getVersion();
        if (v != null && !v.equals(Version.emptyVersion)) {
            bld.append(' ');
            bld.append(v);
        }
        bld.append(')');
    }

    public static void appendIdentifier(StringBuilder bld, IRequirement req) {
        if (req instanceof RequiredCapability) {
            RequiredCapability rc = (RequiredCapability)req;
            String ns = rc.getNamespace();
            if ("osgi.bundle".equals(ns)) {
                bld.append("Bundle(");
            } else if ("java.package".equals(ns)) {
                bld.append("JavaPackage(");
            } else {
                bld.append("InstallableUnit(");
            }
            bld.append(rc.getName());
            VersionRange range = rc.getRange();
            if (range != null && !VersionRange.emptyRange.equals((Object)range)) {
                bld.append(' ');
                bld.append(range);
            }
            bld.append(')');
        } else {
            bld.append(req.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status getStatus(InstallableUnit iu) {
        InstallableUnit installableUnit = iu;
        synchronized (installableUnit) {
            return StringUtils.trimmedOrNull((String)iu.getId()) != null ? AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK) : AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
        }
    }

    public static InstallableUnitType getType(IInstallableUnit iu) {
        if ("true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.category"))) {
            return InstallableUnitType.CATEGORY;
        }
        if (iu.getId().endsWith(".feature.group")) {
            return InstallableUnitType.FEATURE;
        }
        if ("true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.group"))) {
            return InstallableUnitType.PRODUCT;
        }
        if (InstallableUnitUtils.isOSGiFragment(iu)) {
            return InstallableUnitType.FRAGMENT;
        }
        if (InstallableUnitUtils.isOSGiBundle(iu)) {
            return InstallableUnitType.BUNDLE;
        }
        return InstallableUnitType.OTHER;
    }

    private static boolean isOSGiBundle(IInstallableUnit iu) {
        for (IProvidedCapability rc : iu.getProvidedCapabilities()) {
            if (!"org.eclipse.equinox.p2.eclipse.type".equals(rc.getNamespace()) || !IAggregatorConstants.CAPABILITY_TYPE_BUNDLE.equals(rc.getName()) && !"source".equals(rc.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isOSGiFragment(IInstallableUnit iu) {
        for (IProvidedCapability rc : iu.getProvidedCapabilities()) {
            if (!"osgi.fragment".equals(rc.getNamespace())) continue;
            return true;
        }
        return false;
    }
}

