/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.p2.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.b3.aggregator.p2.util.MetadataRepositoryResourceImpl;
import org.eclipse.b3.p2.loader.IRepositoryLoader;
import org.eclipse.b3.p2.util.RepositoryLoaderUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;

public class MetadataRepositoryResourceFactoryImpl
extends ResourceFactoryImpl {
    private static final Pattern URI_LOADER_PATTERN = Pattern.compile("^([^:]+):.*");
    private Map<String, IConfigurationElement> loaderConfigurations = new HashMap<String, IConfigurationElement>();

    public Resource createResource(URI uri) {
        Matcher matcher = URI_LOADER_PATTERN.matcher(uri.opaquePart());
        if (!matcher.matches()) {
            throw new RuntimeException("Unexpected URI format: " + uri.toString());
        }
        String nature = matcher.group(1);
        IConfigurationElement loaderConfiguration = this.loaderConfigurations.get(nature);
        if (loaderConfiguration == null || !loaderConfiguration.isValid()) {
            try {
                loaderConfiguration = RepositoryLoaderUtils.getLoaderFor((String)matcher.group(1));
            }
            catch (CoreException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        try {
            return new MetadataRepositoryResourceImpl(uri, (IRepositoryLoader)loaderConfiguration.createExecutableExtension("class"));
        }
        catch (CoreException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

