/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.p2.maven;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.b3.p2.maven.IPropertyProvider;
import org.eclipse.b3.p2.maven.POM;
import org.eclipse.b3.p2.maven.ResolvedModelBase;
import org.eclipse.b3.p2.maven.pom.Build;
import org.eclipse.b3.p2.maven.pom.CiManagement;
import org.eclipse.b3.p2.maven.pom.Contributor;
import org.eclipse.b3.p2.maven.pom.ContributorsType;
import org.eclipse.b3.p2.maven.pom.DependenciesType;
import org.eclipse.b3.p2.maven.pom.Dependency;
import org.eclipse.b3.p2.maven.pom.DependencyManagement;
import org.eclipse.b3.p2.maven.pom.Developer;
import org.eclipse.b3.p2.maven.pom.DevelopersType;
import org.eclipse.b3.p2.maven.pom.DistributionManagement;
import org.eclipse.b3.p2.maven.pom.IssueManagement;
import org.eclipse.b3.p2.maven.pom.License;
import org.eclipse.b3.p2.maven.pom.LicensesType;
import org.eclipse.b3.p2.maven.pom.MailingList;
import org.eclipse.b3.p2.maven.pom.MailingListsType;
import org.eclipse.b3.p2.maven.pom.ModulesType;
import org.eclipse.b3.p2.maven.pom.Organization;
import org.eclipse.b3.p2.maven.pom.Parent;
import org.eclipse.b3.p2.maven.pom.PluginRepositoriesType;
import org.eclipse.b3.p2.maven.pom.PomPackage;
import org.eclipse.b3.p2.maven.pom.Prerequisites;
import org.eclipse.b3.p2.maven.pom.Profile;
import org.eclipse.b3.p2.maven.pom.ProfilesType;
import org.eclipse.b3.p2.maven.pom.PropertiesType;
import org.eclipse.b3.p2.maven.pom.Reporting;
import org.eclipse.b3.p2.maven.pom.ReportsType;
import org.eclipse.b3.p2.maven.pom.RepositoriesType;
import org.eclipse.b3.p2.maven.pom.Repository;
import org.eclipse.b3.p2.maven.pom.Scm;
import org.eclipse.b3.p2.maven.pom.impl.ModelImpl;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.b3.util.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.impl.AnyTypeImpl;

public class ResolvedModel
extends ResolvedModelBase
implements IPropertyProvider {
    private String repoRoot;
    private ModelImpl original;
    private Map<String, String> propertyMap;
    private String artifactId;
    private boolean artifactIdResolved;
    private Build build;
    private boolean buildResolved;
    private CiManagement ciManagement;
    private boolean ciManagementResolved;
    private ContributorsType contributors;
    private boolean contributorsResolved;
    private DependenciesType dependencies;
    private boolean dependenciesResolved;
    private DependencyManagement dependencyManagement;
    private boolean dependencyManagementResolved;
    private String description;
    private boolean descriptionResolved;
    private DevelopersType developers;
    private boolean developersResolved;
    private DistributionManagement distributionManagement;
    private boolean distributionManagementResolved;
    private String groupId;
    private boolean groupIdResolved;
    private String inceptionYear;
    private boolean inceptionYearResolved;
    private IssueManagement issueManagement;
    private boolean issueManagementResolved;
    private LicensesType licenses;
    private boolean licensesResolved;
    private MailingListsType mailingLists;
    private boolean mailingListsResolved;
    private String modelVersion;
    private boolean modelVersionResolved;
    private ModulesType modules;
    private boolean modulesResolved;
    private String name;
    private boolean nameResolved;
    private Organization organization;
    private boolean organizationResolved;
    private String packaging;
    private boolean packagingResolved;
    private PluginRepositoriesType pluginRepositories;
    private boolean pluginRepositoriesResolved;
    private Prerequisites prerequisites;
    private boolean prerequisitesResolved;
    private ProfilesType profiles;
    private boolean profilesResolved;
    private Reporting reporting;
    private boolean reportingResolved;
    private RepositoriesType repositories;
    private boolean repositoriesResolved;
    private Scm scm;
    private boolean scmResolved;
    private String url;
    private boolean urlResolved;
    private String version;
    private boolean versionResolved;

    public ResolvedModel(String repoRoot, ModelImpl original) {
        this.repoRoot = repoRoot;
        this.original = original;
        this.propertyMap = null;
    }

    @Override
    public String getArtifactId() {
        if (!this.artifactIdResolved) {
            this.artifactIdResolved = true;
            this.artifactId = (String)this.resolveFeature(3);
        }
        return this.artifactId;
    }

    @Override
    public Build getBuild() {
        if (!this.buildResolved) {
            this.buildResolved = true;
            this.build = (Build)this.resolveFeature(19);
        }
        return this.build;
    }

    @Override
    public CiManagement getCiManagement() {
        if (!this.ciManagementResolved) {
            this.ciManagementResolved = true;
            this.ciManagement = (CiManagement)this.resolveFeature(11);
        }
        return this.ciManagement;
    }

    @Override
    public ContributorsType getContributors() {
        if (!this.contributorsResolved) {
            this.contributorsResolved = true;
            this.contributors = this.resolveWrappedListFeature(15, 0, ContributorsType.class, Contributor.class);
        }
        return this.contributors;
    }

    @Override
    public DependenciesType getDependencies() {
        if (!this.dependenciesResolved) {
            this.dependenciesResolved = true;
            this.dependencies = this.resolveWrappedListFeature(24, 0, DependenciesType.class, Dependency.class);
        }
        return this.dependencies;
    }

    @Override
    public DependencyManagement getDependencyManagement() {
        if (!this.dependencyManagementResolved) {
            this.dependencyManagementResolved = true;
            this.dependencyManagement = (DependencyManagement)this.resolveFeature(27);
        }
        return this.dependencyManagement;
    }

    @Override
    public String getDescription() {
        if (!this.descriptionResolved) {
            this.descriptionResolved = true;
            this.description = (String)this.resolveFeature(7);
        }
        return this.description;
    }

    @Override
    public DevelopersType getDevelopers() {
        if (!this.developersResolved) {
            this.developersResolved = true;
            this.developers = this.resolveWrappedListFeature(14, 0, DevelopersType.class, Developer.class);
        }
        return this.developers;
    }

    @Override
    public DistributionManagement getDistributionManagement() {
        if (!this.distributionManagementResolved) {
            this.distributionManagementResolved = true;
            this.distributionManagement = (DistributionManagement)this.resolveFeature(28);
        }
        return this.distributionManagement;
    }

    @Override
    public String getGroupId() {
        if (!this.groupIdResolved) {
            this.groupIdResolved = true;
            this.groupId = (String)this.resolveFeature(2);
        }
        return this.groupId;
    }

    @Override
    public String getInceptionYear() {
        if (!this.inceptionYearResolved) {
            this.inceptionYearResolved = true;
            this.inceptionYear = (String)this.resolveFeature(12);
        }
        return this.inceptionYear;
    }

    @Override
    public IssueManagement getIssueManagement() {
        if (!this.issueManagementResolved) {
            this.issueManagementResolved = true;
            this.issueManagement = (IssueManagement)this.resolveFeature(10);
        }
        return this.issueManagement;
    }

    @Override
    public LicensesType getLicenses() {
        if (!this.licensesResolved) {
            this.licensesResolved = true;
            this.licenses = this.resolveWrappedListFeature(16, 0, LicensesType.class, License.class);
        }
        return this.licenses;
    }

    @Override
    public MailingListsType getMailingLists() {
        if (!this.mailingListsResolved) {
            this.mailingListsResolved = true;
            this.mailingLists = this.resolveWrappedListFeature(13, 0, MailingListsType.class, MailingList.class);
        }
        return this.mailingLists;
    }

    @Override
    public String getModelVersion() {
        if (!this.modelVersionResolved) {
            this.modelVersionResolved = true;
            this.modelVersion = (String)this.resolveFeature(1);
        }
        return this.modelVersion;
    }

    @Override
    public ModulesType getModules() {
        if (!this.modulesResolved) {
            this.modulesResolved = true;
            this.modules = this.resolveWrappedListFeature(21, 0, ModulesType.class, String.class);
        }
        return this.modules;
    }

    @Override
    public String getName() {
        if (!this.nameResolved) {
            this.nameResolved = true;
            this.name = (String)this.resolveFeature(5);
        }
        return this.name;
    }

    @Override
    public Organization getOrganization() {
        if (!this.organizationResolved) {
            this.organizationResolved = true;
            this.organization = (Organization)this.resolveFeature(18);
        }
        return this.organization;
    }

    @Override
    public String getPackaging() {
        if (!this.packagingResolved) {
            this.packagingResolved = true;
            this.packaging = (String)this.resolveFeature(4);
        }
        return this.packaging;
    }

    @Override
    public Parent getParent() {
        return this.original.getParent();
    }

    @Override
    public PluginRepositoriesType getPluginRepositories() {
        if (!this.pluginRepositoriesResolved) {
            this.pluginRepositoriesResolved = true;
            this.pluginRepositories = this.resolveWrappedListFeature(23, 0, PluginRepositoriesType.class, Repository.class);
        }
        return this.pluginRepositories;
    }

    @Override
    public Prerequisites getPrerequisites() {
        if (!this.prerequisitesResolved) {
            this.prerequisitesResolved = true;
            this.prerequisites = (Prerequisites)this.resolveFeature(9);
        }
        return this.prerequisites;
    }

    @Override
    public ProfilesType getProfiles() {
        if (!this.profilesResolved) {
            this.profilesResolved = true;
            this.profiles = this.resolveWrappedListFeature(20, 0, ProfilesType.class, Profile.class);
        }
        return this.profiles;
    }

    @Override
    public PropertiesType getProperties() {
        throw new UnsupportedOperationException("Use POM.getFullPropertyMap() instead");
    }

    @Override
    public String getProperty(String propertyName) throws CoreException {
        String projectPropertyName;
        int pomFeatureId;
        String envPropertyName;
        String result;
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap<String, String>();
            String version = this.getVersion();
            this.propertyMap.put("version", version);
            this.propertyMap.put("pom.version", version);
            String name = this.getName();
            this.propertyMap.put("pom.name", name);
            Parent parent = this.getParent();
            if (parent != null) {
                this.propertyMap.put("parent.version", parent.getVersion());
            }
            this.propertyMap.putAll(this.getPropertiesAsMap());
        }
        if ((result = this.propertyMap.get(propertyName)) != null) {
            return result;
        }
        if (propertyName.startsWith("env.") && (result = System.getenv(envPropertyName = propertyName.substring(4))) != null) {
            this.propertyMap.put(propertyName, result);
            return result;
        }
        if (propertyName.startsWith("project.") && (pomFeatureId = this.getFeatureId(projectPropertyName = propertyName.substring(8))) != -1 && (result = (String)this.resolveFeature(pomFeatureId)) != null) {
            this.propertyMap.put(propertyName, result);
            return result;
        }
        result = System.getProperty(propertyName);
        if (result != null) {
            return result;
        }
        Parent parent = this.getParent();
        if (parent != null) {
            ResolvedModel parentModel = POM.getPOM(this.repoRoot, parent.getGroupId(), parent.getArtifactId(), parent.getVersion()).getResolvedProject();
            return parentModel.getProperty(propertyName);
        }
        return null;
    }

    @Override
    public Reporting getReporting() {
        if (!this.reportingResolved) {
            this.reportingResolved = true;
            this.reporting = (Reporting)this.resolveFeature(26);
        }
        return this.reporting;
    }

    @Override
    public ReportsType getReports() {
        throw new UnsupportedOperationException("reports resolution is not supported in this version");
    }

    @Override
    public RepositoriesType getRepositories() {
        if (!this.repositoriesResolved) {
            this.repositoriesResolved = true;
            this.repositories = this.resolveWrappedListFeature(22, 0, RepositoriesType.class, Repository.class);
        }
        return this.repositories;
    }

    @Override
    public Scm getScm() {
        if (!this.scmResolved) {
            this.scmResolved = true;
            this.scm = (Scm)this.resolveFeature(17);
        }
        return this.scm;
    }

    @Override
    public String getUrl() {
        if (!this.urlResolved) {
            this.urlResolved = true;
            this.url = (String)this.resolveFeature(8);
        }
        return this.url;
    }

    @Override
    public String getVersion() {
        if (!this.versionResolved) {
            this.versionResolved = true;
            this.version = (String)this.resolveFeature(6);
        }
        return this.version;
    }

    @Override
    public boolean isSetPackaging() {
        return this.getPackaging() != null;
    }

    private int getFeatureId(String projectPropertyName) {
        StringBuilder featureKeyName = new StringBuilder("MODEL__");
        char[] cArray = projectPropertyName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isUpperCase(c)) {
                featureKeyName.append('_');
            }
            featureKeyName.append(Character.toUpperCase(c));
            ++n2;
        }
        try {
            Field field = PomPackage.class.getField(featureKeyName.toString());
            if (Modifier.isStatic(field.getModifiers())) {
                return field.getInt(null);
            }
        }
        catch (Exception exception) {}
        return -1;
    }

    private Map<String, String> getPropertiesAsMap() throws CoreException {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        PropertiesType propertiesType = this.original.getProperties();
        if (propertiesType != null) {
            FeatureMap properties = this.original.getProperties().getAny();
            int i = properties.size() - 1;
            while (i >= 0) {
                String value;
                FeatureMap.Entry entry = (FeatureMap.Entry)properties.get(i);
                FeatureMap valueMap = ((AnyTypeImpl)entry.getValue()).getMixed();
                switch (valueMap.size()) {
                    case 0: {
                        value = null;
                        break;
                    }
                    case 1: {
                        value = (String)((AnyTypeImpl)entry.getValue()).getMixed().getValue(0);
                        break;
                    }
                    default: {
                        throw ExceptionUtils.fromMessage((String)"Unexpected property map size: %d", (Object[])new Object[]{valueMap.size()});
                    }
                }
                propertyMap.put(entry.getEStructuralFeature().getName(), value);
                --i;
            }
        }
        return propertyMap;
    }

    private <T> T resolveFeature(int featureID) {
        try {
            Parent parent;
            Object result = this.original.eGet(featureID, false, false);
            if (result instanceof String) {
                result = StringUtils.trimmedOrNull((String)((String)result));
            }
            if (result == null && (parent = this.getParent()) != null) {
                result = POM.getPOM(this.repoRoot, parent.getGroupId(), parent.getArtifactId(), parent.getVersion()).getResolvedProject().resolveFeature(featureID);
            }
            if (result instanceof String) {
                result = POM.expandProperties((String)result, this);
            }
            return (T)result;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private <T, L> T resolveWrappedListFeature(int wrapperID, int featureID, Class<T> wrapperClass, Class<L> featureClass) {
        try {
            ModelImpl model = this.original;
            T result = wrapperClass.newInstance();
            EObjectContainmentEList list = new EObjectContainmentEList(featureClass, (InternalEObject)result, featureID);
            ((EObjectImpl)result).eSet(wrapperID, (Object)list);
            while (model != null) {
                Parent parent;
                List semiList;
                Object semiResult = model.eGet(featureID, false, false);
                if (semiResult != null && (semiList = (List)((EObjectImpl)semiResult).eGet(wrapperID, false, false)) != null) {
                    list.addAll(semiList);
                }
                model = (parent = model.getParent()) != null ? (ModelImpl)POM.getPOM(this.repoRoot, parent.getGroupId(), parent.getArtifactId(), parent.getVersion()).getProject() : null;
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

