/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.engine;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cbi.p2repo.aggregator.Aggregation;
import org.eclipse.cbi.p2repo.aggregator.Configuration;
import org.eclipse.cbi.p2repo.aggregator.Contribution;
import org.eclipse.cbi.p2repo.aggregator.MappedRepository;
import org.eclipse.cbi.p2repo.aggregator.MappedUnit;
import org.eclipse.cbi.p2repo.aggregator.MetadataRepositoryReference;
import org.eclipse.cbi.p2repo.aggregator.PackedStrategy;
import org.eclipse.cbi.p2repo.aggregator.ValidationSet;
import org.eclipse.cbi.p2repo.aggregator.engine.Builder;
import org.eclipse.cbi.p2repo.aggregator.engine.BuilderPhase;
import org.eclipse.cbi.p2repo.aggregator.engine.MirrorGenerator;
import org.eclipse.cbi.p2repo.aggregator.impl.AggregationImpl;
import org.eclipse.cbi.p2repo.aggregator.util.InstallableUnitUtils;
import org.eclipse.cbi.p2repo.aggregator.util.SpecialQueries;
import org.eclipse.cbi.p2repo.aggregator.util.VerificationDiagnostic;
import org.eclipse.cbi.p2repo.p2.util.P2Bridge;
import org.eclipse.cbi.p2repo.p2.util.P2Utils;
import org.eclipse.cbi.p2repo.util.ExceptionUtils;
import org.eclipse.cbi.p2repo.util.LogUtils;
import org.eclipse.cbi.p2repo.util.MonitorUtils;
import org.eclipse.cbi.p2repo.util.TimeUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.PublisherUtil;
import org.eclipse.equinox.internal.p2.updatesite.metadata.UpdateSiteMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class ValidationSetVerifier
extends BuilderPhase {
    private ValidationSet validationSet;

    private static List<String> getResolutionErrors(PlannerStatus plannerStatus) {
        RequestStatus requestStatus = plannerStatus.getRequestStatus();
        if (requestStatus == null) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (Explanation explanation : requestStatus.getExplanations()) {
            errors.add(explanation.toString());
        }
        return errors;
    }

    private static IInstallableUnit[] getRootIUs(IMetadataRepository site, String iuName, Version version, IProgressMonitor monitor) throws CoreException {
        IQuery query = QueryUtil.createIUQuery((String)iuName, (Version)version);
        IQueryResult roots = site.query(query, monitor);
        if (roots.isEmpty()) {
            throw ExceptionUtils.fromMessage((String)"IU %s not found", (Object[])new Object[]{iuName});
        }
        return (IInstallableUnit[])roots.toArray(IInstallableUnit.class);
    }

    public ValidationSetVerifier(Builder builder, ValidationSet validationSet) {
        super(builder);
        this.validationSet = validationSet;
    }

    private boolean addLeafmostContributions(Set<Explanation> explanations, Map<String, Contribution> contributions, IRequirement prq) {
        boolean contribsFound = false;
        block0: for (Explanation explanation : explanations) {
            IRequirement crq;
            IInstallableUnit iu;
            if (explanation instanceof Explanation.Singleton) {
                if (contribsFound) continue;
                IInstallableUnit[] iInstallableUnitArray = ((Explanation.Singleton)explanation).ius;
                int n = ((Explanation.Singleton)explanation).ius.length;
                int n2 = 0;
                while (n2 < n) {
                    iu = iInstallableUnitArray[n2];
                    if (prq.isMatch(iu) && !this.findContributions(iu.getId()).isEmpty()) {
                        contribsFound = true;
                        continue block0;
                    }
                    ++n2;
                }
                continue;
            }
            if (explanation instanceof Explanation.HardRequirement) {
                Explanation.HardRequirement hrq = (Explanation.HardRequirement)explanation;
                iu = hrq.iu;
                crq = hrq.req;
            } else {
                if (!(explanation instanceof Explanation.MissingIU)) continue;
                Explanation.MissingIU miu = (Explanation.MissingIU)explanation;
                iu = miu.iu;
                crq = miu.req;
            }
            if (!prq.isMatch(iu)) continue;
            if (this.addLeafmostContributions(explanations, contributions, crq)) {
                contribsFound = true;
                continue;
            }
            for (Contribution contrib : this.findContributions(iu, crq)) {
                contributions.put(contrib.getLabel(), contrib);
                contribsFound = true;
            }
        }
        return contribsFound;
    }

    private ProvisioningContext createContext(java.net.URI site) {
        EList validationRepos = this.validationSet.getAllValidationRepositories();
        int top = validationRepos.size();
        ArrayList<java.net.URI> sites = new ArrayList<java.net.URI>(top + 1);
        sites.add(site);
        java.net.URI[] repoLocations = new java.net.URI[top + 1];
        int idx = 0;
        while (idx < top) {
            MetadataRepositoryReference mdRef = (MetadataRepositoryReference)validationRepos.get(idx);
            if (mdRef.isEnabled()) {
                sites.add(java.net.URI.create(mdRef.getResolvedLocation()));
            }
            ++idx;
        }
        repoLocations = sites.toArray(new java.net.URI[sites.size()]);
        ProvisioningContext context = new ProvisioningContext(this.getBuilder().getProvisioningAgent());
        context.setMetadataRepositories(repoLocations);
        context.setArtifactRepositories(repoLocations);
        return context;
    }

    private List<Contribution> findContributions(IInstallableUnit iu, IRequirement rq) {
        List<Contribution> contribs = Collections.emptyList();
        if (!(rq instanceof IRequiredCapability)) {
            return contribs;
        }
        IRequiredCapability cap = (IRequiredCapability)rq;
        if ("osgi.bundle".equals(cap.getNamespace()) || "org.eclipse.equinox.p2.iu".equals(cap.getNamespace())) {
            contribs = this.findContributions(cap.getName());
        }
        if (contribs.isEmpty()) {
            contribs = this.findContributions(iu.getId());
        }
        return contribs;
    }

    private List<Contribution> findContributions(String componentId) {
        ArrayList<Contribution> result = null;
        for (Contribution contrib : this.validationSet.getAllContributions()) {
            for (MappedRepository repository : contrib.getRepositories(true)) {
                for (MappedUnit mu : repository.getUnits(true)) {
                    if (!componentId.equals(mu.getName())) continue;
                    if (result == null) {
                        result = new ArrayList<Contribution>();
                    }
                    result.add(contrib);
                }
            }
        }
        return result == null ? Collections.emptyList() : result;
    }

    private Map<String, Contribution> getContributionMap(PlannerStatus plannerStatus) {
        HashMap<String, Contribution> contribs = new HashMap<String, Contribution>();
        RequestStatus requestStatus = plannerStatus.getRequestStatus();
        if (requestStatus == null) {
            return Collections.emptyMap();
        }
        Set explanations = requestStatus.getExplanations();
        for (Explanation explanation : explanations) {
            IRequirement crq;
            IInstallableUnit iu;
            if (explanation instanceof Explanation.Singleton) {
                IInstallableUnit[] iInstallableUnitArray = ((Explanation.Singleton)explanation).ius;
                int n = ((Explanation.Singleton)explanation).ius.length;
                int n2 = 0;
                while (n2 < n) {
                    iu = iInstallableUnitArray[n2];
                    for (Contribution contrib : this.findContributions(iu.getId())) {
                        contribs.put(contrib.getLabel(), contrib);
                    }
                    ++n2;
                }
                continue;
            }
            if (explanation instanceof Explanation.HardRequirement) {
                Explanation.HardRequirement hrq = (Explanation.HardRequirement)explanation;
                iu = hrq.iu;
                crq = hrq.req;
            } else {
                if (!(explanation instanceof Explanation.MissingIU)) continue;
                Explanation.MissingIU miu = (Explanation.MissingIU)explanation;
                iu = miu.iu;
                crq = miu.req;
            }
            if (this.addLeafmostContributions(explanations, contribs, crq)) continue;
            for (Contribution contrib : this.findContributions(iu, crq)) {
                contribs.put(contrib.getLabel(), contrib);
            }
        }
        return contribs;
    }

    private Set<IInstallableUnit> getUnpatchedTransitiveScope(IQueryable<IInstallableUnit> collectedStuff, IInstallableUnitPatch patch, IProfile profile, IPlanner planner, java.net.URI repoLocation, SubMonitor monitor) throws CoreException {
        monitor.beginTask(null, 10);
        IQuery query = SpecialQueries.createPatchApplicabilityQuery((IInstallableUnitPatch)patch);
        IQueryResult result = collectedStuff.query(query, (IProgressMonitor)monitor.newChild(1));
        IInstallableUnit[] rootArr = (IInstallableUnit[])result.toArray(IInstallableUnit.class);
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        IInstallableUnit[] iInstallableUnitArray = rootArr;
        int n = rootArr.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit rootIU = iInstallableUnitArray[n2];
            request.setInstallableUnitProfileProperty(rootIU, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
            ++n2;
        }
        request.addInstallableUnits(rootArr);
        ProvisioningContext context = new ProvisioningContext(this.getBuilder().getProvisioningAgent());
        context.setMetadataRepositories(new java.net.URI[]{repoLocation});
        ProvisioningPlan plan = (ProvisioningPlan)planner.getProvisioningPlan((IProfileChangeRequest)request, context, (IProgressMonitor)new NullProgressMonitor());
        monitor.worked(8);
        IStatus status = plan.getStatus();
        if (status.isOK()) {
            Operand[] ops;
            HashSet<IInstallableUnit> units = new HashSet<IInstallableUnit>();
            units.add((IInstallableUnit)patch);
            Operand[] operandArray = ops = plan.getOperands();
            int n3 = ops.length;
            int n4 = 0;
            while (n4 < n3) {
                InstallableUnitOperand iuOp;
                IInstallableUnit iu;
                Operand op = operandArray[n4];
                if (op instanceof InstallableUnitOperand && (iu = (iuOp = (InstallableUnitOperand)op).second()) != null) {
                    units.add(iu);
                }
                ++n4;
            }
            return units;
        }
        return Collections.emptySet();
    }

    /*
     * Unable to fully structure code
     */
    IInstallableUnit resolvePartialIU(IInstallableUnit iu, SubMonitor subMon) throws CoreException {
        if (!this.getBuilder().getAggregation().isAllowLegacySites()) {
            throw ExceptionUtils.fromMessage((String)"This aggregation does not allow legacy update sites", (Object[])new Object[0]);
        }
        arMgr = this.getBuilder().getArManager();
        info = "Converting partial IU for " + iu.getId() + "...";
        subMon.beginTask(info, -1);
        LogUtils.debug((String)info, (Object[])new Object[0]);
        try {
            miu = null;
            mdr = null;
            block4: for (Contribution contrib : this.validationSet.getAllContributions()) {
                for (MappedRepository repo : contrib.getRepositories(true)) {
                    candidate = repo.getMetadataRepository();
                    for (IInstallableUnit candidateIU : candidate.getInstallableUnits()) {
                        if (!iu.getId().equals(candidateIU.getId()) || !iu.getVersion().equals(candidateIU.getVersion())) continue;
                        mdr = candidate;
                        miu = candidateIU;
                        break block4;
                    }
                }
            }
            if (mdr == null) {
                throw ExceptionUtils.fromMessage((String)"Unable to locate mapped repository for IU %s/%s", (Object[])new Object[]{iu.getId(), iu.getVersion()});
            }
            sourceAr = arMgr.loadRepository(mdr.getLocation(), (IProgressMonitor)subMon.newChild(10));
            tempRepositoryFolder = this.getBuilder().getTempRepositoryFolder();
            tempRepositoryFolder.mkdirs();
            tempRepositoryURI = Builder.createURI(tempRepositoryFolder);
            try {
                tempAr = (IFileArtifactRepository)arMgr.loadRepository(tempRepositoryURI, (IProgressMonitor)subMon.newChild(1));
            }
            catch (ProvisionException v0) {
                tempAr = (IFileArtifactRepository)arMgr.createRepository(tempRepositoryURI, "temporary artifacts artifacts", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", Collections.emptyMap());
            }
            artifacts = miu.getArtifacts();
            if (artifacts.isEmpty()) {
                LogUtils.warning((String)"Unable to resolve partial IU '%s' since it does not have any artifacts", (Object[])new Object[]{iu.getId()});
                return iu;
            }
            key = (IArtifactKey)artifacts.iterator().next();
            errors = new ArrayList<String>();
            MirrorGenerator.mirror(artifacts, null, sourceAr, tempAr, this.getBuilder().getTransport(), PackedStrategy.UNPACK_AS_SIBLING, errors, (IProgressMonitor)subMon.newChild(1));
            numErrors = errors.size();
            if (numErrors > 0) {
                children = new IStatus[numErrors];
                idx = 0;
                while (idx < numErrors) {
                    children[idx] = new Status(4, "org.eclipse.cbi.p2repo.aggregator.engine", errors.get(idx));
                    ++idx;
                }
                status = new MultiStatus("org.eclipse.cbi.p2repo.aggregator.engine", 4, children, "Unable to mirror", null);
                throw new CoreException((IStatus)status);
            }
            bundleFile = tempAr.getArtifactFile(key);
            if (bundleFile == null) {
                throw ExceptionUtils.fromMessage((String)"Unable to resolve partial IU. Artifact file for %s could not be found", (Object[])new Object[]{key});
            }
            preparedIU = PublisherUtil.createBundleIU((IArtifactKey)key, (File)bundleFile);
            if (preparedIU == null) {
                LogUtils.warning((String)"Unable to resolve partial IU. Artifact file for %s did not contain a bundle manifest", (Object[])new Object[]{key});
                return iu;
            }
            newIU = P2Bridge.importToModel((IInstallableUnit)preparedIU, (IInstallableUnit)iu);
            allIUs = mdr.getInstallableUnits();
            allIUs.remove(miu);
            allIUs.add(newIU);
            return newIU;
        }
        catch (CoreException e) {
            ** for (contrib : this.findContributions((String)iu.getId()))
        }
lbl-1000:
        // 1 sources

        {
            this.getBuilder().sendEmail(contrib, Collections.singletonList(e.getMessage()));
            continue;
        }
lbl67:
        // 1 sources

        throw e;
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        String taskLabel = Builder.getValidationSetLabel(this.validationSet);
        Builder builder = this.getBuilder();
        Aggregation aggregation = builder.getAggregation();
        EList configs = aggregation.getConfigurations();
        int configCount = configs.size();
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)(configCount * 100));
        LogUtils.info((String)("Starting planner verification for validationSet: " + taskLabel), (Object[])new Object[0]);
        long start = TimeUtils.getNow();
        String profilePrefix = "cbiAggregatorProfile_";
        ((AggregationImpl)aggregation).clearStatus();
        Set<IInstallableUnit> unitsToAggregate = builder.getUnitsToAggregate(this.validationSet);
        IProfileRegistry profileRegistry = P2Utils.getProfileRegistry((IProvisioningAgent)builder.getProvisioningAgent());
        IPlanner planner = P2Utils.getPlanner((IProvisioningAgent)builder.getProvisioningAgent());
        IMetadataRepositoryManager mdrMgr = builder.getMdrManager();
        try {
            try {
                IMetadataRepository sourceRepo;
                java.net.URI repoLocation = builder.getSourceCompositeURI(this.validationSet);
                Set validationOnlyIUs = null;
                for (MetadataRepositoryReference validationRepo : this.validationSet.getAllValidationRepositories()) {
                    if (validationOnlyIUs == null) {
                        validationOnlyIUs = new HashSet();
                    }
                    validationOnlyIUs.addAll(validationRepo.getMetadataRepository().getInstallableUnits());
                }
                if (validationOnlyIUs == null) {
                    validationOnlyIUs = Collections.emptySet();
                }
                if ((sourceRepo = mdrMgr.loadRepository(repoLocation, (IProgressMonitor)subMon.newChild(1))) instanceof UpdateSiteMetadataRepository && !this.getBuilder().getAggregation().isAllowLegacySites()) {
                    throw ExceptionUtils.fromMessage((String)"Location %s appoints a legacy update site. They are not allowed in this aggregation", (Object[])new Object[]{repoLocation});
                }
                block7: for (Configuration config : configs) {
                    if (!config.isEnabled()) continue;
                    String configName = config.getName();
                    String info = String.format("Verifying config %s...", configName);
                    LogUtils.info((String)info, (Object[])new Object[0]);
                    subMon.setTaskName(info);
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("org.eclipse.equinox.p2.environments", config.getOSGiEnvironmentString());
                    props.put("org.eclipse.update.install.features", "true");
                    IProfile profile = null;
                    String profileId = String.valueOf(profilePrefix) + configName;
                    profile = profileRegistry.getProfile(profileId);
                    if (profile == null) {
                        profile = profileRegistry.addProfile(profileId, props);
                    }
                    IInstallableUnit[] rootArr = ValidationSetVerifier.getRootIUs(sourceRepo, builder.getVerificationIUName(this.validationSet), Builder.ALL_CONTRIBUTED_CONTENT_VERSION, (IProgressMonitor)subMon.newChild(9));
                    ProfileChangeRequest request = new ProfileChangeRequest(profile);
                    IInstallableUnit[] iInstallableUnitArray = rootArr;
                    int n = rootArr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IInstallableUnit rootIU = iInstallableUnitArray[n2];
                        request.setInstallableUnitProfileProperty(rootIU, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
                        ++n2;
                    }
                    request.addInstallableUnits(rootArr);
                    while (true) {
                        Object iu3;
                        Operand[] ops;
                        ProvisioningContext context;
                        ProvisioningPlan plan;
                        IStatus status;
                        if ((status = (plan = (ProvisioningPlan)planner.getProvisioningPlan((IProfileChangeRequest)request, context = this.createContext(repoLocation), (IProgressMonitor)subMon.newChild(80, 6))).getStatus()).getSeverity() == 4) {
                            LogUtils.log((IStatus)status);
                            this.sendEmails((PlannerStatus)status);
                            LogUtils.info((String)"Done. Took %s", (Object[])new Object[]{TimeUtils.getFormattedDuration((long)start)});
                            throw new CoreException((IStatus)new AnalyzedPlannerStatus(((EObject)aggregation).eResource(), config, (PlannerStatus)status));
                        }
                        boolean hadPartials = false;
                        HashSet<IInstallableUnit> suspectedValidationOnlyIUs = null;
                        Operand[] operandArray = ops = plan.getOperands();
                        int n3 = ops.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            InstallableUnitOperand iuOp;
                            Operand op = operandArray[n4];
                            if (op instanceof InstallableUnitOperand && (iu3 = (iuOp = (InstallableUnitOperand)op).second()) != null && !Boolean.parseBoolean(iu3.getProperty("org.eclipse.cbi.p2repo.aggregator.generated.IU"))) {
                                if (validationOnlyIUs.contains(iu3)) {
                                    if (suspectedValidationOnlyIUs == null) {
                                        suspectedValidationOnlyIUs = new HashSet<IInstallableUnit>();
                                    }
                                    suspectedValidationOnlyIUs.add((IInstallableUnit)iu3);
                                } else if (!unitsToAggregate.contains(iu3)) {
                                    if (Boolean.valueOf(iu3.getProperty("org.eclipse.equinox.p2.partial.iu")).booleanValue()) {
                                        iu3 = this.resolvePartialIU((IInstallableUnit)iu3, subMon.newChild(1));
                                        hadPartials = true;
                                    }
                                    unitsToAggregate.add((IInstallableUnit)iu3);
                                }
                            }
                            ++n4;
                        }
                        Iterator itor = sourceRepo.query(QueryUtil.createIUPatchQuery(), (IProgressMonitor)subMon.newChild(1)).iterator();
                        QueryableArray collectedStuff = null;
                        while (itor.hasNext()) {
                            IInstallableUnitPatch patch = (IInstallableUnitPatch)itor.next();
                            if (!unitsToAggregate.contains(patch)) continue;
                            if (collectedStuff == null) {
                                collectedStuff = new QueryableArray(unitsToAggregate.toArray(new IInstallableUnit[unitsToAggregate.size()]));
                            }
                            Set<IInstallableUnit> units = this.getUnpatchedTransitiveScope((IQueryable<IInstallableUnit>)collectedStuff, patch, profile, planner, repoLocation, subMon.newChild(1));
                            iu3 = units.iterator();
                            while (iu3.hasNext()) {
                                IInstallableUnit iu2 = (IInstallableUnit)iu3.next();
                                if (validationOnlyIUs.contains(iu2)) {
                                    if (suspectedValidationOnlyIUs == null) {
                                        suspectedValidationOnlyIUs = new HashSet();
                                    }
                                    suspectedValidationOnlyIUs.add(iu2);
                                    continue;
                                }
                                if (unitsToAggregate.contains(iu2)) continue;
                                if (Boolean.valueOf(iu2.getProperty("org.eclipse.equinox.p2.partial.iu")).booleanValue()) {
                                    iu2 = this.resolvePartialIU(iu2, subMon.newChild(1));
                                    hadPartials = true;
                                }
                                unitsToAggregate.add(iu2);
                            }
                        }
                        if (suspectedValidationOnlyIUs != null) {
                            HashSet<IInstallableUnit> candidates = suspectedValidationOnlyIUs;
                            boolean[] hadPartialsHolder = new boolean[1];
                            for (Object iu3 : sourceRepo.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)subMon.newChild(1))) {
                                if (!candidates.contains(iu3) || unitsToAggregate.contains(iu3)) continue;
                                try {
                                    if (Boolean.valueOf(iu3.getProperty("org.eclipse.equinox.p2.partial.iu")).booleanValue()) {
                                        iu3 = this.resolvePartialIU((IInstallableUnit)iu3, SubMonitor.convert((IProgressMonitor)new NullProgressMonitor()));
                                        hadPartialsHolder[0] = true;
                                    }
                                }
                                catch (CoreException e) {
                                    throw new RuntimeException(e);
                                }
                                unitsToAggregate.add((IInstallableUnit)iu3);
                            }
                        }
                        if (!hadPartials) continue block7;
                        LogUtils.info((String)"Partial IU's encountered. Verifying %s again...", (Object[])new Object[]{configName});
                    }
                }
                LogUtils.info((String)"Verification successful", (Object[])new Object[0]);
            }
            catch (RuntimeException e) {
                throw ExceptionUtils.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            MonitorUtils.done((IProgressMonitor)monitor);
            P2Utils.ungetProfileRegistry((IProvisioningAgent)builder.getProvisioningAgent(), (IProfileRegistry)profileRegistry);
            P2Utils.ungetPlanner((IProvisioningAgent)builder.getProvisioningAgent(), (IPlanner)planner);
            LogUtils.info((String)"Done. Took %s", (Object[])new Object[]{TimeUtils.getFormattedDuration((long)start)});
            throw throwable;
        }
        MonitorUtils.done((IProgressMonitor)monitor);
        P2Utils.ungetProfileRegistry((IProvisioningAgent)builder.getProvisioningAgent(), (IProfileRegistry)profileRegistry);
        P2Utils.ungetPlanner((IProvisioningAgent)builder.getProvisioningAgent(), (IPlanner)planner);
        LogUtils.info((String)"Done. Took %s", (Object[])new Object[]{TimeUtils.getFormattedDuration((long)start)});
    }

    private void sendEmails(PlannerStatus plannerStatus) {
        Builder builder = this.getBuilder();
        if (!builder.getAggregation().isSendmail()) {
            return;
        }
        RequestStatus requestStatus = plannerStatus.getRequestStatus();
        if (requestStatus == null) {
            return;
        }
        Map<String, Contribution> contribs = this.getContributionMap(plannerStatus);
        List<String> errors = ValidationSetVerifier.getResolutionErrors(plannerStatus);
        if (contribs.isEmpty()) {
            builder.sendEmail(null, errors);
        } else {
            for (Contribution contrib : contribs.values()) {
                builder.sendEmail(contrib, errors);
            }
        }
    }

    public static class AnalyzedPlannerStatus
    extends MultiStatus {
        private static final String MESSAGE_INDENT = "  ";
        protected PlannerStatus plannerStatus;
        protected ArrayList<VerificationDiagnostic> verificationDiagnostics = new ArrayList();

        private static void appendChildren(StringBuilder messageBuilder, IStatus[] children, String indent, int level) {
            IStatus[] iStatusArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                int i = 0;
                while (i < level) {
                    messageBuilder.append(indent);
                    ++i;
                }
                messageBuilder.append(child.getMessage()).append('\n');
                if (child.isMultiStatus()) {
                    AnalyzedPlannerStatus.appendChildren(messageBuilder, child.getChildren(), indent, level + 1);
                }
                ++n2;
            }
        }

        private static StringBuilder getRootProblemMessage(Explanation rootProblem) {
            IStatus status = rootProblem.toStatus();
            StringBuilder messageBuilder = new StringBuilder(status.getMessage()).append('\n');
            if (status.isMultiStatus()) {
                AnalyzedPlannerStatus.appendChildren(messageBuilder, status.getChildren(), MESSAGE_INDENT, 1);
            }
            return messageBuilder;
        }

        public AnalyzedPlannerStatus(Resource resource, Configuration config, PlannerStatus plannerStatus) {
            super(plannerStatus.getPlugin(), plannerStatus.getCode(), plannerStatus.getMessage(), plannerStatus.getException());
            this.plannerStatus = plannerStatus;
            RequestStatus requestStatus = plannerStatus.getRequestStatus();
            if (requestStatus == null) {
                return;
            }
            Set explanations = requestStatus.getExplanations();
            if (explanations == null) {
                return;
            }
            LinkedHashSet<Explanation> rootProblems = new LinkedHashSet<Explanation>();
            HashMap<IInstallableUnit, HashSet<IRequirement>> links = new HashMap<IInstallableUnit, HashSet<IRequirement>>();
            for (Explanation explanation : explanations) {
                HashSet<Object> requirementSet;
                Explanation.HardRequirement link;
                if (explanation instanceof Explanation.HardRequirement) {
                    link = (Explanation.HardRequirement)explanation;
                    requirementSet = (HashSet<IRequirement>)links.get(link.iu);
                    if (requirementSet == null) {
                        requirementSet = new HashSet<IRequirement>();
                        links.put(link.iu, requirementSet);
                    }
                    requirementSet.add(link.req);
                    continue;
                }
                if (explanation instanceof Explanation.PatchedHardRequirement) {
                    link = (Explanation.PatchedHardRequirement)explanation;
                    requirementSet = (HashSet)links.get(link.iu);
                    if (requirementSet == null) {
                        requirementSet = new HashSet();
                        links.put(link.iu, requirementSet);
                    }
                    for (IRequirementChange change : link.patch.getRequirementsChange()) {
                        if (!change.newValue().equals(link.req)) continue;
                        for (IRequirement r : link.iu.getRequirements()) {
                            if (!(r instanceof IRequiredCapability) || !change.matches((IRequiredCapability)r)) continue;
                            requirementSet.add(r);
                        }
                    }
                    requirementSet = links.get(link.patch);
                    if (requirementSet == null) {
                        requirementSet = new HashSet();
                        links.put((IInstallableUnit)link.patch, requirementSet);
                    }
                    requirementSet.add(link.req);
                    continue;
                }
                if (!(explanation instanceof Explanation.MissingIU) && !(explanation instanceof Explanation.MissingGreedyIU) && !(explanation instanceof Explanation.Singleton)) continue;
                rootProblems.add(explanation);
            }
            HashMap<IInstallableUnit, VerificationDiagnostic.DependencyLink> dependencyChainsCache = new HashMap<IInstallableUnit, VerificationDiagnostic.DependencyLink>();
            for (Explanation rootProblem : rootProblems) {
                StringBuilder messageBuilder;
                VerificationDiagnostic.DependencyLink dependencyChain;
                if (rootProblem instanceof Explanation.Singleton) {
                    IInstallableUnit[] ius = ((Explanation.Singleton)rootProblem).ius;
                    LinkedHashSet<VerificationDiagnostic.DependencyLink> dependencyChains = new LinkedHashSet<VerificationDiagnostic.DependencyLink>(ius.length);
                    IInstallableUnit[] iInstallableUnitArray = ius;
                    int n = ius.length;
                    int r = 0;
                    while (r < n) {
                        IInstallableUnit iu = iInstallableUnitArray[r];
                        dependencyChains.add(this.getDependencyChain(iu, links, dependencyChainsCache));
                        ++r;
                    }
                    dependencyChains.remove(null);
                    URI resourceURI = resource.getURI();
                    LinkedHashSet<URI> modelElementURISet = new LinkedHashSet<URI>(dependencyChains.size());
                    StringBuilder messageBuilder2 = AnalyzedPlannerStatus.getRootProblemMessage(rootProblem);
                    for (VerificationDiagnostic.DependencyLink dependencyChain2 : dependencyChains) {
                        VerificationDiagnostic.identifyDependencyChain((VerificationDiagnostic.DependencyLink)dependencyChain2, (Resource)resource, (String)"\n", (String)MESSAGE_INDENT);
                        modelElementURISet.add(dependencyChain2.getModelElementURI().deresolve(resourceURI));
                        messageBuilder2.append('\n');
                        InstallableUnitUtils.appendIdentifier((StringBuilder)messageBuilder2, (IInstallableUnit)dependencyChain2.getInstallableUnit());
                        messageBuilder2.append(" is required by:");
                        VerificationDiagnostic.DependencyLink parent = dependencyChain2.getParent();
                        if (parent == null) continue;
                        messageBuilder2.append(parent.getIdentifier());
                    }
                    String message = messageBuilder2.toString();
                    LogUtils.error((String)message, (Object[])new Object[0]);
                    this.add((IStatus)new Status(4, plannerStatus.getPlugin(), message));
                    modelElementURISet.remove(null);
                    VerificationDiagnostic.Singleton[] relatedDiagnostics = new VerificationDiagnostic.Singleton[modelElementURISet.size()];
                    int i = 0;
                    for (URI modelElementURI : modelElementURISet) {
                        VerificationDiagnostic.Singleton singleton = new VerificationDiagnostic.Singleton(rootProblem, modelElementURI, relatedDiagnostics);
                        relatedDiagnostics[i++] = singleton;
                        this.verificationDiagnostics.add((VerificationDiagnostic)singleton);
                    }
                    continue;
                }
                if (rootProblem instanceof Explanation.MissingIU) {
                    Explanation.MissingIU missingIU = (Explanation.MissingIU)rootProblem;
                    dependencyChain = this.getDependencyChain(missingIU.iu, links, dependencyChainsCache);
                    if (dependencyChain == null) continue;
                    VerificationDiagnostic.identifyDependencyChain((VerificationDiagnostic.DependencyLink)dependencyChain, (Resource)resource, (String)"\n", (String)MESSAGE_INDENT);
                    messageBuilder = AnalyzedPlannerStatus.getRootProblemMessage(rootProblem);
                    messageBuilder.append('\n');
                    InstallableUnitUtils.appendIdentifier((StringBuilder)messageBuilder, (IRequirement)missingIU.req);
                    messageBuilder.append(" is required by:");
                    messageBuilder.append(dependencyChain.getIdentifier());
                    String message = messageBuilder.toString();
                    LogUtils.error((String)message, (Object[])new Object[0]);
                    this.add((IStatus)new Status(4, plannerStatus.getPlugin(), message));
                    URI modelElementURI = dependencyChain.getModelElementURI();
                    if (modelElementURI == null) continue;
                    this.verificationDiagnostics.add(new VerificationDiagnostic(rootProblem.toString(), dependencyChain.getModelElementURI().deresolve(resource.getURI())));
                    continue;
                }
                if (!(rootProblem instanceof Explanation.MissingGreedyIU)) continue;
                Explanation.MissingGreedyIU missingGreedyIU = (Explanation.MissingGreedyIU)rootProblem;
                dependencyChain = this.getDependencyChain(missingGreedyIU.iu, links, dependencyChainsCache);
                if (dependencyChain == null) continue;
                VerificationDiagnostic.identifyDependencyChain((VerificationDiagnostic.DependencyLink)dependencyChain, (Resource)resource, (String)"\n", (String)MESSAGE_INDENT);
                messageBuilder = AnalyzedPlannerStatus.getRootProblemMessage(rootProblem);
                messageBuilder.append('\n');
                InstallableUnitUtils.appendIdentifier((StringBuilder)messageBuilder, (IInstallableUnit)missingGreedyIU.iu);
                messageBuilder.append(" is required by:");
                VerificationDiagnostic.DependencyLink parent = dependencyChain.getParent();
                if (parent != null) {
                    messageBuilder.append(parent.getIdentifier());
                }
                String message = messageBuilder.toString();
                LogUtils.error((String)message, (Object[])new Object[0]);
                this.add((IStatus)new Status(4, plannerStatus.getPlugin(), message));
                URI modelElementURI = dependencyChain.getModelElementURI();
                if (modelElementURI == null) continue;
                this.verificationDiagnostics.add(new VerificationDiagnostic(rootProblem.toString(), dependencyChain.getModelElementURI().deresolve(resource.getURI())));
            }
        }

        protected VerificationDiagnostic.DependencyLink getDependencyChain(IInstallableUnit iu, HashMap<IInstallableUnit, HashSet<IRequirement>> links, HashMap<IInstallableUnit, VerificationDiagnostic.DependencyLink> dependencyChainsCache) {
            VerificationDiagnostic.DependencyLink lastLink;
            block5: {
                if (dependencyChainsCache.containsKey(iu)) {
                    return dependencyChainsCache.get(iu);
                }
                String elementURI = iu.getProperty("org.eclipse.cbi.p2repo.aggregator.model.element.URI");
                if (elementURI != null) {
                    lastLink = new VerificationDiagnostic.DependencyLink(iu, null);
                } else {
                    dependencyChainsCache.put(iu, null);
                    for (Map.Entry<IInstallableUnit, HashSet<IRequirement>> link : links.entrySet()) {
                        for (IRequirement requirement : link.getValue()) {
                            if (!requirement.isMatch(iu) || (lastLink = this.getDependencyChain(link.getKey(), links, dependencyChainsCache)) == null) continue;
                            lastLink = new VerificationDiagnostic.DependencyLink(iu, lastLink);
                            break block5;
                        }
                    }
                    return null;
                }
            }
            dependencyChainsCache.put(iu, lastLink);
            return lastLink;
        }

        public String getMessage() {
            StringBuilder bld = new StringBuilder();
            bld.append(super.getMessage());
            for (String error : ValidationSetVerifier.getResolutionErrors(this.plannerStatus)) {
                bld.append(' ');
                bld.append(error);
            }
            return bld.toString();
        }

        public PlannerStatus getPlannerStatus() {
            return this.plannerStatus;
        }

        public List<VerificationDiagnostic> getVerificationDiagnostics() {
            return this.verificationDiagnostics;
        }
    }
}

