/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.b3.aggregator.Aggregation;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.MapRule;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MappedUnit;
import org.eclipse.b3.aggregator.p2view.IUPresentation;
import org.eclipse.b3.aggregator.p2view.MetadataRepositoryStructuredView;
import org.eclipse.b3.p2.MetadataRepository;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class ItemUtils {
    public static MappedUnit addIU(MappedRepository mappedRepo, IInstallableUnit iu) {
        if (iu == null) {
            return null;
        }
        MappedUnit foundUnit = null;
        for (MappedUnit unit : mappedRepo.getUnits(false)) {
            if (!iu.getId().equals(unit.getName())) continue;
            foundUnit = unit;
        }
        if (foundUnit != null) {
            return null;
        }
        MappedUnit newMU = AggregatorFactory.eINSTANCE.createMappedUnit(iu);
        mappedRepo.addUnit(newMU);
        return newMU;
    }

    public static MapRule addMapRule(MappedRepository mappedRepo, IInstallableUnit iu, Class<? extends MapRule> ruleClass) {
        if (iu == null) {
            return null;
        }
        MapRule foundRule = null;
        for (MapRule rule : mappedRepo.getMapRules()) {
            if (!iu.getId().equals(rule.getName())) continue;
            foundRule = rule;
        }
        if (foundRule != null) {
            return null;
        }
        MapRule newMR = AggregatorFactory.eINSTANCE.createMapRule(iu, ruleClass);
        mappedRepo.getMapRules().add((Object)newMR);
        return newMR;
    }

    public static MappedRepository addMDR(Contribution contribution, MetadataRepository mdr) {
        if (mdr == null) {
            return null;
        }
        if (ItemUtils.findMappedRepository(contribution, mdr) != null) {
            return null;
        }
        MappedRepository newMappedRepo = AggregatorFactory.eINSTANCE.createMappedRepository(mdr);
        contribution.getRepositories().add((Object)newMappedRepo);
        return newMappedRepo;
    }

    public static MappedRepository findMappedRepository(Aggregation aggregator, MetadataRepository mdr) {
        for (Contribution contribution : aggregator.getAllContributions(true)) {
            MappedRepository repo = ItemUtils.findMappedRepository(contribution, mdr);
            if (repo == null) continue;
            return repo;
        }
        return null;
    }

    public static MappedRepository findMappedRepository(Contribution contribution, MetadataRepository mdr) {
        if (mdr == null) {
            return null;
        }
        for (MappedRepository repo : contribution.getRepositories()) {
            if (!mdr.equals(repo.getMetadataRepository(false)) || !repo.isBranchEnabled()) continue;
            return repo;
        }
        return null;
    }

    public static MappedUnit findMappedUnit(MappedRepository mappedRepo, IInstallableUnit iu) {
        for (MappedUnit unit : mappedRepo.getUnits(false)) {
            if (!iu.getId().equals(unit.getName())) continue;
            return unit;
        }
        return null;
    }

    public static MapRule findMapRule(MappedRepository mappedRepo, IInstallableUnit iu) {
        for (MapRule rule : mappedRepo.getMapRules()) {
            if (!iu.getId().equals(rule.getName())) continue;
            return rule;
        }
        return null;
    }

    public static Collection<? extends IInstallableUnit> getIUs(Collection<? extends IUPresentation> iups) {
        ArrayList<IInstallableUnit> set = new ArrayList<IInstallableUnit>();
        for (IUPresentation iUPresentation : iups) {
            if (iUPresentation.getInstallableUnit() == null) continue;
            set.add(iUPresentation.getInstallableUnit());
        }
        return set;
    }

    public static Collection<MetadataRepository> getMDRs(Collection<? extends MetadataRepositoryStructuredView> mdrsvs) {
        HashSet<MetadataRepository> set = new HashSet<MetadataRepository>();
        for (MetadataRepositoryStructuredView metadataRepositoryStructuredView : mdrsvs) {
            if (metadataRepositoryStructuredView.getMetadataRepository() == null) continue;
            set.add(metadataRepositoryStructuredView.getMetadataRepository());
        }
        return set;
    }

    public static boolean haveSameLocation(MappedRepository mappedRepo, Collection<? extends IInstallableUnit> selectedIUs) {
        String location = mappedRepo.getResolvedLocation();
        if (location == null) {
            return false;
        }
        for (IInstallableUnit iInstallableUnit : selectedIUs) {
            if (!(((EObject)iInstallableUnit).eContainer() instanceof MetadataRepository)) {
                return false;
            }
            MetadataRepository mdr = (MetadataRepository)((EObject)iInstallableUnit).eContainer();
            if (mdr.getLocation() == null) {
                return false;
            }
            if (location.equalsIgnoreCase(mdr.getLocation().toString())) continue;
            return false;
        }
        return true;
    }
}

