/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.b3.aggregator.ExclusionRule;
import org.eclipse.b3.aggregator.MapRule;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MappedUnit;
import org.eclipse.b3.aggregator.ValidConfigurationsRule;
import org.eclipse.b3.aggregator.provider.AggregatorEditPlugin;
import org.eclipse.b3.aggregator.util.ItemUtils;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.DragAndDropFeedback;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class AddIUsToMappedRepositoryCommand
extends AbstractCommand
implements DragAndDropFeedback {
    private MappedRepository mappedRepo;
    private List<IInstallableUnit> selectedIUs;
    private int operation;
    private List<MappedUnit> addedMappedUnits = new ArrayList<MappedUnit>();
    private List<MapRule> addedMapRules = new ArrayList<MapRule>();

    public AddIUsToMappedRepositoryCommand(MappedRepository mappedRepo, List<IInstallableUnit> selectedIUs) {
        this(mappedRepo, selectedIUs, 32);
    }

    public AddIUsToMappedRepositoryCommand(MappedRepository mappedRepo, List<IInstallableUnit> selectedIUs, int operation) {
        super(String.valueOf(AggregatorEditPlugin.INSTANCE.getString("_UI_Map_to_command_prefix")) + " " + AggregatorEditPlugin.INSTANCE.getString("_UI_MappedRepository_type") + " " + mappedRepo.getLocation());
        this.mappedRepo = mappedRepo;
        this.selectedIUs = selectedIUs;
        this.operation = operation;
    }

    public void execute() {
        block3: {
            block2: {
                this.addedMappedUnits.clear();
                this.addedMapRules.clear();
                if ((this.operation & 0x20) <= 0) break block2;
                for (IInstallableUnit iu : this.selectedIUs) {
                    MappedUnit newMU = ItemUtils.addIU(this.mappedRepo, iu);
                    if (newMU == null) continue;
                    this.addedMappedUnits.add(newMU);
                }
                break block3;
            }
            if ((this.operation & 0xC0) <= 0) break block3;
            for (IInstallableUnit iu : this.selectedIUs) {
                MapRule newMR = ItemUtils.addMapRule(this.mappedRepo, iu, (this.operation & 0x40) > 0 ? ExclusionRule.class : ValidConfigurationsRule.class);
                if (newMR == null) continue;
                this.addedMapRules.add(newMR);
            }
        }
    }

    public int getFeedback() {
        return 1;
    }

    public int getOperation() {
        return 4;
    }

    protected boolean prepare() {
        boolean result;
        boolean bl = result = this.mappedRepo != null && this.mappedRepo.isBranchEnabled() && this.selectedIUs != null && this.selectedIUs.size() > 0 && ItemUtils.haveSameLocation(this.mappedRepo, this.selectedIUs);
        if (result) {
            for (IInstallableUnit iu : this.selectedIUs) {
                if (ItemUtils.findMappedUnit(this.mappedRepo, iu) == null && ItemUtils.findMapRule(this.mappedRepo, iu) == null) continue;
                return false;
            }
        }
        return result;
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        MappedRepository repo;
        for (MappedUnit unit : this.addedMappedUnits) {
            repo = (MappedRepository)((EObject)unit).eContainer();
            repo.removeUnit(unit);
        }
        for (MapRule rule : this.addedMapRules) {
            repo = (MappedRepository)((EObject)rule).eContainer();
            repo.getMapRules().remove((Object)rule);
        }
    }

    public boolean validate(Object owner, float location, int operations, int operation, Collection<?> collection) {
        return true;
    }
}

