/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.presentation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.b3.aggregator.Feature;
import org.eclipse.b3.aggregator.InstallableUnitRequest;
import org.eclipse.b3.aggregator.presentation.FixVersionsDialog;
import org.eclipse.b3.aggregator.presentation.VersionRangeEditorDialog;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class FixVersionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EditingDomain domain = null;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(editor instanceof IEditingDomainProvider)) {
            return null;
        }
        domain = ((IEditingDomainProvider)editor).getEditingDomain();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (editor instanceof ISelectionProvider) {
            selection = ((ISelectionProvider)editor).getSelection();
        }
        if (selection.isEmpty()) {
            return null;
        }
        List items = Collections.emptyList();
        if (selection instanceof IStructuredSelection) {
            items = ((IStructuredSelection)selection).toList();
        }
        HashMap<Object, VersionRange> versionsToSet = new HashMap<Object, VersionRange>();
        if (items.size() == 1 && items.get(0) instanceof InstallableUnitRequest) {
            Feature feature = (Feature)items.get(0);
            VersionRangeEditorDialog versionRangeEditorDialog = new VersionRangeEditorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), null, feature.getVersionRange(), feature);
            versionRangeEditorDialog.setBlockOnOpen(true);
            if (versionRangeEditorDialog.open() == 0) {
                versionsToSet.put(feature, versionRangeEditorDialog.getResult());
            }
        } else {
            FixVersionsDialog dialog = new FixVersionsDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), new HashSet<Object>(items));
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                for (Map.Entry<InstallableUnitRequest, Version> entry : dialog.getResult().entrySet()) {
                    versionsToSet.put(entry.getKey(), new VersionRange(entry.getValue(), true, entry.getValue(), true));
                }
            }
        }
        if (!versionsToSet.isEmpty()) {
            CompoundCommand compoundCommand = new CompoundCommand();
            for (final Map.Entry<Object, Object> entry : versionsToSet.entrySet()) {
                AbstractCommand command = new AbstractCommand("Set version"){

                    public boolean canExecute() {
                        return true;
                    }

                    public void execute() {
                        ((InstallableUnitRequest)entry.getKey()).setVersionRange((VersionRange)entry.getValue());
                    }

                    public Collection<?> getAffectedObjects() {
                        return Collections.singletonList((InstallableUnitRequest)entry.getKey());
                    }

                    public void redo() {
                        this.execute();
                    }
                };
                compoundCommand.append((Command)command);
            }
            domain.getCommandStack().execute((Command)compoundCommand);
        }
        return null;
    }
}

