/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.presentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.b3.aggregator.Aggregation;
import org.eclipse.b3.aggregator.AvailableVersion;
import org.eclipse.b3.aggregator.B3Messages;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.InstallableUnitRequest;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FixVersionsDialog
extends TitleAreaDialog {
    private Map<InstallableUnitRequest, Version> suggestedVersions = new HashMap<InstallableUnitRequest, Version>();

    public FixVersionsDialog(Shell parentShell, Set<Object> aggregatorModelObjects) {
        super(parentShell);
        LinkedList<Object> toProcess = new LinkedList<Object>(aggregatorModelObjects);
        HashSet<Object> processed = new HashSet<Object>();
        while (!toProcess.isEmpty()) {
            Object current = toProcess.pop();
            if (processed.contains(current)) continue;
            processed.add(current);
            if (current instanceof InstallableUnitRequest) {
                VersionRange range;
                InstallableUnitRequest feature = (InstallableUnitRequest)current;
                EList availableVersions = feature.getAvailableVersions();
                if (availableVersions == null || availableVersions.isEmpty()) continue;
                boolean skip = false;
                if (feature.getVersionRange() != null && (range = feature.getVersionRange()).getIncludeMaximum() && range.getIncludeMaximum() && range.getMinimum().equals(range.getMaximum())) {
                    for (AvailableVersion available : feature.getAvailableVersions()) {
                        if (!available.getVersion().equals(range.getMaximum())) continue;
                        skip = true;
                    }
                }
                if (skip) continue;
                this.suggestedVersions.put(feature, ((AvailableVersion)availableVersions.get(0)).getVersion());
                for (AvailableVersion version : availableVersions) {
                    VersionRange range2 = feature.getVersionRange();
                    if (range2 != null && !range2.isIncluded(version.getVersion()) || this.suggestedVersions.containsKey(feature) && this.suggestedVersions.get(feature).compareTo((Object)version.getVersion()) >= 0) continue;
                    this.suggestedVersions.put(feature, version.getVersion());
                }
                continue;
            }
            if (current instanceof Aggregation) {
                toProcess.addAll((Collection<Object>)((Aggregation)current).getAllContributions(false));
                continue;
            }
            if (current instanceof Contribution) {
                toProcess.addAll((Collection<Object>)((Contribution)current).getRepositories());
                continue;
            }
            if (!(current instanceof MappedRepository)) continue;
            toProcess.addAll((Collection<Object>)((MappedRepository)current).getFeatures());
        }
    }

    public Control createDialogArea(Composite parent) {
        this.setTitle(B3Messages.FixVersionDialog_Title);
        this.setMessage(B3Messages.FixVersionDialog_UpdateMessage);
        Composite res = new Composite(parent, 0);
        res.setLayoutData((Object)new GridData(4, 4, true, true));
        res.setLayout((Layout)new GridLayout(1, false));
        Label summaryLabel = new Label(res, 0);
        summaryLabel.setText(String.valueOf(this.suggestedVersions.size()) + " versions to update.");
        final TableViewer viewer = new TableViewer(res);
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        TableViewerColumn nameColumn = new TableViewerColumn(viewer, -1);
        nameColumn.getColumn().setText("Feature");
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setWidth(200);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object o) {
                return ((InstallableUnitRequest)o).getName();
            }
        });
        TableViewerColumn previousVersion = new TableViewerColumn(viewer, -1);
        previousVersion.getColumn().setResizable(true);
        previousVersion.getColumn().setWidth(200);
        previousVersion.getColumn().setText("Current Version");
        previousVersion.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object o) {
                VersionRange range = ((InstallableUnitRequest)o).getVersionRange();
                if (range != null) {
                    return range.toString();
                }
                return "";
            }
        });
        TableViewerColumn suggestedVersion = new TableViewerColumn(viewer, -1);
        suggestedVersion.getColumn().setText("Suggested Version");
        suggestedVersion.getColumn().setResizable(true);
        suggestedVersion.getColumn().setWidth(200);
        suggestedVersion.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Color getForeground(Object o) {
                InstallableUnitRequest feature = (InstallableUnitRequest)o;
                VersionRange range = feature.getVersionRange();
                if (range != null && !range.isIncluded((Version)FixVersionsDialog.this.suggestedVersions.get(feature))) {
                    return viewer.getControl().getDisplay().getSystemColor(3);
                }
                return viewer.getControl().getDisplay().getSystemColor(6);
            }

            public String getText(Object o) {
                InstallableUnitRequest feature = (InstallableUnitRequest)o;
                return ((Version)FixVersionsDialog.this.suggestedVersions.get(feature)).toString();
            }
        });
        suggestedVersion.setEditingSupport(new EditingSupport((ColumnViewer)viewer){

            protected boolean canEdit(Object element) {
                return ((InstallableUnitRequest)element).getAvailableVersions().size() > 1;
            }

            protected CellEditor getCellEditor(Object element) {
                InstallableUnitRequest feature = (InstallableUnitRequest)element;
                ComboBoxViewerCellEditor comboCellEditor = new ComboBoxViewerCellEditor((Composite)viewer.getTable());
                comboCellEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                ArrayList<Version> content = new ArrayList<Version>();
                for (AvailableVersion version : feature.getAvailableVersions()) {
                    content.add(version.getVersion());
                }
                comboCellEditor.setInput(content);
                return comboCellEditor;
            }

            protected Version getValue(Object element) {
                InstallableUnitRequest feature = (InstallableUnitRequest)element;
                return (Version)FixVersionsDialog.this.suggestedVersions.get(feature);
            }

            protected void setValue(Object element, Object value) {
                FixVersionsDialog.this.suggestedVersions.put((InstallableUnitRequest)element, (Version)value);
                viewer.refresh(element);
            }
        });
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput(this.suggestedVersions.keySet());
        return res;
    }

    public Map<InstallableUnitRequest, Version> getResult() {
        return this.suggestedVersions;
    }
}

