/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.mail.MailMessage;
import org.eclipse.b3.aggregator.Aggregation;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.Contact;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.CustomCategory;
import org.eclipse.b3.aggregator.Feature;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.PackedStrategy;
import org.eclipse.b3.aggregator.ValidationSet;
import org.eclipse.b3.aggregator.engine.CategoriesGenerator;
import org.eclipse.b3.aggregator.engine.MetadataMirrorGenerator;
import org.eclipse.b3.aggregator.engine.MirrorGenerator;
import org.eclipse.b3.aggregator.engine.ModelAbstractCommand;
import org.eclipse.b3.aggregator.engine.SourceCompositeGenerator;
import org.eclipse.b3.aggregator.engine.ValidationSetVerifier;
import org.eclipse.b3.aggregator.engine.VerificationIUGenerator;
import org.eclipse.b3.aggregator.engine.maven.InstallableUnitMapping;
import org.eclipse.b3.aggregator.engine.maven.MavenManager;
import org.eclipse.b3.aggregator.engine.maven.MavenRepositoryHelper;
import org.eclipse.b3.aggregator.impl.MetadataRepositoryReferenceImpl;
import org.eclipse.b3.aggregator.util.ResourceUtils;
import org.eclipse.b3.p2.MetadataRepository;
import org.eclipse.b3.p2.loader.IRepositoryLoader;
import org.eclipse.b3.p2.maven.indexer.IMaven2Indexer;
import org.eclipse.b3.p2.maven.indexer.IndexerUtils;
import org.eclipse.b3.p2.util.IUUtils;
import org.eclipse.b3.p2.util.P2ResourceImpl;
import org.eclipse.b3.p2.util.P2Utils;
import org.eclipse.b3.p2.util.RepositoryLoaderUtils;
import org.eclipse.b3.p2.util.ResourceSetWithAgent;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.b3.util.IOUtils;
import org.eclipse.b3.util.LogUtils;
import org.eclipse.b3.util.MonitorUtils;
import org.eclipse.b3.util.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class Builder
extends ModelAbstractCommand {
    public static final String PDE_TARGET_PLATFORM_NAMESPACE = "A.PDE.Target.Platform";
    public static final String PDE_TARGET_PLATFORM_NAME = "Cannot be installed into the IDE";
    public static final Version ALL_CONTRIBUTED_CONTENT_VERSION = Version.createOSGi((int)1, (int)0, (int)0);
    public static final String COMPOSITE_ARTIFACTS_TYPE = "org.eclipse.equinox.p2.artifact.repository.compositeRepository";
    public static final String COMPOSITE_METADATA_TYPE = "org.eclipse.equinox.p2.metadata.repository.compositeRepository";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String NAMESPACE_OSGI_BUNDLE = "osgi.bundle";
    public static final String PROFILE_ID = "b3AggregatorProfile";
    public static final String REPO_FOLDER_VERIFICATION = "verification";
    public static final String REPO_FOLDER_FINAL = "final";
    public static final String REPO_FOLDER_INTERIM = "interim";
    public static final String REPO_FOLDER_TEMP = "temp";
    public static final String REPO_FOLDER_AGGREGATE = "aggregate";
    public static final String REPO_FOLDER_CUSTOM_CATEGORIES = "/custom_categories";
    public static final String SIMPLE_ARTIFACTS_TYPE = "org.eclipse.equinox.p2.artifact.repository.simpleRepository";
    public static final String SIMPLE_METADATA_TYPE = "org.eclipse.equinox.p2.metadata.repository.simpleRepository";
    public static final String INTERNAL_METADATA_TYPE = "org.eclipse.b3.aggregator.engine.internalRepository";
    public static final String PROP_AGGREGATOR_GENERATED_IU = "org.eclipse.b3.aggregator.generated.IU";
    public static final String PROP_ATOMIC_COMPOSITE_LOADING = "p2.atomic.composite.loading";
    public static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmm");
    static final String FEATURE_GROUP_SUFFIX = ".feature.group";
    static final IArtifactKey[] NO_ARTIFACT_KEYS = new IArtifactKey[0];
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final Project PROPERTY_REPLACER = new Project();
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HHmm");
    private static final String[] compositeFileNames;
    @Option(name="--action", usage="Specifies the type of the execution. Default is BUILD.")
    private ActionType action = ActionType.BUILD;
    @Option(name="--buildId", usage="Assigns a build identifier to the aggregation. The identifier is used to identify the build in notification emails. Defaults to: build-<timestamp> where <timestamp> is formatted according as yyyyMMddHHmm, i.e. build-200911031527", metaVar="<ID>")
    private String buildID;
    @Option(name="--buildRoot", usage="Controls the output. Defaults to the build root defined in the aggregation definition.")
    private File buildRoot;
    @Option(name="--logURL", usage="The URL that will be pasted into the emails. Should normally point to the a public URL for output log for the aggregator so that the receiver can browse the log for details on failures.", metaVar="<url>")
    private String logURL;
    @Option(name="--production", usage="Indicates that the build is running in real production. That means that no mock emails will be sent. Instead, the contacts listed for each contribution will get emails when things go wrong.")
    private boolean production = false;
    @Option(name="--mockEmailCc", usage="Becomes the CC receiver of the mock-emails sent from the aggregator", metaVar="<address>")
    private String mockEmailCC;
    @Option(name="--emailFrom", usage="Becomes the sender of the emails sent from the aggregator. Defaults to the build master defined in the aggregator definition.", metaVar="<address>")
    private String emailFrom;
    @Option(name="--emailFromName", usage="Mock sender's name", metaVar="<name>")
    private String emailFromName;
    @Option(name="--mockEmailTo", usage="Becomes the receiver of the mock-emails sent from the aggregator", metaVar="<address>")
    private String mockEmailTo;
    @Option(name="--smtpHost", usage="The SMTP host to talk to when sending emails. Defaults to \"localhost\".", metaVar="<host>")
    private String smtpHost;
    @Option(name="--smtpPort", usage="The SMTP port number to use when talking to the SMTP host. Default is 25.", metaVar="<port>")
    private int smtpPort;
    @Option(name="--subjectPrefix", usage="The prefix to use for the subject when sending emails. Defaults to the label defined in the aggregation definition. The subject is formatted as: \"[<subjectPrefix>] Failed for build <buildId>\"", metaVar="<subject>")
    private String subjectPrefix;
    @Option(name="--packedStrategy", usage="(Deprecated) Controls how mirroring is done of packed artifacts found in the source repository.Defaults to the setting in the aggregation definition.")
    private PackedStrategy packedStrategy;
    @Option(name="--trustedContributions", usage="(Deprecated) A comma separated list of contributions with repositories that will be referenced directly (through a composite repository) rather than mirrored into the final repository (even if the repository is set to mirror artifacts by default)", metaVar="<contributions>")
    private String trustedContributions;
    @Option(name="--validationContributions", usage="(Deprecated) A comma separated list of contributions with repositories that will be used for aggregation validation only rather than mirrored or referenced into the final repository.", metaVar="<contributions>")
    private String validationContributions;
    @Option(name="--mavenResult", usage="(Deprecated) Tells the aggregator to generate a hybrid repository that is compatible with p2 and maven2.")
    private Boolean mavenResult;
    @Option(name="--mirrorReferences", usage="(Deprecated) Mirror all meta-data repository references from the contributed repositories.")
    private boolean mirrorReferences = false;
    @Option(name="--referenceIncludePattern", usage="(Deprecated) Include only those references that matches the given regular expression pattern.", metaVar="<regexp>", handler=PatternOptionHandler.class)
    private Pattern referenceIncludePattern;
    @Option(name="--referenceExcludePattern", usage="(Deprecated) Exclude all references that matches the given regular expression pattern. An exclusion takes precedence over an inclusion in case both patterns match a reference.", metaVar="<regexp>", handler=PatternOptionHandler.class)
    private Pattern referenceExcludePattern;
    @Option(name="--agentLocation", usage="The location of the p2 provisioning agent", metaVar="directory")
    private File agentLocation;
    @Argument
    private List<String> unparsed = new ArrayList<String>();
    private Aggregation aggregation;
    private String buildLabel;
    private String buildMasterEmail;
    private String buildMasterName;
    private String buildMasterBackupEmail;
    private String buildMasterBackupName;
    private IMetadataRepository aggregationMdr;
    private List<IInstallableUnit> validationIUs;
    private boolean sendmail = false;
    private Set<MappedRepository> exclusions;
    private IProvisioningAgent provisioningAgent;
    private boolean fromIDE;
    private Map<ValidationSet, ValidationSetAnnotations> validationSetAnnotationsMap = new HashMap<ValidationSet, ValidationSetAnnotations>();
    private Map<MappedRepository, String> safeRepositoryNameMap = new HashMap<MappedRepository, String>();
    private Set<String> safeRepositoryNames = new HashSet<String>();
    private Map<MetadataRepositoryReference, IArtifactRepository> arCache;
    private IArtifactRepositoryManager arManager;
    private IMetadataRepositoryManager mdrManager;
    private IFileArtifactRepository aggregationAr;
    private MavenRepositoryHelper mavenHelper;
    private Set<IArtifactKey> keysToExcludeFromMirroring;

    static {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        PROPERTY_REPLACER.initProperties();
        DATE_FORMAT.setTimeZone(utc);
        TIME_FORMAT.setTimeZone(utc);
        TIMESTAMP_FORMAT.setTimeZone(utc);
        compositeFileNames = new String[]{"compositeContent.jar", "compositeContent.xml", "content.jar", "content.xml"};
    }

    public static final java.net.URI createURI(File repoLocation) throws CoreException {
        IPath path;
        if (repoLocation != null && (path = Path.fromOSString((String)repoLocation.getPath())).isAbsolute()) {
            try {
                String pathStr = path.removeTrailingSeparator().toPortableString();
                if (!pathStr.startsWith("/")) {
                    pathStr = "/" + pathStr;
                }
                return new java.net.URI("file", null, pathStr, null);
            }
            catch (URISyntaxException e) {
                throw ExceptionUtils.wrap((Throwable)e);
            }
        }
        throw ExceptionUtils.fromMessage((String)"File %s is not an absolute path", (Object[])new Object[]{repoLocation});
    }

    private static void deleteMetadataRepository(IMetadataRepositoryManager mdrMgr, File repoFolder) throws CoreException {
        java.net.URI repoURI = Builder.createURI(repoFolder);
        mdrMgr.removeRepository(repoURI);
        String[] stringArray = compositeFileNames;
        int n = compositeFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            new File(repoFolder, name).delete();
            ++n2;
        }
    }

    public static String getExceptionMessages(Throwable e) {
        StringBuilder bld = new StringBuilder();
        Builder.getExceptionMessages(e, bld);
        return bld.toString();
    }

    private static void getExceptionMessages(Throwable e, StringBuilder bld) {
        bld.append(e.getClass().getName());
        bld.append(": ");
        if (e.getMessage() != null) {
            bld.append(e.getMessage());
        }
        if (e instanceof CoreException) {
            e = ((CoreException)e).getStatus().getException();
        } else {
            Throwable t = e.getCause();
            Throwable throwable = e = t == e ? null : t;
        }
        if (e != null) {
            bld.append("\nCaused by: ");
            Builder.getExceptionMessages(e, bld);
        }
    }

    public static IInstallableUnit getIU(IMetadataRepository mdr, String id, String version) {
        IQuery query = (version = StringUtils.trimmedOrNull((String)version)) == null ? QueryUtil.createIUQuery((String)id) : QueryUtil.createIUQuery((String)id, (Version)Version.create((String)version));
        IQueryResult result = mdr.query(query, null);
        return !result.isEmpty() ? (IInstallableUnit)result.iterator().next() : null;
    }

    public static String getValidationSetLabel(ValidationSet validationSet) {
        return validationSet == null ? "<main>" : validationSet.getLabel();
    }

    private static void send(String host, int port, EmailAddress from, List<EmailAddress> toList, List<EmailAddress> ccList, String subject, String message) throws IOException {
        MailMessage mailMessage = new MailMessage(host, port);
        mailMessage.from(from.toString());
        for (EmailAddress to : toList) {
            mailMessage.to(to.toString());
        }
        for (EmailAddress cc : ccList) {
            mailMessage.cc(cc.toString());
        }
        mailMessage.setSubject(subject);
        mailMessage.setHeader("Date", DateUtils.getDateForHeader());
        mailMessage.setHeader("Content-Type", "text/plain; charset=us-ascii");
        PrintStream out = mailMessage.getPrintStream();
        out.print(message);
        mailMessage.sendAndClose();
    }

    public void addMappingExclusion(MappedRepository repository) {
        if (this.exclusions == null) {
            this.exclusions = new HashSet<MappedRepository>();
        }
        this.exclusions.add(repository);
    }

    private void cleanAll() throws CoreException {
        if (this.buildRoot.exists()) {
            FileUtils.deleteAll((File)this.buildRoot);
            if (this.buildRoot.exists()) {
                throw ExceptionUtils.fromMessage((String)"Failed to delete folder %s", (Object[])new Object[]{this.buildRoot.getAbsolutePath()});
            }
        }
    }

    private void cleanMemoryCaches() {
        this.validationSetAnnotationsMap.clear();
        this.safeRepositoryNameMap.clear();
        this.safeRepositoryNames.clear();
    }

    private void cleanMetadata(boolean forValidation) throws CoreException {
        IMetadataRepositoryManager mdrMgr = this.getMdrManager();
        if (!forValidation) {
            File finalRepo = new File(this.buildRoot, REPO_FOLDER_FINAL);
            Builder.deleteMetadataRepository(mdrMgr, finalRepo);
            Builder.deleteMetadataRepository(mdrMgr, new File(finalRepo, REPO_FOLDER_AGGREGATE));
        }
        File interimRepo = new File(this.buildRoot, REPO_FOLDER_INTERIM);
        Builder.deleteMetadataRepository(mdrMgr, interimRepo);
        Builder.deleteMetadataRepository(mdrMgr, new File(interimRepo, REPO_FOLDER_VERIFICATION));
    }

    private void finishMirroring(IProgressMonitor monitor) throws CoreException {
        if (this.mavenHelper != null) {
            this.mavenAddMetadata();
        }
        IArtifactRepositoryManager arMgr = this.getArManager();
        IMetadataRepositoryManager mdrMgr = this.getMdrManager();
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            String[] content;
            File aggregateDestination;
            block30: {
                String name;
                int n;
                int n2;
                Object object;
                boolean hasMirroredArtifacts;
                ArrayList<MappedRepository> reposWithReferencedArtifacts = new ArrayList<MappedRepository>();
                ArrayList<MappedRepository> reposWithReferencedMetadata = new ArrayList<MappedRepository>();
                for (Contribution contrib : this.aggregation.getAllContributions(true)) {
                    for (MappedRepository repo : contrib.getRepositories(true)) {
                        if (this.isMapVerbatim(repo)) {
                            reposWithReferencedArtifacts.add(repo);
                            reposWithReferencedMetadata.add(repo);
                            continue;
                        }
                        if (repo.isMirrorArtifacts() || !"p2".equals(repo.getNature())) continue;
                        reposWithReferencedArtifacts.add(repo);
                    }
                }
                File destination = new File(this.getBuildRoot(), REPO_FOLDER_FINAL);
                java.net.URI finalURI = Builder.createURI(destination);
                aggregateDestination = new File(destination, REPO_FOLDER_AGGREGATE);
                java.net.URI aggregateURI = Builder.createURI(aggregateDestination);
                Properties p2Index = new Properties();
                if (reposWithReferencedMetadata.isEmpty()) {
                    LogUtils.info((String)"Making the aggregated metadata repository final at %s", (Object[])new Object[]{finalURI});
                    File oldLocation = new File(aggregateDestination, "content.jar");
                    File newLocation = new File(destination, oldLocation.getName());
                    if (!oldLocation.renameTo(newLocation)) {
                        throw ExceptionUtils.fromMessage((String)"Unable to move %s to %s", (Object[])new Object[]{oldLocation.getAbsolutePath(), newLocation.getAbsolutePath()});
                    }
                    mdrMgr.removeRepository(aggregateURI);
                    p2Index.setProperty("metadata.repository.factory.order", "content.xml,!");
                } else {
                    LogUtils.info((String)"Building final metadata composite at %s", (Object[])new Object[]{finalURI});
                    mdrMgr.removeRepository(finalURI);
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("p2.compressed", Boolean.toString(true));
                    properties.put(PROP_ATOMIC_COMPOSITE_LOADING, Boolean.toString(true));
                    CompositeMetadataRepository compositeMdr = (CompositeMetadataRepository)mdrMgr.createRepository(finalURI, this.getAggregation().getLabel(), COMPOSITE_METADATA_TYPE, properties);
                    compositeMdr.addChild(java.net.URI.create(REPO_FOLDER_AGGREGATE));
                    for (MappedRepository referenced : reposWithReferencedMetadata) {
                        compositeMdr.addChild(referenced.getMetadataRepository().getLocation());
                    }
                    p2Index.setProperty("metadata.repository.factory.order", "compositeContent.xml,!");
                    LogUtils.info((String)"Done building final metadata composite", (Object[])new Object[0]);
                }
                subMon.worked(10);
                IFileArtifactRepository artifacts = this.getAggregationArtifactRepository((IProgressMonitor)subMon.newChild(2));
                IQueryResult artifactKeys = artifacts.query(QueryUtil.createMatchQuery(IArtifactKey.class, (IExpression)ExpressionUtil.TRUE_EXPRESSION, (Object[])new Object[0]), monitor);
                boolean bl = hasMirroredArtifacts = !artifactKeys.isEmpty();
                if (!hasMirroredArtifacts) {
                    object = aggregateDestination.list();
                    n2 = ((String[])object).length;
                    n = 0;
                    while (n < n2) {
                        name = object[n];
                        if (!"content.jar".equals(name)) {
                            FileUtils.deleteAll((File)new File(aggregateDestination, name));
                        }
                        ++n;
                    }
                }
                arMgr.removeRepository(aggregateURI);
                if (hasMirroredArtifacts && reposWithReferencedArtifacts.isEmpty()) {
                    LogUtils.info((String)"Making the aggregated artifact repository final at %s", (Object[])new Object[]{finalURI});
                    object = aggregateDestination.list();
                    n2 = ((String[])object).length;
                    n = 0;
                    while (n < n2) {
                        name = object[n];
                        if (!"content.jar".equals(name)) {
                            File oldLocation = new File(aggregateDestination, name);
                            if (hasMirroredArtifacts) {
                                File newLocation = new File(destination, name);
                                if (!oldLocation.renameTo(newLocation)) {
                                    throw ExceptionUtils.fromMessage((String)"Unable to move %s to %s", (Object[])new Object[]{oldLocation.getAbsolutePath(), newLocation.getAbsolutePath()});
                                }
                            } else {
                                FileUtils.deleteAll((File)oldLocation);
                            }
                        }
                        ++n;
                    }
                    p2Index.setProperty("artifact.repository.factory.order", "artifacts.xml,!");
                } else {
                    LogUtils.info((String)"Building final artifact composite at %s", (Object[])new Object[]{finalURI});
                    arMgr.removeRepository(finalURI);
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("p2.compressed", Boolean.toString(true));
                    properties.put(PROP_ATOMIC_COMPOSITE_LOADING, Boolean.toString(true));
                    CompositeArtifactRepository compositeAr = (CompositeArtifactRepository)arMgr.createRepository(finalURI, String.valueOf(this.getAggregation().getLabel()) + " artifacts", COMPOSITE_ARTIFACTS_TYPE, properties);
                    for (MappedRepository referenced : reposWithReferencedArtifacts) {
                        compositeAr.addChild(referenced.getMetadataRepository().getLocation());
                    }
                    if (hasMirroredArtifacts) {
                        compositeAr.addChild(finalURI.relativize(aggregateURI));
                    }
                    p2Index.setProperty("artifact.repository.factory.order", "compositeArtifacts.xml,!");
                    LogUtils.info((String)"Done building final artifact composite", (Object[])new Object[0]);
                }
                if (!p2Index.isEmpty()) {
                    p2Index.setProperty("version", "1");
                    File p2IndexFile = new File(destination, "p2.index");
                    BufferedOutputStream out = null;
                    try {
                        try {
                            out = new BufferedOutputStream(new FileOutputStream(p2IndexFile));
                            p2Index.store(out, String.format(" p2.index file to speed things up.%n Please note that the values in this file denotes repository factories and%n not files. The factory '<name>.xml' will look for both the <name>.jar%n and the <name>.xml file, in that order", new Object[0]));
                        }
                        catch (IOException e) {
                            LogUtils.error((String)"Unable to create p2.index file", (Object[])new Object[]{e});
                            IOUtils.close((Closeable)out);
                            break block30;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(out);
                        throw throwable;
                    }
                    IOUtils.close((Closeable)out);
                }
            }
            if ((content = aggregateDestination.list()) != null && content.length == 0 && !aggregateDestination.delete()) {
                throw ExceptionUtils.fromMessage((String)"Unable to remove %s", (Object[])new Object[]{aggregateDestination.getAbsolutePath()});
            }
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    public Aggregation getAggregation() {
        return this.aggregation;
    }

    public IFileArtifactRepository getAggregationArtifactRepository(IProgressMonitor monitor) throws CoreException {
        if (this.aggregationAr != null) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return this.aggregationAr;
        }
        IArtifactRepositoryManager arMgr = this.getArManager();
        File destination = new File(this.getBuildRoot(), REPO_FOLDER_FINAL);
        File aggregateDestination = new File(destination, REPO_FOLDER_AGGREGATE);
        java.net.URI aggregateURI = Builder.createURI(aggregateDestination);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", Boolean.toString(true));
        properties.put("publishPackFilesAsSiblings", Boolean.toString(true));
        try {
            this.aggregationAr = (IFileArtifactRepository)arMgr.loadRepository(aggregateURI, monitor);
        }
        catch (ProvisionException provisionException) {
            this.aggregationAr = (IFileArtifactRepository)arMgr.createRepository(aggregateURI, String.valueOf(this.getAggregation().getLabel()) + " artifacts", SIMPLE_ARTIFACTS_TYPE, properties);
            MonitorUtils.complete((IProgressMonitor)monitor);
        }
        return this.aggregationAr;
    }

    public IMetadataRepository getAggregationMetadataRepository() throws CoreException {
        if (this.aggregationMdr != null) {
            return this.aggregationMdr;
        }
        IMetadataRepositoryManager mdrMgr = this.getMdrManager();
        File destination = new File(this.getBuildRoot(), REPO_FOLDER_FINAL);
        File aggregateDestination = new File(destination, REPO_FOLDER_AGGREGATE);
        java.net.URI aggregateURI = Builder.createURI(aggregateDestination);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", Boolean.toString(true));
        properties.put("publishPackFilesAsSiblings", Boolean.toString(true));
        this.aggregationMdr = mdrMgr.createRepository(aggregateURI, this.getAggregation().getLabel(), SIMPLE_METADATA_TYPE, properties);
        return this.aggregationMdr;
    }

    public IArtifactRepositoryManager getArManager() {
        return this.arManager;
    }

    public Set<IArtifactKey> getArtifactKeysToExcludeFromMirroring() throws CoreException {
        if (this.keysToExcludeFromMirroring != null) {
            return this.keysToExcludeFromMirroring;
        }
        this.keysToExcludeFromMirroring = new HashSet<IArtifactKey>();
        for (Contribution contrib : this.getAggregation().getAllContributions(true)) {
            for (MappedRepository repo : contrib.getRepositories(true)) {
                if (repo.isMirrorArtifacts()) continue;
                for (IInstallableUnit iu : ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo).getInstallableUnits()) {
                    this.keysToExcludeFromMirroring.addAll(iu.getArtifacts());
                }
            }
        }
        return this.keysToExcludeFromMirroring;
    }

    public IArtifactRepository getArtifactRepository(MetadataRepositoryReference repo, IProgressMonitor monitor) throws CoreException {
        IArtifactRepository ar;
        if (this.arCache == null) {
            this.arCache = new HashMap<MetadataRepositoryReference, IArtifactRepository>();
        }
        if ((ar = this.arCache.get(repo)) == null) {
            IConfigurationElement config = RepositoryLoaderUtils.getLoaderFor((String)repo.getNature());
            if (config == null) {
                throw ExceptionUtils.fromMessage((String)"No loader for %s", (Object[])new Object[]{repo.getNature()});
            }
            IRepositoryLoader repoLoader = (IRepositoryLoader)config.createExecutableExtension("class");
            ar = repoLoader.getArtifactRepository((IMetadataRepository)ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo), monitor);
            this.arCache.put(repo, ar);
        }
        return ar;
    }

    public String getBuildID() {
        return this.buildID;
    }

    public File getBuildModelLocation() {
        return this.buildModelLocation;
    }

    public File getBuildRoot() {
        return this.buildRoot;
    }

    public Collection<String> getChildrenSubdirectories() {
        ArrayList<String> childrenSubdirectories = new ArrayList<String>(this.validationSetAnnotationsMap.size());
        for (ValidationSet validationSet : this.validationSetAnnotationsMap.keySet()) {
            childrenSubdirectories.add(this.getValidationSetSubdirectory(validationSet));
        }
        return childrenSubdirectories;
    }

    public String getMappedRepositoryVerificationIUName(MappedRepository repository) {
        return "mappedRepo_" + this.getSafeRepositoryName(repository);
    }

    public IMetadataRepositoryManager getMdrManager() {
        return this.mdrManager;
    }

    public IProvisioningAgent getProvisioningAgent() {
        return this.provisioningAgent;
    }

    public String getSafeRepositoryName(MappedRepository repository) {
        String safeName = this.safeRepositoryNameMap.get(repository);
        if (safeName != null) {
            return safeName;
        }
        URI repoURI = URI.createURI((String)repository.getResolvedLocation());
        String scheme = repoURI.scheme();
        String location = repoURI.toString();
        int i = scheme != null ? scheme.length() + 1 : 0;
        while (location.charAt(i) == '/') {
            ++i;
        }
        if (i > 0) {
            location = location.substring(i);
        }
        location = location.replaceAll("[^-0-9a-zA-Z_.~]", "_");
        i = 0;
        safeName = location;
        while (this.safeRepositoryNames.contains(safeName)) {
            if (++i < 0) {
                throw new IllegalArgumentException("Could not generate safe unique name for mapped repository: " + repository.getLocation());
            }
            safeName = String.valueOf(location) + '_' + i;
        }
        this.safeRepositoryNames.add(safeName);
        this.safeRepositoryNameMap.put(repository, safeName);
        return safeName;
    }

    public String getSafeValidationSetName(ValidationSet validationSet) {
        return this.getSafeValidationSetName(validationSet, this.getValidationSetAnnotations(validationSet));
    }

    private String getSafeValidationSetName(ValidationSet validationSet, ValidationSetAnnotations vsas) {
        String safeName = vsas.getSafeName();
        if (safeName != null) {
            return safeName;
        }
        safeName = validationSet.getLabel().replaceAll("[^-0-9a-zA-Z_.~]", "_");
        int retryCount = 0;
        block0: while (true) {
            for (ValidationSetAnnotations other : this.validationSetAnnotationsMap.values()) {
                if (other == vsas || !safeName.equals(other.getSafeName())) continue;
                StringBuilder bld = new StringBuilder(safeName);
                if (retryCount > 0) {
                    bld.setLength(safeName.lastIndexOf(95));
                }
                bld.append('_');
                bld.append(retryCount + 1);
                safeName = bld.toString();
                ++retryCount;
                continue block0;
            }
            break;
        }
        vsas.setSafeName(safeName);
        return safeName;
    }

    public String getShortDescription() {
        return "Aggregates source repositories into a resulting repository using aggregator definition";
    }

    public CompositeMetadataRepository getSourceComposite(ValidationSet validationSet) {
        return this.getValidationSetAnnotations(validationSet).getSourceComposite();
    }

    public java.net.URI getSourceCompositeURI(ValidationSet validationSet) throws CoreException {
        ValidationSetAnnotations vsas = this.getValidationSetAnnotations(validationSet);
        java.net.URI compositeURI = vsas.getSourceCompositeURI();
        if (compositeURI == null) {
            compositeURI = Builder.createURI(new File(new File(this.buildRoot, REPO_FOLDER_INTERIM), this.getSafeValidationSetName(validationSet, vsas)));
            vsas.setSourceCompositeURI(compositeURI);
        }
        return compositeURI;
    }

    public java.net.URI getTargetCompositeURI() throws CoreException {
        if (this.aggregation.getValidationSets().isEmpty()) {
            return null;
        }
        return Builder.createURI(new File(this.buildRoot, REPO_FOLDER_FINAL));
    }

    public IArtifactRepository getTemporaryArtifactRepository(IProgressMonitor monitor) throws CoreException {
        try {
            return this.getArManager().loadRepository(Builder.createURI(this.getTempRepositoryFolder()), monitor);
        }
        catch (ProvisionException provisionException) {
            return null;
        }
    }

    public File getTempRepositoryFolder() {
        return new File(this.buildRoot, REPO_FOLDER_TEMP);
    }

    public Transport getTransport() {
        return (Transport)this.provisioningAgent.getService(Transport.SERVICE_NAME);
    }

    public Set<IInstallableUnit> getUnitsToAggregate(ValidationSet validationSet) {
        ValidationSetAnnotations vsas = this.getValidationSetAnnotations(validationSet);
        Set<IInstallableUnit> units = vsas.getUnitsToAggregate();
        if (units == null) {
            units = new HashSet<IInstallableUnit>();
            vsas.setUnitsToAggregate(units);
        }
        return units;
    }

    public List<IInstallableUnit> getValidationIUs() {
        return this.validationIUs;
    }

    private ValidationSetAnnotations getValidationSetAnnotations(ValidationSet validationSet) {
        ValidationSetAnnotations vsas = this.validationSetAnnotationsMap.get(validationSet);
        if (vsas == null) {
            vsas = new ValidationSetAnnotations();
            this.validationSetAnnotationsMap.put(validationSet, vsas);
        }
        return vsas;
    }

    public String getValidationSetSubdirectory(ValidationSet validationSet) {
        return "/validationSet_" + this.getSafeValidationSetName(validationSet);
    }

    public String getVerificationIUName(ValidationSet validationSet) {
        return "validationSet_" + this.getSafeValidationSetName(validationSet);
    }

    private void initializeArtifactMirroring(IProgressMonitor monitor) throws CoreException {
        this.arCache = null;
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        try {
            subMon.setTaskName("Mirroring artifacts...");
            this.aggregationAr = this.getAggregationArtifactRepository((IProgressMonitor)subMon.newChild(5));
            if (this.getAggregation().isMavenResult()) {
                this.mavenInitializeMirroring(this.aggregationAr, (IProgressMonitor)subMon.newChild(10));
            }
            File destination = new File(this.getBuildRoot(), REPO_FOLDER_FINAL);
            String[] stringArray = new String[]{"p2.index", "compositeContent.jar", "content.jar", "compositeArtifacts.jar", "artifacts.jar"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                File file = new File(destination, fileName);
                if (file.exists() && !file.delete()) {
                    throw ExceptionUtils.fromMessage((String)"Unable to remove %s", (Object[])new Object[]{file.getAbsolutePath()});
                }
                ++n2;
            }
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    private void initMirroring(IProgressMonitor monitor) throws CoreException {
        boolean moveArtifacts;
        File destination = new File(this.getBuildRoot(), REPO_FOLDER_FINAL);
        File aggregateDestination = new File(destination, REPO_FOLDER_AGGREGATE);
        java.net.URI destURI = Builder.createURI(destination);
        java.net.URI aggrURI = Builder.createURI(aggregateDestination);
        IMetadataRepositoryManager mdrMgr = this.getMdrManager();
        mdrMgr.removeRepository(destURI);
        mdrMgr.removeRepository(aggrURI);
        IArtifactRepositoryManager arMgr = this.getArManager();
        arMgr.removeRepository(destURI);
        arMgr.removeRepository(aggrURI);
        if (this.action == ActionType.CLEAN_BUILD) {
            FileUtils.deleteAll((File)destination);
            aggregateDestination.mkdirs();
            this.refreshBuildRoot(monitor);
            return;
        }
        File compArts = new File(destination, "compositeArtifacts.jar");
        if (compArts.exists()) {
            this.getArManager().removeRepository(Builder.createURI(destination));
            moveArtifacts = false;
        } else {
            FileUtils.deleteAll((File)aggregateDestination);
            aggregateDestination.mkdirs();
            moveArtifacts = true;
        }
        String[] stringArray = destination.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!name.equals(REPO_FOLDER_AGGREGATE)) {
                File newLocation;
                File oldLocation = new File(destination, name);
                if (name.equals("compositeArtifacts.xml") || name.equals("compositeArtifacts.jar") || name.equals("compositeContent.xml") || name.equals("compositeContent.jar") || name.equals("content.xml") || name.equals("content.jar") || name.equals("p2.index")) {
                    oldLocation.delete();
                } else if (moveArtifacts && !oldLocation.renameTo(newLocation = new File(aggregateDestination, name))) {
                    throw ExceptionUtils.fromMessage((String)"Unable to move %s to %s", (Object[])new Object[]{oldLocation.getAbsolutePath(), newLocation.getAbsolutePath()});
                }
            }
            ++n2;
        }
        this.refreshBuildRoot(monitor);
    }

    public boolean isMapVerbatim(MappedRepository repo) {
        return !repo.isMapExclusive() && !repo.isMirrorArtifacts() && StringUtils.trimmedOrNull((String)repo.getCategoryPrefix()) == null && (this.exclusions == null || !this.exclusions.contains(repo) || !"p2".equals(repo.getNature()));
    }

    public boolean isMatchedReference(String reference) {
        Matcher m;
        if ((reference = StringUtils.trimmedOrNull((String)reference)) == null) {
            return false;
        }
        if (this.referenceIncludePattern != null && !(m = this.referenceIncludePattern.matcher(reference)).matches()) {
            return false;
        }
        return this.referenceExcludePattern == null || !(m = this.referenceExcludePattern.matcher(reference)).matches();
    }

    public boolean isMirrorReferences() {
        return this.mirrorReferences;
    }

    public boolean isProduction() {
        return this.production;
    }

    public boolean isTopLevelCategory(IInstallableUnit iu) {
        return iu != null && "true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.category")) && !"true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.group"));
    }

    public boolean isVerifyOnly() {
        return this.action == ActionType.VALIDATE;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void loadAllMappedRepositories() throws CoreException {
        block11: {
            LogUtils.info((String)"Loading all repositories", (Object[])new Object[0]);
            repositoriesToLoad = new HashSet<MetadataRepositoryReference>();
            aggregation = this.getAggregation();
            topSet = ((EObject)aggregation).eResource().getResourceSet();
            for (MetadataRepositoryReference repo : aggregation.getAllMetadataRepositoryReferences(true)) {
                repoURI = URI.createGenericURI((String)"b3", (String)(String.valueOf(repo.getNature()) + ":" + repo.getResolvedLocation()), null);
                res = (P2ResourceImpl)topSet.getResource(repoURI, false);
                if (res == null) {
                    res = (P2ResourceImpl)topSet.createResource(repoURI);
                }
                res.startAsynchronousLoad();
                repositoriesToLoad.add(repo);
            }
            try {
                errors = new HashMap<Contribution, ArrayList<String>>();
                for (MetadataRepositoryReference repo : repositoriesToLoad) {
                    mdr = repo.getMetadataRepository();
                    if (mdr != null && !((EObject)mdr).eIsProxy()) continue;
                    contrib = null;
                    if (repo instanceof MappedRepository) {
                        contrib = (Contribution)((EObject)repo).eContainer();
                    }
                    msg = String.format("Unable to load repository %s:%s", new Object[]{repo.getNature(), repo.getLocation()});
                    LogUtils.error((String)msg, (Object[])new Object[0]);
                    if (this.fromIDE) {
                        throw ExceptionUtils.fromMessage((String)msg, (Object[])new Object[0]);
                    }
                    contribErrors = (ArrayList<String>)errors.get(contrib);
                    if (contribErrors == null) {
                        contribErrors = new ArrayList<String>();
                        errors.put(contrib, contribErrors);
                    }
                    contribErrors.add(msg);
                }
                if (errors.size() > 0) {
                    for (Map.Entry entry : errors.entrySet()) {
                        this.sendEmail((Contribution)entry.getKey(), (List)entry.getValue());
                    }
                    throw ExceptionUtils.fromMessage((String)"Not all repositories could be loaded (see log for details)", (Object[])new Object[0]);
                }
                break block11;
            }
            catch (CoreException e) {
                ** for (repo : repositoriesToLoad)
            }
lbl-1000:
            // 1 sources

            {
                repo.cancelRepositoryLoad();
                continue;
            }
lbl44:
            // 1 sources

            throw e;
        }
    }

    private void loadModel() throws CoreException {
        try {
            Diagnostic diag;
            Contact buildMasterBackup;
            boolean found;
            String contributionLabel;
            int n;
            int n2;
            String[] stringArray;
            this.aggregation = this.loadModelFromFile();
            this.verifyContributions();
            if (this.packedStrategy != null) {
                this.aggregation.setPackedStrategy(this.packedStrategy);
            }
            EList validationSets = this.aggregation.getValidationSets(true);
            if (this.trustedContributions != null) {
                stringArray = this.trustedContributions.split(",");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    contributionLabel = stringArray[n];
                    contributionLabel = StringUtils.trimmedOrNull((String)contributionLabel);
                    found = false;
                    if (contributionLabel != null) {
                        for (ValidationSet vs : validationSets) {
                            for (Contribution contribution : vs.getDeclaredContributions()) {
                                if (!contributionLabel.equals(contribution.getLabel())) continue;
                                for (MappedRepository repository : contribution.getRepositories(true)) {
                                    repository.setMirrorArtifacts(false);
                                }
                                found = true;
                            }
                        }
                    }
                    if (!found) {
                        throw ExceptionUtils.fromMessage((String)("Unable to trust contribution " + contributionLabel + ": contribution does not exist or is not enabled"), (Object[])new Object[0]);
                    }
                    ++n;
                }
            }
            if (this.validationContributions != null) {
                stringArray = this.validationContributions.split(",");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    Iterator iterator;
                    contributionLabel = stringArray[n];
                    contributionLabel = StringUtils.trimmedOrNull((String)contributionLabel);
                    found = false;
                    HashSet<Feature> removedMappings = new HashSet<Feature>();
                    if (contributionLabel != null) {
                        for (ValidationSet vs : validationSets) {
                            iterator = vs.getContributions().iterator();
                            while (iterator.hasNext()) {
                                Contribution contribution = (Contribution)iterator.next();
                                if (!contribution.isEnabled() || !contributionLabel.equals(contribution.getLabel())) continue;
                                for (MappedRepository repository : contribution.getRepositories(true)) {
                                    MetadataRepositoryReferenceImpl validationRepo = (MetadataRepositoryReferenceImpl)AggregatorFactory.eINSTANCE.createMetadataRepositoryReference();
                                    validationRepo.setNature(repository.getNature());
                                    validationRepo.setLocation(repository.getLocation());
                                    vs.getValidationRepositories().add((Object)validationRepo);
                                    removedMappings.addAll((Collection<Feature>)repository.getFeatures());
                                }
                                iterator.remove();
                                found = true;
                            }
                        }
                    }
                    if (!found) {
                        throw ExceptionUtils.fromMessage((String)("Unable to use contribution " + contributionLabel + " for validation only: contribution does not exist"), (Object[])new Object[0]);
                    }
                    for (CustomCategory customCategory : this.aggregation.getCustomCategories()) {
                        iterator = customCategory.getFeatures().iterator();
                        while (iterator.hasNext()) {
                            Feature feature = (Feature)iterator.next();
                            if (!removedMappings.add(feature)) continue;
                            iterator.remove();
                        }
                    }
                    ++n;
                }
            }
            HashSet allFeatures = new HashSet();
            for (ValidationSet vs : validationSets) {
                for (Contribution contrib : vs.getContributions()) {
                    for (MappedRepository repo : contrib.getRepositories()) {
                        allFeatures.addAll(repo.getFeatures());
                    }
                }
            }
            for (CustomCategory customCategory : this.aggregation.getCustomCategories()) {
                Iterator iterator = customCategory.getFeatures().iterator();
                while (iterator.hasNext()) {
                    Feature feature = (Feature)iterator.next();
                    if (allFeatures.contains(feature)) continue;
                    iterator.remove();
                }
            }
            if (this.mavenResult != null) {
                this.aggregation.setMavenResult(this.mavenResult.booleanValue());
            }
            if (this.trustedContributions != null && this.aggregation.isMavenResult()) {
                throw ExceptionUtils.fromMessage((String)"Options --trustedContributions cannot be used if maven result is required", (Object[])new Object[0]);
            }
            this.sendmail = this.aggregation.isSendmail();
            this.buildLabel = this.aggregation.getLabel();
            Contact buildMaster = this.aggregation.getBuildmaster();
            if (buildMaster != null) {
                this.buildMasterName = buildMaster.getName();
                this.buildMasterEmail = buildMaster.getEmail();
            }
            if ((buildMasterBackup = this.aggregation.getBuildmasterBackup()) != null) {
                this.buildMasterBackupName = buildMasterBackup.getName();
                this.buildMasterBackupEmail = buildMasterBackup.getEmail();
            }
            if ((diag = Diagnostician.INSTANCE.validate((EObject)this.aggregation)).getSeverity() == 4) {
                StringBuilder bld = new StringBuilder("Aggregation model is inconsistent: ").append(diag.getMessage());
                for (Diagnostic childDiag : diag.getChildren()) {
                    bld.append(String.format("%n  %s", childDiag.getMessage()));
                }
                throw ExceptionUtils.fromMessage((String)bld.toString(), (Object[])new Object[0]);
            }
            if (this.buildRoot == null) {
                this.setBuildRoot(new File(PROPERTY_REPLACER.replaceProperties(this.aggregation.getBuildRoot())));
                if (!this.buildRoot.isAbsolute()) {
                    this.setBuildRoot(new File(this.buildModelLocation.getParent(), this.buildRoot.getPath()).getAbsoluteFile());
                }
            } else if (!this.buildRoot.isAbsolute()) {
                this.setBuildRoot(this.buildRoot.getAbsoluteFile());
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.wrap((Throwable)e);
        }
    }

    private boolean mavenAddMetadata() throws CoreException {
        IMaven2Indexer indexer;
        boolean everythingOk = true;
        if (this.mavenHelper == null) {
            return everythingOk;
        }
        LogUtils.info((String)"Adding maven metadata", (Object[])new Object[0]);
        HashMap errors = new HashMap();
        File destination = new File(this.getBuildRoot(), REPO_FOLDER_FINAL);
        File aggregateDestination = new File(destination, REPO_FOLDER_AGGREGATE);
        MavenManager.saveMetadata((URI)URI.createFileURI((String)aggregateDestination.getAbsolutePath()), (InstallableUnitMapping)this.mavenHelper.getTop(), errors);
        if (errors.size() > 0) {
            everythingOk = false;
            for (Map.Entry entry : errors.entrySet()) {
                this.sendEmail((Contribution)entry.getKey(), (List)entry.getValue());
            }
        }
        if ((indexer = IndexerUtils.getIndexer((String)"nexus")) != null) {
            LogUtils.info((String)"Adding maven index", (Object[])new Object[0]);
            indexer.updateLocalIndex(new File(aggregateDestination.getAbsolutePath()).toURI(), false);
        }
        LogUtils.info((String)"Done adding maven metadata", (Object[])new Object[0]);
        return everythingOk;
    }

    private void mavenApplyRules(MappedRepository repo, IInstallableUnit iu, IArtifactRepository ar, List<String[]> mappingRules, List<ArtifactDescriptor> referencedArtifacts) {
        String versionString = iu.getVersion().getOriginal();
        if (versionString == null) {
            versionString = iu.getVersion().toString();
        }
        String originalPath = iu.getProperty("original.path");
        String originalId = iu.getProperty("original.id");
        if (originalId == null) {
            originalId = iu.getId();
        }
        for (IArtifactKey key : iu.getArtifacts()) {
            if (repo.isMirrorArtifacts()) {
                String location = "${repoUrl}/non-p2/" + repo.getNature() + '/' + key.getClassifier() + '/' + (originalPath != null ? String.valueOf(originalPath) + '/' : "") + originalId + '_' + versionString + '.' + key.getClassifier();
                mappingRules.add(new String[]{"(& (classifier=" + IUUtils.encodeFilterValue((String)key.getClassifier()) + ") (id=" + IUUtils.encodeFilterValue((String)key.getId()) + ") (version=" + IUUtils.encodeFilterValue((String)iu.getVersion().toString()) + "))", location});
                continue;
            }
            IArtifactDescriptor[] iArtifactDescriptorArray = ar.getArtifactDescriptors(key);
            int n = iArtifactDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactDescriptor desc = iArtifactDescriptorArray[n2];
                String ref = ((SimpleArtifactDescriptor)desc).getRepositoryProperty("artifact.reference");
                SimpleArtifactDescriptor ad = new SimpleArtifactDescriptor(desc);
                ad.setRepositoryProperty("artifact.reference", ref);
                referencedArtifacts.add((ArtifactDescriptor)ad);
                ++n2;
            }
        }
    }

    private void mavenInitializeMirroring(IFileArtifactRepository aggregateAr, IProgressMonitor monitor) throws CoreException {
        EList allContribs = this.getAggregation().getAllContributions(true);
        SubMonitor childMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(allContribs.size() * 10));
        HashSet<IInstallableUnit> allUnitsToAggregate = new HashSet<IInstallableUnit>();
        for (ValidationSetAnnotations vsas : this.validationSetAnnotationsMap.values()) {
            if (vsas.getUnitsToAggregate() == null) continue;
            allUnitsToAggregate.addAll(vsas.getUnitsToAggregate());
        }
        ArrayList<InstallableUnitMapping> iusToMaven = new ArrayList<InstallableUnitMapping>();
        for (Contribution contrib : allContribs) {
            SubMonitor contribMonitor = childMonitor.newChild(10);
            EList repos = contrib.getRepositories(true);
            Iterator<String> errors = new ArrayList<String>();
            MonitorUtils.begin((IProgressMonitor)contribMonitor, (int)(repos.size() * 100));
            for (MappedRepository repo : repos) {
                if (!repo.isMirrorArtifacts()) {
                    String msg = String.format("Repository %s must be set to mirror artifacts if maven result is required", repo.getLocation());
                    LogUtils.error((String)msg, (Object[])new Object[0]);
                    errors.add(msg);
                    MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)100);
                    continue;
                }
                MetadataRepository childMdr = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo);
                ArrayList<IInstallableUnit> iusToMirror = null;
                for (IInstallableUnit iu : childMdr.getInstallableUnits()) {
                    if (!allUnitsToAggregate.contains(iu)) continue;
                    if (iusToMirror == null) {
                        iusToMirror = new ArrayList<IInstallableUnit>();
                    }
                    iusToMirror.add(iu);
                }
                EList allMavenMappings = contrib.getAllMavenMappings();
                if (iusToMirror != null) {
                    for (IInstallableUnit iu : iusToMirror) {
                        iusToMaven.add(new InstallableUnitMapping(contrib, iu, (List)allMavenMappings));
                    }
                }
                MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)100);
            }
            if (errors.size() > 0) {
                this.sendEmail(contrib, (List<String>)((Object)errors));
                throw ExceptionUtils.fromMessage((String)"All repositories must be set to mirror artifacts if maven result is required", (Object[])new Object[0]);
            }
            MonitorUtils.done((IProgressMonitor)contribMonitor);
        }
        this.mavenHelper = MavenManager.createMavenStructure(iusToMaven);
        if (!(aggregateAr instanceof SimpleArtifactRepository)) {
            throw ExceptionUtils.fromMessage((String)"Unexpected repository implementation: Expected %s, found %s", (Object[])new Object[]{SimpleArtifactRepository.class.getName(), aggregateAr.getClass().getName()});
        }
        SimpleArtifactRepository simpleAr = (SimpleArtifactRepository)aggregateAr;
        simpleAr.setRules(this.mavenHelper.getMappingRules());
        simpleAr.initializeAfterLoad(aggregateAr.getLocation());
        if (this.packedStrategy != PackedStrategy.SKIP && this.packedStrategy != PackedStrategy.UNPACK && this.packedStrategy != PackedStrategy.UNPACK_AS_SIBLING) {
            this.packedStrategy = PackedStrategy.UNPACK_AS_SIBLING;
            LogUtils.info((String)"Maven result is required, changing packed strategy from %s to %s", (Object[])new Object[]{this.aggregation.getPackedStrategy().getName(), this.packedStrategy.getName()});
        }
        ArrayList<String[]> mappingRules = new ArrayList<String[]>();
        ArrayList<ArtifactDescriptor> referencedArtifacts = new ArrayList<ArtifactDescriptor>();
        HashSet<IInstallableUnit> allUnitsToValidate = new HashSet<IInstallableUnit>();
        for (ValidationSetAnnotations vsas : this.validationSetAnnotationsMap.values()) {
            Set<IInstallableUnit> unitsToValidate = vsas.getUnitsToAggregate();
            if (unitsToValidate == null) continue;
            allUnitsToValidate.addAll(unitsToValidate);
        }
        for (Contribution contrib : allContribs) {
            SubMonitor contribMonitor = childMonitor.newChild(10);
            EList repos = contrib.getRepositories(true);
            MonitorUtils.begin((IProgressMonitor)contribMonitor, (int)(repos.size() * 100));
            for (MappedRepository repo : repos) {
                int ticksRemaining = 100;
                if ("p2".equals(repo.getNature())) {
                    MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)100);
                    continue;
                }
                MetadataRepository childMdr = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo);
                ArrayList<IInstallableUnit> iusToRefer = null;
                for (IInstallableUnit iu : childMdr.getInstallableUnits()) {
                    if (allUnitsToValidate.contains(iu)) continue;
                    if (iusToRefer == null) {
                        iusToRefer = new ArrayList<IInstallableUnit>();
                    }
                    iusToRefer.add(iu);
                }
                if (iusToRefer == null) continue;
                int ticks = 50;
                IArtifactRepository ar = this.getArtifactRepository((MetadataRepositoryReference)repo, (IProgressMonitor)contribMonitor.newChild(ticks));
                ticksRemaining -= ticks;
                for (IInstallableUnit iu : iusToRefer) {
                    this.mavenApplyRules(repo, iu, ar, mappingRules, referencedArtifacts);
                }
                MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)ticksRemaining);
            }
            MonitorUtils.done((IProgressMonitor)contribMonitor);
        }
        if (mappingRules.size() > 0 || referencedArtifacts.size() > 0) {
            if (!(aggregateAr instanceof SimpleArtifactRepository)) {
                throw ExceptionUtils.fromMessage((String)"Unexpected repository implementation: Expected %s, found %s", (Object[])new Object[]{SimpleArtifactRepository.class.getName(), aggregateAr.getClass().getName()});
            }
            SimpleArtifactRepository simpleAr2 = (SimpleArtifactRepository)aggregateAr;
            ArrayList ruleList = new ArrayList(Arrays.asList(simpleAr2.getRules()));
            ruleList.addAll(mappingRules);
            simpleAr2.setRules((String[][])ruleList.toArray((T[])new String[ruleList.size()][]));
            simpleAr2.initializeAfterLoad(simpleAr2.getLocation());
            simpleAr2.addDescriptors(referencedArtifacts.toArray(new IArtifactDescriptor[referencedArtifacts.size()]), (IProgressMonitor)childMonitor.newChild(2));
            simpleAr2.save();
        }
    }

    private List<EmailAddress> mockCCRecipients() throws UnsupportedEncodingException {
        if (this.mockEmailCC != null) {
            return Collections.singletonList(new EmailAddress(this.mockEmailCC, null));
        }
        return Collections.emptyList();
    }

    private List<EmailAddress> mockRecipients() throws UnsupportedEncodingException {
        if (this.mockEmailTo != null) {
            return Collections.singletonList(new EmailAddress(this.mockEmailTo, null));
        }
        return Collections.emptyList();
    }

    private void refreshBuildRoot(IProgressMonitor monitor) {
        if (!this.fromIDE || this.buildRoot == null) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return;
        }
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IContainer[] containers = wsRoot.findContainersForLocationURI(this.buildRoot.toURI());
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)(containers.length * 100));
        IContainer[] iContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer rootContainer = iContainerArray[n2];
            try {
                rootContainer.refreshLocal(2, (IProgressMonitor)subMon.newChild(100));
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        MonitorUtils.done((IProgressMonitor)monitor);
    }

    public void removeUnitsToAggregate(ValidationSet validationSet) {
        ValidationSetAnnotations vsas = this.getValidationSetAnnotations(validationSet);
        if (vsas != null) {
            vsas.setUnitsToAggregate(null);
        }
    }

    public int run(boolean fromIDE, IProgressMonitor monitor) throws Exception {
        int ticks;
        this.fromIDE = fromIDE;
        switch (this.action) {
            case CLEAN: {
                ticks = 50;
                break;
            }
            case VALIDATE: {
                ticks = 200;
                break;
            }
            case BUILD: {
                ticks = 2150;
                break;
            }
            default: {
                ticks = 2200;
            }
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)ticks);
        try {
            if (this.buildModelLocation == null) {
                throw ExceptionUtils.fromMessage((String)"No buildmodel has been set", (Object[])new Object[0]);
            }
            Date now = new Date();
            if (this.buildID == null) {
                this.buildID = "build-" + DATE_FORMAT.format(now) + TIME_FORMAT.format(now);
            }
            if (this.smtpHost == null) {
                this.smtpHost = "localhost";
            }
            if (this.smtpPort <= 0) {
                this.smtpPort = 25;
            }
            this.loadModel();
            switch (this.action) {
                case CLEAN: 
                case CLEAN_BUILD: {
                    this.cleanAll();
                    break;
                }
            }
            if (this.action == ActionType.CLEAN) {
                return 0;
            }
            if (this.provisioningAgent == null) {
                if (this.agentLocation == null) {
                    this.agentLocation = new File(this.buildRoot, "p2");
                }
                this.provisioningAgent = P2Utils.createDedicatedProvisioningAgent((java.net.URI)this.agentLocation.toURI());
            }
            this.arManager = (IArtifactRepositoryManager)P2Utils.getRepositoryManager((IProvisioningAgent)this.provisioningAgent, IArtifactRepositoryManager.class);
            this.mdrManager = (IMetadataRepositoryManager)P2Utils.getRepositoryManager((IProvisioningAgent)this.provisioningAgent, IMetadataRepositoryManager.class);
            if (this.action != ActionType.CLEAN_BUILD) {
                this.cleanMetadata(this.action == ActionType.VALIDATE);
            }
            this.cleanMemoryCaches();
            ((ResourceSetWithAgent)this.resourceSet).setProvisioningAgent(this.provisioningAgent);
            this.buildRoot.mkdirs();
            if (!this.buildRoot.exists()) {
                throw ExceptionUtils.fromMessage((String)"Failed to create folder %s", (Object[])new Object[]{this.buildRoot});
            }
            IProfileRegistry profileRegistry = P2Utils.getProfileRegistry((IProvisioningAgent)this.provisioningAgent);
            try {
                ArrayList<String> knownIDs = new ArrayList<String>();
                IProfile[] iProfileArray = profileRegistry.getProfiles();
                int n = iProfileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProfile profile = iProfileArray[n2];
                    String id = profile.getProfileId();
                    if (id.startsWith(PROFILE_ID)) {
                        knownIDs.add(id);
                    }
                    ++n2;
                }
                for (String id : knownIDs) {
                    profileRegistry.removeProfile(id);
                }
                String instArea = this.buildRoot.toString();
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("org.eclipse.equinox.p2.name", this.aggregation.getLabel());
                props.put("org.eclipse.equinox.p2.description", String.format("Default profile during %s build", this.aggregation.getLabel()));
                props.put("org.eclipse.equinox.p2.cache", instArea);
                props.put("org.eclipse.equinox.p2.installFolder", instArea);
                profileRegistry.addProfile(PROFILE_ID, props);
            }
            finally {
                P2Utils.ungetProfileRegistry((IProvisioningAgent)this.provisioningAgent, (IProfileRegistry)profileRegistry);
            }
            this.loadAllMappedRepositories();
            EList validationSets = this.getAggregation().getValidationSets(true);
            for (ValidationSet validationSet : validationSets) {
                if (validationSet.isAbstract()) continue;
                this.runCompositeGenerator(validationSet, (IProgressMonitor)subMon.newChild(5));
                this.runVerificationIUGenerator(validationSet, (IProgressMonitor)subMon.newChild(5));
                this.runRepositoryVerifier(validationSet, (IProgressMonitor)subMon.newChild(100));
            }
            if (this.action != ActionType.VALIDATE) {
                this.initMirroring((IProgressMonitor)subMon.newChild(5));
                for (ValidationSet validationSet : validationSets) {
                    if (validationSet.isAbstract()) continue;
                    this.runMetadataMirroring(validationSet, (IProgressMonitor)subMon.newChild(100));
                }
                this.runCategoriesRepoGenerator((IProgressMonitor)subMon.newChild(5));
                this.initializeArtifactMirroring((IProgressMonitor)subMon.newChild(10));
                for (ValidationSet validationSet : validationSets) {
                    if (validationSet.isAbstract()) continue;
                    this.runMirroring(validationSet, (IProgressMonitor)subMon.newChild(2000));
                }
                this.finishMirroring(monitor);
            }
            return 0;
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e, (String)"Build failed! Exception was %s", (Object[])new Object[]{Builder.getExceptionMessages(e)});
            throw e;
        }
        finally {
            if (this.provisioningAgent != null) {
                if (this.arManager != null) {
                    P2Utils.ungetRepositoryManager((IProvisioningAgent)this.provisioningAgent, (IRepositoryManager)this.arManager);
                }
                if (this.mdrManager != null) {
                    P2Utils.ungetRepositoryManager((IProvisioningAgent)this.provisioningAgent, (IRepositoryManager)this.mdrManager);
                }
                if (!fromIDE) {
                    P2Utils.stopProvisioningAgent((IProvisioningAgent)this.provisioningAgent);
                    this.provisioningAgent = null;
                }
            }
            this.refreshBuildRoot((IProgressMonitor)subMon.newChild(100));
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        if (this.unparsed.size() > 0) {
            throw new Exception("Too many arguments");
        }
        return this.run(false, monitor);
    }

    private void runCategoriesRepoGenerator(IProgressMonitor monitor) throws CoreException {
        CategoriesGenerator generator = new CategoriesGenerator(this);
        generator.run(monitor);
    }

    private void runCompositeGenerator(ValidationSet validationSet, IProgressMonitor monitor) throws CoreException {
        SourceCompositeGenerator generator = new SourceCompositeGenerator(this, validationSet);
        generator.run(monitor);
    }

    private void runMetadataMirroring(ValidationSet validationSet, IProgressMonitor monitor) throws CoreException {
        MetadataMirrorGenerator generator = new MetadataMirrorGenerator(this, validationSet);
        generator.run(monitor);
    }

    private void runMirroring(ValidationSet validationSet, IProgressMonitor monitor) throws CoreException {
        MirrorGenerator generator = new MirrorGenerator(this, validationSet);
        generator.run(monitor);
    }

    private void runRepositoryVerifier(ValidationSet validationSet, IProgressMonitor monitor) throws CoreException {
        ValidationSetVerifier ipt = new ValidationSetVerifier(this, validationSet);
        ipt.run(monitor);
    }

    private void runVerificationIUGenerator(ValidationSet validationSet, IProgressMonitor monitor) throws CoreException {
        VerificationIUGenerator generator = new VerificationIUGenerator(this, validationSet);
        generator.run(monitor);
    }

    public void sendEmail(Contribution contrib, List<String> errors) {
        boolean useMock;
        boolean bl = useMock = this.mockEmailTo != null;
        if (!this.production && !useMock || !this.sendmail) {
            return;
        }
        try {
            ArrayList<EmailAddress> recipients;
            EmailAddress buildMaster = new EmailAddress(this.buildMasterEmail, this.buildMasterName);
            EmailAddress buildMasterBackup = null;
            if (this.buildMasterBackupEmail != null) {
                buildMasterBackup = new EmailAddress(this.buildMasterBackupEmail, this.buildMasterBackupName);
            }
            EmailAddress emailFromAddr = this.emailFrom != null ? new EmailAddress(this.emailFrom, this.emailFromName) : buildMaster;
            ArrayList<EmailAddress> toList = new ArrayList<EmailAddress>();
            ArrayList<EmailAddress> ccList = new ArrayList<EmailAddress>();
            ccList.add(buildMaster);
            if (buildMasterBackup != null) {
                ccList.add(buildMasterBackup);
            }
            if (contrib == null) {
                toList.add(buildMaster);
                toList.add(buildMasterBackup);
            } else {
                for (Contact contact : contrib.getContacts()) {
                    toList.add(new EmailAddress(contact.getEmail(), contact.getName()));
                }
            }
            StringBuilder msgBld = new StringBuilder();
            msgBld.append("The following error");
            if (errors.size() > 1) {
                msgBld.append('s');
            }
            msgBld.append(" occured when building ");
            msgBld.append(this.buildLabel);
            msgBld.append(":\n\n");
            for (String error : errors) {
                msgBld.append(error);
                msgBld.append("\n\n");
            }
            if (this.logURL != null) {
                msgBld.append("Check the log file for more information: ");
                msgBld.append(this.logURL);
                msgBld.append('\n');
            }
            if (useMock) {
                msgBld.append("\nThis is a mock mail. Real recipients would have been:\n");
                for (EmailAddress to : toList) {
                    msgBld.append("  ");
                    msgBld.append(to);
                    msgBld.append('\n');
                }
                msgBld.append("\nThis is a mock mail. CC recipients would have been:\n");
                for (EmailAddress cc : ccList) {
                    msgBld.append("  ");
                    msgBld.append(cc);
                    msgBld.append('\n');
                }
            }
            String msgContent = msgBld.toString();
            if (this.subjectPrefix == null) {
                this.subjectPrefix = this.buildLabel;
            }
            String subject = String.format("[%s] Failed for build %s", this.subjectPrefix, this.buildID);
            msgBld.setLength(0);
            msgBld.append("Sending email to: ");
            for (EmailAddress to : toList) {
                msgBld.append(to);
                msgBld.append(',');
            }
            msgBld.append(buildMaster);
            if (useMock) {
                msgBld.append(" *** Using mock: ");
                if (this.mockEmailTo != null) {
                    msgBld.append(this.mockEmailTo);
                    if (this.mockEmailCC != null) {
                        msgBld.append(',');
                        msgBld.append(this.mockEmailTo);
                    }
                } else {
                    msgBld.append(this.mockEmailCC);
                }
                msgBld.append(" ***");
            }
            LogUtils.info((String)msgBld.toString(), (Object[])new Object[0]);
            LogUtils.info((String)"From: %s", (Object[])new Object[]{emailFromAddr});
            LogUtils.info((String)"Subject: %s", (Object[])new Object[]{subject});
            LogUtils.info((String)"Message content: %s", (Object[])new Object[]{msgContent});
            List<EmailAddress> ccRecipients = null;
            if (useMock) {
                recipients = this.mockRecipients();
                ccRecipients = this.mockCCRecipients();
            } else {
                recipients = toList;
                if (contrib != null) {
                    ccRecipients = ccList;
                }
            }
            Builder.send(this.smtpHost, this.smtpPort, emailFromAddr, recipients, ccRecipients, subject, msgContent);
        }
        catch (IOException e) {
            LogUtils.error((Throwable)e, (String)"Failed to send email: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    public void setAction(ActionType action) {
        this.action = action;
    }

    public void setBuildID(String buildId) {
        this.buildID = buildId;
    }

    public void setBuildModelLocation(File buildModelLocation) {
        this.buildModelLocation = buildModelLocation;
    }

    public void setBuildRoot(File buildRoot) {
        this.buildRoot = buildRoot;
    }

    public void setEmailFrom(String emailFrom) {
        this.emailFrom = emailFrom;
    }

    public void setEmailFromName(String emailFromName) {
        this.emailFromName = emailFromName;
    }

    public void setLogLevel(int level) {
        throw new UnsupportedOperationException("Log levels are not supported");
    }

    public void setLogURL(String logURL) {
        this.logURL = logURL;
    }

    public void setMirrorReferences(boolean mirrorReferences) {
        this.mirrorReferences = mirrorReferences;
    }

    public void setMockEmailCC(String mockEmailCc) {
        this.mockEmailCC = mockEmailCc;
    }

    public void setMockEmailTo(String mockEmailTo) {
        this.mockEmailTo = mockEmailTo;
    }

    public void setProduction(boolean production) {
        this.production = production;
    }

    public void setProvisioningAgent(IProvisioningAgent provisioningAgent) {
        this.provisioningAgent = provisioningAgent;
    }

    public void setReferenceExcludePattern(String pattern) {
        this.referenceExcludePattern = (pattern = StringUtils.trimmedOrNull((String)pattern)) == null ? null : Pattern.compile(pattern);
    }

    public void setReferenceIncludePattern(String pattern) {
        this.referenceIncludePattern = (pattern = StringUtils.trimmedOrNull((String)pattern)) == null ? null : Pattern.compile(pattern);
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public void setSourceComposite(ValidationSet validationSet, CompositeMetadataRepository sourceComposite) {
        this.getValidationSetAnnotations(validationSet).setSourceComposite(sourceComposite);
    }

    public void setSubjectPrefix(String subjectPrefix) {
        this.subjectPrefix = subjectPrefix;
    }

    public void setValidationIUs(List<IInstallableUnit> validationIUs) {
        this.validationIUs = validationIUs;
    }

    private void verifyContributions() throws CoreException {
        ArrayList<String> errors = new ArrayList<String>();
        for (ValidationSet vs : this.aggregation.getValidationSets()) {
            for (Contribution contribution : vs.getContributions()) {
                Resource res = ((EObject)contribution).eResource();
                for (Resource.Diagnostic diag : res.getErrors()) {
                    String msg = res.getURI() + ": " + diag.toString();
                    LogUtils.error((String)msg, (Object[])new Object[0]);
                    errors.add(msg);
                }
            }
        }
        if (errors.size() > 0) {
            this.sendEmail(null, errors);
            throw ExceptionUtils.fromMessage((String)"Not all contributions could be parsed", (Object[])new Object[0]);
        }
    }

    public static enum ActionType {
        CLEAN,
        VALIDATE,
        BUILD,
        CLEAN_BUILD;

    }

    private static class EmailAddress {
        private final String address;
        private final String personal;

        EmailAddress(String address, String personal) {
            this.address = address;
            this.personal = personal;
        }

        public String toString() {
            if (this.personal == null) {
                return this.address;
            }
            return String.valueOf(this.personal) + " <" + this.address + ">";
        }
    }

    public static class PatternOptionHandler
    extends OptionHandler<Pattern> {
        public PatternOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Pattern> setter) {
            super(parser, option, setter);
        }

        public String getDefaultMetaVariable() {
            return "<regexp>";
        }

        public int parseArguments(Parameters params) throws CmdLineException {
            String token = params.getParameter(0);
            try {
                Pattern value = Pattern.compile(token);
                this.setter.addValue((Object)value);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new CmdLineException(this.owner, "");
            }
            return 1;
        }
    }

    class ValidationSetAnnotations {
        private String safeName;
        private java.net.URI sourceCompositeURI;
        private CompositeMetadataRepository sourceComposite;
        private Set<IInstallableUnit> unitsToAggregate;

        ValidationSetAnnotations() {
        }

        public String getSafeName() {
            return this.safeName;
        }

        public CompositeMetadataRepository getSourceComposite() {
            return this.sourceComposite;
        }

        public java.net.URI getSourceCompositeURI() {
            return this.sourceCompositeURI;
        }

        public Set<IInstallableUnit> getUnitsToAggregate() {
            return this.unitsToAggregate;
        }

        public void setSafeName(String safeName) {
            this.safeName = safeName;
        }

        public void setSourceComposite(CompositeMetadataRepository sourceComposite) {
            this.sourceComposite = sourceComposite;
        }

        public void setSourceCompositeURI(java.net.URI sourceCompositeURI) {
            this.sourceCompositeURI = sourceCompositeURI;
        }

        public void setUnitsToAggregate(Set<IInstallableUnit> unitsToAggregate) {
            this.unitsToAggregate = unitsToAggregate;
        }
    }
}

