/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.osgi.filter.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.b3.osgi.filter.Filter;
import org.eclipse.b3.osgi.filter.impl.AndOrFilterImpl;
import org.eclipse.b3.osgi.filter.impl.FilterImpl;
import org.eclipse.b3.osgi.filter.impl.Messages;
import org.eclipse.b3.osgi.filter.impl.NotFilterImpl;
import org.eclipse.b3.osgi.filter.impl.PresentFilterImpl;
import org.eclipse.b3.osgi.filter.impl.StringFilterImpl;
import org.eclipse.b3.osgi.filter.impl.SubstringFilterImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.InvalidSyntaxException;

public class Parser {
    private final String filterString;
    private final StringBuilder sb = new StringBuilder();
    private int pos;

    public static Filter parse(String filterString) throws InvalidSyntaxException {
        return new Parser(filterString).internalParse();
    }

    static FilterImpl normalize(List<FilterImpl> operands, int op) {
        int top = operands.size();
        if (top == 1) {
            return operands.get(0);
        }
        int idx = 0;
        while (idx < top) {
            FilterImpl f = operands.get(idx);
            if (f.getOp() == op) {
                FilterImpl[] sfs = f.getFilterImpls();
                operands.remove(idx);
                --top;
                int ndx = 0;
                while (ndx < sfs.length) {
                    FilterImpl nf = sfs[ndx];
                    if (!operands.contains(nf)) {
                        operands.add(nf);
                    }
                    ++ndx;
                }
            }
            ++idx;
        }
        if (top == 1) {
            return operands.get(0);
        }
        Collections.sort(operands);
        ArrayList<Compacter> splits = new ArrayList<Compacter>();
        int reverseOp = op == 7 ? 8 : 7;
        int idx2 = 0;
        while (idx2 < top) {
            Parser.merge(splits, operands.get(idx2), reverseOp);
            ++idx2;
        }
        operands.clear();
        top = splits.size();
        idx2 = 0;
        while (idx2 < top) {
            FilterImpl filter = ((Compacter)splits.get(idx2)).getResultingFilter();
            if (!operands.contains(filter)) {
                operands.add(filter);
            }
            ++idx2;
        }
        top = operands.size();
        if (top == 1) {
            return operands.get(0);
        }
        Collections.sort(operands);
        return new AndOrFilterImpl(op, operands.toArray(new FilterImpl[top]));
    }

    private static void merge(List<Compacter> splits, FilterImpl filterImpl, int op) {
        int top = splits.size();
        int idx = 0;
        while (idx < top) {
            Compacter split = splits.get(idx);
            if (split.merge(filterImpl)) {
                return;
            }
            ++idx;
        }
        splits.add(new Compacter(filterImpl, op));
    }

    private Parser(String filter) {
        this.filterString = filter;
        this.pos = 0;
    }

    private Filter internalParse() throws InvalidSyntaxException {
        try {
            FilterImpl filter = this.parse_filter();
            if (this.pos != this.filterString.length()) {
                throw this.syntaxException(Messages.FILTER_TRAILING_CHARACTERS);
            }
            return filter;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new InvalidSyntaxException(NLS.bind((String)Messages.FILTER_PREMATURE_END, (Object)this.filterString), this.filterString);
        }
    }

    private FilterImpl parse_and() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        char c = this.filterString.charAt(this.pos);
        if (c != '(') {
            throw this.syntaxException(Messages.FILTER_MISSING_LEFTPAREN);
        }
        ArrayList<FilterImpl> operands = new ArrayList<FilterImpl>();
        while (c == '(') {
            FilterImpl child = this.parse_filter();
            if (!operands.contains(child)) {
                operands.add(child);
            }
            c = this.filterString.charAt(this.pos);
        }
        return Parser.normalize(operands, 7);
    }

    private String parse_attr() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        int begin = this.pos;
        int end = this.pos;
        char c = this.filterString.charAt(begin);
        while (c != '~' && c != '<' && c != '>' && c != '=' && c != '(' && c != ')') {
            ++this.pos;
            if (!Character.isWhitespace(c)) {
                end = this.pos;
            }
            c = this.filterString.charAt(this.pos);
        }
        if (end == begin) {
            throw this.syntaxException(Messages.FILTER_MISSING_ATTR);
        }
        return this.filterString.substring(begin, end);
    }

    private FilterImpl parse_filter() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        if (this.filterString.charAt(this.pos) != '(') {
            throw this.syntaxException(Messages.FILTER_MISSING_LEFTPAREN);
        }
        ++this.pos;
        FilterImpl filter = this.parse_filtercomp();
        this.skipWhiteSpace();
        if (this.filterString.charAt(this.pos) != ')') {
            throw this.syntaxException(Messages.FILTER_MISSING_RIGHTPAREN);
        }
        ++this.pos;
        this.skipWhiteSpace();
        return filter;
    }

    private FilterImpl parse_filtercomp() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        char c = this.filterString.charAt(this.pos);
        switch (c) {
            case '&': {
                ++this.pos;
                return this.parse_and();
            }
            case '|': {
                ++this.pos;
                return this.parse_or();
            }
            case '!': {
                ++this.pos;
                return this.parse_not();
            }
        }
        return this.parse_item();
    }

    private FilterImpl parse_item() throws InvalidSyntaxException {
        String attr = this.parse_attr();
        this.skipWhiteSpace();
        char c2 = this.filterString.charAt(this.pos + 1);
        switch (this.filterString.charAt(this.pos)) {
            case '~': {
                if (c2 != '=') break;
                this.pos += 2;
                return new StringFilterImpl(2, attr, this.parse_value());
            }
            case '>': {
                if (c2 != '=') break;
                this.pos += 2;
                return new StringFilterImpl(3, attr, this.parse_value());
            }
            case '<': {
                if (c2 != '=') break;
                this.pos += 2;
                return new StringFilterImpl(4, attr, this.parse_value());
            }
            case '=': {
                if (c2 == '*') {
                    int oldpos = this.pos;
                    this.pos += 2;
                    this.skipWhiteSpace();
                    if (this.filterString.charAt(this.pos) == ')') {
                        return new PresentFilterImpl(attr);
                    }
                    this.pos = oldpos;
                }
                ++this.pos;
                Object string = this.parse_substring();
                return string instanceof String ? new StringFilterImpl(1, attr, (String)string) : new SubstringFilterImpl(attr, (String[])string);
            }
        }
        throw this.syntaxException(Messages.FILTER_INVALID_OPERATOR);
    }

    private FilterImpl parse_not() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        if (this.filterString.charAt(this.pos) != '(') {
            throw this.syntaxException(Messages.FILTER_MISSING_LEFTPAREN);
        }
        FilterImpl child = this.parse_filter();
        return child.getOp() == 9 ? ((NotFilterImpl)child).getFilter() : new NotFilterImpl(child);
    }

    private FilterImpl parse_or() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        char c = this.filterString.charAt(this.pos);
        if (c != '(') {
            throw this.syntaxException(Messages.FILTER_MISSING_LEFTPAREN);
        }
        ArrayList<FilterImpl> operands = new ArrayList<FilterImpl>();
        while (c == '(') {
            FilterImpl child = this.parse_filter();
            operands.add(child);
            c = this.filterString.charAt(this.pos);
        }
        return Parser.normalize(operands, 8);
    }

    private Object parse_substring() throws InvalidSyntaxException {
        String single;
        ArrayList<String> operands = null;
        this.sb.setLength(0);
        block6: while (true) {
            char c = this.filterString.charAt(this.pos);
            switch (c) {
                case ')': {
                    if (this.sb.length() <= 0) break block6;
                    String val = this.sb.toString();
                    if (operands == null) {
                        return val;
                    }
                    operands.add(val);
                    break block6;
                }
                case '(': {
                    throw this.syntaxException(Messages.FILTER_INVALID_VALUE);
                }
                case '*': {
                    if (operands == null) {
                        operands = new ArrayList<String>();
                    }
                    if (this.sb.length() > 0) {
                        operands.add(this.sb.toString());
                        this.sb.setLength(0);
                    }
                    operands.add(null);
                    ++this.pos;
                    continue block6;
                }
                case '\\': {
                    c = this.filterString.charAt(++this.pos);
                }
                default: {
                    this.sb.append(c);
                    ++this.pos;
                    continue block6;
                }
            }
            break;
        }
        if (operands == null) {
            throw this.syntaxException(Messages.FILTER_MISSING_VALUE);
        }
        int size = operands.size();
        if (size == 1 && (single = (String)operands.get(0)) != null) {
            return single;
        }
        return operands.toArray(new String[size]);
    }

    private String parse_value() throws InvalidSyntaxException {
        this.sb.setLength(0);
        block5: while (true) {
            char c = this.filterString.charAt(this.pos);
            switch (c) {
                case ')': {
                    break block5;
                }
                case '(': {
                    throw this.syntaxException(Messages.FILTER_INVALID_VALUE);
                }
                case '\\': {
                    c = this.filterString.charAt(++this.pos);
                }
                default: {
                    this.sb.append(c);
                    ++this.pos;
                    continue block5;
                }
            }
            break;
        }
        int len = this.sb.length();
        while (len > 0 && this.sb.charAt(len - 1) <= ' ') {
            --len;
        }
        if (len == 0) {
            throw this.syntaxException(Messages.FILTER_MISSING_VALUE);
        }
        this.sb.setLength(len);
        return this.sb.toString();
    }

    private void skipWhiteSpace() {
        int top = this.filterString.length();
        while (this.pos < top && Character.isWhitespace(this.filterString.charAt(this.pos))) {
            ++this.pos;
        }
    }

    private InvalidSyntaxException syntaxException(String msg) {
        return new InvalidSyntaxException(NLS.bind((String)msg, (Object)this.filterString, (Object)this.pos), this.filterString);
    }

    private static class Compacter {
        private FilterImpl base;
        private List<FilterImpl> parts;
        private int op;

        Compacter(FilterImpl base, int op) {
            this.base = base;
            this.op = op;
        }

        FilterImpl getResultingFilter() {
            if (this.parts == null) {
                return this.base;
            }
            int partsOp = this.op == 7 ? 8 : 7;
            return this.base.addFilter(Parser.normalize(this.parts, partsOp), this.op);
        }

        boolean merge(FilterImpl b) {
            FilterImpl bf;
            int bidx;
            FilterImpl[] aArr = this.base.getOp() == this.op ? this.base.getFilterImpls() : new FilterImpl[]{this.base};
            FilterImpl[] bArr = b.getOp() == this.op ? b.getFilterImpls() : new FilterImpl[]{b};
            ArrayList<FilterImpl> common = null;
            ArrayList<FilterImpl> onlyA = null;
            int atop = aArr.length;
            int btop = bArr.length;
            int aidx = 0;
            while (aidx < atop) {
                FilterImpl af = aArr[aidx];
                bidx = 0;
                while (bidx < btop) {
                    bf = bArr[bidx];
                    if (af.equals(bf)) {
                        if (common == null) {
                            common = new ArrayList<FilterImpl>();
                        }
                        common.add(af);
                        break;
                    }
                    ++bidx;
                }
                if (bidx == btop) {
                    if (onlyA == null) {
                        onlyA = new ArrayList<FilterImpl>();
                    }
                    onlyA.add(af);
                }
                ++aidx;
            }
            if (common == null) {
                return false;
            }
            if (onlyA == null && this.parts == null) {
                return true;
            }
            ArrayList<FilterImpl> onlyB = null;
            bidx = 0;
            while (bidx < btop) {
                bf = bArr[bidx];
                aidx = 0;
                while (aidx < atop) {
                    if (bf.equals(aArr[aidx])) break;
                    ++aidx;
                }
                if (aidx == atop) {
                    if (onlyB == null) {
                        onlyB = new ArrayList<FilterImpl>();
                    }
                    onlyB.add(bf);
                }
                ++bidx;
            }
            if (onlyB == null && this.parts == null) {
                this.base = b;
                return true;
            }
            if (this.parts == null) {
                this.parts = new ArrayList<FilterImpl>();
            }
            if (onlyA != null) {
                this.base = Parser.normalize((List<FilterImpl>)common, this.op);
                FilterImpl af = Parser.normalize(onlyA, this.op);
                if (!this.parts.contains(af)) {
                    this.parts.add(af);
                }
            }
            if (!this.parts.contains(bf = Parser.normalize(onlyB, this.op))) {
                this.parts.add(bf);
            }
            return true;
        }
    }
}

