/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.util;

import java.util.ArrayList;
import org.eclipse.b3.aggregator.Aggregation;
import org.eclipse.b3.aggregator.EnabledStatusProvider;
import org.eclipse.b3.aggregator.util.AggregatorResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class GeneralUtils {
    public static Aggregation getAggregation(EObject eObject) {
        EObject p;
        EObject c = p = eObject;
        while (c != null) {
            if (c instanceof Aggregation) {
                return (Aggregation)c;
            }
            p = c;
            c = c.eContainer();
        }
        EList contents = GeneralUtils.getAggregatorResource(p).getContents();
        if (contents != null && contents.size() > 0) {
            return (Aggregation)contents.get(0);
        }
        throw new IllegalArgumentException("Aggregator was not found");
    }

    public static AggregatorResource getAggregatorResource(EObject eObject) {
        try {
            for (Resource resource : new ArrayList(eObject.eResource().getResourceSet().getResources())) {
                if (!(resource instanceof AggregatorResource)) continue;
                return (AggregatorResource)resource;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("AggregatorResource was not found", e);
        }
        throw new IllegalArgumentException("AggregatorResource was not found");
    }

    public static <T extends EnabledStatusProvider> EList<T> getEnabled(EList<T> ts) {
        int count = ts.size();
        int idx = 0;
        while (idx < count) {
            if (!((EnabledStatusProvider)ts.get(idx)).isEnabled()) break;
            ++idx;
        }
        if (idx == count) {
            return ts;
        }
        UniqueEList.FastCompare enabledTs = new UniqueEList.FastCompare(count - 1);
        int sdx = 0;
        while (sdx < idx) {
            enabledTs.add((Object)((EnabledStatusProvider)ts.get(sdx)));
            ++sdx;
        }
        ++idx;
        while (idx < count) {
            EnabledStatusProvider t = (EnabledStatusProvider)ts.get(idx);
            if (t.isEnabled()) {
                enabledTs.add((Object)t);
            }
            ++idx;
        }
        return enabledTs;
    }

    public static boolean isBranchEnabled(Object esp) {
        if (esp instanceof EnabledStatusProvider && !((EnabledStatusProvider)esp).isEnabled()) {
            return false;
        }
        if (esp instanceof EObject) {
            EObject v = ((EObject)esp).eContainer();
            while (v != null) {
                if (v instanceof EnabledStatusProvider) {
                    return ((EnabledStatusProvider)v).isBranchEnabled();
                }
                v = v.eContainer();
            }
        }
        return true;
    }
}

