/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.p2.util;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cbi.p2repo.p2.ArtifactDescriptor;
import org.eclipse.cbi.p2repo.p2.ArtifactKey;
import org.eclipse.cbi.p2repo.p2.ArtifactRepository;
import org.eclipse.cbi.p2repo.p2.Copyright;
import org.eclipse.cbi.p2repo.p2.InstallableUnit;
import org.eclipse.cbi.p2repo.p2.License;
import org.eclipse.cbi.p2repo.p2.MappingRule;
import org.eclipse.cbi.p2repo.p2.MetadataRepository;
import org.eclipse.cbi.p2repo.p2.P2Factory;
import org.eclipse.cbi.p2repo.p2.ProvidedCapability;
import org.eclipse.cbi.p2repo.p2.Requirement;
import org.eclipse.cbi.p2repo.p2.TouchpointData;
import org.eclipse.cbi.p2repo.p2.TouchpointInstruction;
import org.eclipse.cbi.p2repo.p2.TouchpointType;
import org.eclipse.cbi.p2repo.p2.UpdateDescriptor;
import org.eclipse.cbi.p2repo.p2.impl.ArtifactDescriptorImpl;
import org.eclipse.cbi.p2repo.p2.impl.ArtifactKeyImpl;
import org.eclipse.cbi.p2repo.p2.impl.ArtifactRepositoryImpl;
import org.eclipse.cbi.p2repo.p2.impl.CopyrightImpl;
import org.eclipse.cbi.p2repo.p2.impl.InstallableUnitFragmentImpl;
import org.eclipse.cbi.p2repo.p2.impl.InstallableUnitImpl;
import org.eclipse.cbi.p2repo.p2.impl.InstallableUnitPatchImpl;
import org.eclipse.cbi.p2repo.p2.impl.LicenseImpl;
import org.eclipse.cbi.p2repo.p2.impl.MappingRuleImpl;
import org.eclipse.cbi.p2repo.p2.impl.MetadataRepositoryImpl;
import org.eclipse.cbi.p2repo.p2.impl.ProcessingStepDescriptorImpl;
import org.eclipse.cbi.p2repo.p2.impl.ProvidedCapabilityImpl;
import org.eclipse.cbi.p2repo.p2.impl.RepositoryImpl;
import org.eclipse.cbi.p2repo.p2.impl.RequiredCapabilityImpl;
import org.eclipse.cbi.p2repo.p2.impl.RequirementChangeImpl;
import org.eclipse.cbi.p2repo.p2.impl.RequirementImpl;
import org.eclipse.cbi.p2repo.p2.impl.SimpleArtifactDescriptorImpl;
import org.eclipse.cbi.p2repo.p2.impl.SimpleArtifactRepositoryImpl;
import org.eclipse.cbi.p2repo.p2.impl.TouchpointInstructionImpl;
import org.eclipse.cbi.p2repo.p2.impl.TouchpointTypeImpl;
import org.eclipse.cbi.p2repo.p2.impl.UpdateDescriptorImpl;
import org.eclipse.cbi.p2repo.util.ExceptionUtils;
import org.eclipse.cbi.p2repo.util.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.ExpressionMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class P2Bridge {
    public static final IQuery<IInstallableUnit> QUERY_ALL_IUS = QueryUtil.createIUAnyQuery();
    public static final IQuery<IArtifactKey> QUERY_ALL_ARTIFACTS = new ExpressionMatchQuery(IArtifactKey.class, ExpressionUtil.TRUE_EXPRESSION, new Object[0]);

    private static void deleteIfExists(URI location, String ... fileNames) throws CoreException {
        File folder = new File(location);
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            File file = new File(folder, fileName);
            if (file.exists() && !file.delete()) {
                throw ExceptionUtils.fromMessage((String)"Unable to delete %s", (Object[])new Object[]{file.getAbsolutePath()});
            }
            ++n2;
        }
    }

    public static void exportFromModel(IArtifactRepositoryManager arMgr, IArtifactRepository ar, boolean overwriteExisting, IProgressMonitor monitor) throws CoreException {
        P2Bridge.exportFromModel(arMgr, ar, ar.getLocation(), overwriteExisting, false, monitor);
    }

    public static void exportFromModel(IArtifactRepositoryManager arMgr, IArtifactRepository ar, URI targetLocation, boolean overwriteExisting, boolean sortArtifacts, IProgressMonitor monitor) throws CoreException {
        if (overwriteExisting) {
            P2Bridge.deleteIfExists(targetLocation, "artifacts.xml", "artifacts.jar", "compositeArtifacts.jar");
            arMgr.removeRepository(targetLocation);
        }
        IArtifactRepository target = arMgr.createRepository(targetLocation, ar.getName(), ar.getType(), ar.getProperties());
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IQueryResult result = ar.query(QUERY_ALL_ARTIFACTS, (IProgressMonitor)subMon.newChild(90));
            Iterator itor = result.iterator();
            ArrayList<IArtifactKey> artifacts = new ArrayList<IArtifactKey>();
            while (itor.hasNext()) {
                artifacts.add((IArtifactKey)itor.next());
            }
            if (sortArtifacts) {
                Collections.sort(artifacts, new Comparator<IArtifactKey>(){

                    @Override
                    public int compare(IArtifactKey a1, IArtifactKey a2) {
                        int result = a1.getId().compareTo(a2.getId());
                        if (result == 0) {
                            return a1.getVersion().compareTo((Object)a2.getVersion());
                        }
                        return result;
                    }
                });
            }
            for (IArtifactKey key : artifacts) {
                IArtifactDescriptor[] descriptors;
                IArtifactDescriptor[] iArtifactDescriptorArray = descriptors = ar.getArtifactDescriptors(key);
                int n = descriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
                    if (descriptor instanceof SimpleArtifactDescriptorImpl) {
                        SimpleArtifactDescriptor p2native = new SimpleArtifactDescriptor(descriptor);
                        p2native.setRepositoryProperty("artifact.reference", ((SimpleArtifactDescriptorImpl)descriptor).getRepositoryProperty("artifact.reference"));
                        target.addDescriptor((IArtifactDescriptor)p2native, (IProgressMonitor)subMon.newChild(1));
                    } else {
                        target.addDescriptor(descriptor, (IProgressMonitor)subMon.newChild(1));
                    }
                    ++n2;
                }
            }
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    public static void exportFromModel(IMetadataRepositoryManager mdrMgr, IMetadataRepository mdr, boolean overwriteExisting, IProgressMonitor monitor) throws CoreException {
        P2Bridge.exportFromModel(mdrMgr, mdr, mdr.getLocation(), overwriteExisting, false, monitor);
    }

    public static void exportFromModel(IMetadataRepositoryManager mdrMgr, IMetadataRepository mdr, URI targetLocation, boolean overwriteExisting, boolean sortIUs, IProgressMonitor monitor) throws CoreException {
        if (overwriteExisting) {
            P2Bridge.deleteIfExists(targetLocation, "content.xml", "content.jar", "compositeContent.jar");
            mdrMgr.removeRepository(targetLocation);
        }
        IMetadataRepository target = mdrMgr.createRepository(targetLocation, mdr.getName(), mdr.getType(), mdr.getProperties());
        monitor = MonitorUtils.ensureNotNull((IProgressMonitor)monitor);
        IQueryResult result = mdr.query(QUERY_ALL_IUS, monitor);
        Iterator itor = result.iterator();
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
        while (itor.hasNext()) {
            ius.add((IInstallableUnit)itor.next());
        }
        if (sortIUs) {
            Collections.sort(ius);
        }
        target.addInstallableUnits(ius);
        target.addReferences(mdr.getReferences());
    }

    public static ArtifactKey importToModel(IArtifactKey key) {
        if (key == null) {
            return null;
        }
        ArtifactKeyImpl mkey = (ArtifactKeyImpl)P2Factory.eINSTANCE.createArtifactKey();
        mkey.setClassifier(key.getClassifier());
        mkey.setId(key.getId());
        mkey.setVersion(key.getVersion());
        return mkey;
    }

    public static ArtifactDescriptor importToModel(IArtifactRepository target, IArtifactDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        ArtifactDescriptorImpl mdescriptor = (ArtifactDescriptorImpl)target.createArtifactDescriptor(descriptor.getArtifactKey());
        EList<IProcessingStepDescriptor> msteps = mdescriptor.getProcessingStepList();
        IProcessingStepDescriptor[] iProcessingStepDescriptorArray = descriptor.getProcessingSteps();
        int n = iProcessingStepDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessingStepDescriptor step = iProcessingStepDescriptorArray[n2];
            msteps.add(P2Bridge.importToModel(step));
            ++n2;
        }
        Map props = descriptor.getProperties();
        if (props.size() > 0) {
            mdescriptor.getPropertyMap().putAll(props);
        }
        if (descriptor instanceof SimpleArtifactDescriptor) {
            props = ((SimpleArtifactDescriptor)descriptor).getRepositoryProperties();
            ((SimpleArtifactDescriptorImpl)mdescriptor).getRepositoryPropertyMap().putAll(props);
        }
        return mdescriptor;
    }

    public static void importToModel(IArtifactRepositoryManager arMgr, IArtifactRepository ar, ArtifactRepositoryImpl target, IProgressMonitor monitor) throws CoreException {
        String[][] rules;
        P2Bridge.importToModel(arMgr, ar, target);
        IQuery descriptorQuery = QueryUtil.createMatchQuery(IArtifactDescriptor.class, (IExpression)ExpressionUtil.TRUE_EXPRESSION, (Object[])new Object[0]);
        Set result = ar.descriptorQueryable().query(descriptorQuery, monitor).toUnmodifiableSet();
        for (IArtifactDescriptor desc : result) {
            target.addDescriptor(desc);
        }
        if (ar instanceof SimpleArtifactRepository && (rules = ((SimpleArtifactRepository)ar).getRules()) != null) {
            EList<MappingRule> trules = ((SimpleArtifactRepositoryImpl)target).getRules();
            String[][] stringArray = rules;
            int n = rules.length;
            int n2 = 0;
            while (n2 < n) {
                String[] ruleDef = stringArray[n2];
                MappingRuleImpl trule = (MappingRuleImpl)P2Factory.eINSTANCE.createMappingRule();
                trule.setFilter(ruleDef[0]);
                trule.setOutput(ruleDef[1]);
                trules.add(trule);
                ++n2;
            }
        }
    }

    public static ArtifactRepository importToModel(IArtifactRepositoryManager arMgr, IArtifactRepository ar, IProgressMonitor monitor) throws CoreException {
        ArtifactRepositoryImpl target = ar instanceof SimpleArtifactRepository ? (ArtifactRepositoryImpl)((Object)P2Factory.eINSTANCE.createSimpleArtifactRepository()) : (ArtifactRepositoryImpl)P2Factory.eINSTANCE.createArtifactRepository();
        P2Bridge.importToModel(arMgr, ar, target, monitor);
        return target;
    }

    public static Copyright importToModel(ICopyright cr) {
        if (cr == null) {
            return null;
        }
        CopyrightImpl mcr = (CopyrightImpl)P2Factory.eINSTANCE.createCopyright();
        mcr.setBody(cr.getBody());
        mcr.setLocation(cr.getLocation());
        return mcr;
    }

    public static InstallableUnit importToModel(IInstallableUnit iu) {
        return P2Bridge.importToModel(iu, null);
    }

    public static InstallableUnit importToModel(IInstallableUnit iu, IInstallableUnit siteXMLGeneratedIU) {
        Object miu;
        if (iu == null) {
            return null;
        }
        P2Factory factory = P2Factory.eINSTANCE;
        if (iu instanceof IInstallableUnitFragment) {
            InstallableUnitFragmentImpl miuf = (InstallableUnitFragmentImpl)factory.createInstallableUnitFragment();
            EList<IRequirement> mhosts = miuf.getHost();
            for (IRequirement host : ((IInstallableUnitFragment)iu).getHost()) {
                mhosts.add(P2Bridge.importToModel(host));
            }
            miu = miuf;
        } else if (iu instanceof IInstallableUnitPatch) {
            IInstallableUnitPatch iup = (IInstallableUnitPatch)iu;
            InstallableUnitPatchImpl miup = (InstallableUnitPatchImpl)factory.createInstallableUnitPatch();
            IRequirement[][] scope = iup.getApplicabilityScope();
            if (scope != null) {
                EList<IRequirement> appliesTo = miup.getAppliesTo();
                IRequirement[][] iRequirementArray = scope;
                int n = scope.length;
                int n2 = 0;
                while (n2 < n) {
                    IRequirement[] rqs;
                    IRequirement[] iRequirementArray2 = rqs = iRequirementArray[n2];
                    int n3 = rqs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IRequirement rq = iRequirementArray2[n4];
                        appliesTo.add(P2Bridge.importToModel(rq));
                        ++n4;
                    }
                    ++n2;
                }
            }
            miup.setLifeCycle(P2Bridge.importToModel(iup.getLifeCycle()));
            EList<IRequirementChange> mrqChanges = miup.getRequirementsChange();
            for (Object rqChange : iup.getRequirementsChange()) {
                mrqChanges.add(P2Bridge.importToModel((IRequirementChange)rqChange));
            }
            miu = miup;
        } else {
            miu = (InstallableUnitImpl)factory.createInstallableUnit();
        }
        ((InstallableUnitImpl)miu).setCopyright(P2Bridge.importToModel(iu.getCopyright()));
        ((InstallableUnitImpl)miu).setFilter((IMatchExpression<IInstallableUnit>)iu.getFilter());
        ((InstallableUnitImpl)miu).setId(iu.getId());
        for (ILicense license : iu.getLicenses()) {
            ((InstallableUnitImpl)miu).getLicenses().add((Object)P2Bridge.importToModel(license));
        }
        ((InstallableUnitImpl)miu).setResolved(iu.isResolved());
        ((InstallableUnitImpl)miu).setSingleton(iu.isSingleton());
        ((InstallableUnitImpl)miu).setTouchpointType(P2Bridge.importToModel(iu.getTouchpointType()));
        ((InstallableUnitImpl)miu).setUpdateDescriptor(P2Bridge.importToModel(iu.getUpdateDescriptor()));
        ((InstallableUnitImpl)miu).setVersion(iu.getVersion());
        Map props = iu.getProperties();
        if (props.size() > 0) {
            ((InstallableUnitImpl)miu).getPropertyMap().putAll(props);
        }
        EList<IArtifactKey> keys = ((InstallableUnitImpl)miu).getArtifacts();
        for (IArtifactKey key : iu.getArtifacts()) {
            keys.add(P2Bridge.importToModel(key));
        }
        EList<IRequirement> reqs = ((InstallableUnitImpl)miu).getMetaRequirements();
        for (IRequirement req : iu.getMetaRequirements()) {
            reqs.add(P2Bridge.importToModel(req));
        }
        reqs = ((InstallableUnitImpl)miu).getRequirements();
        for (IRequirement rc : iu.getRequirements()) {
            reqs.add(P2Bridge.importToModel(rc));
        }
        EList<IProvidedCapability> pcs = ((InstallableUnitImpl)miu).getProvidedCapabilities();
        for (IProvidedCapability pc : iu.getProvidedCapabilities()) {
            pcs.add(P2Bridge.importToModel(pc));
        }
        EList<ITouchpointData> tds = ((InstallableUnitImpl)miu).getTouchpointData();
        for (ITouchpointData td : iu.getTouchpointData()) {
            tds.add(P2Bridge.importToModel(td));
        }
        if (siteXMLGeneratedIU != null) {
            for (ITouchpointData td : siteXMLGeneratedIU.getTouchpointData()) {
                ITouchpointInstruction tdi = td.getInstruction("zipped");
                if (tdi == null) continue;
                if (tds.isEmpty()) {
                    tds.add(P2Bridge.importToModel(td));
                    break;
                }
                ((TouchpointData)tds.get(0)).getInstructionMap().put((Object)"zipped", (Object)P2Bridge.importToModel(tdi));
                break;
            }
        }
        return miu;
    }

    public static License importToModel(ILicense lc) {
        if (lc == null) {
            return null;
        }
        LicenseImpl mlc = (LicenseImpl)P2Factory.eINSTANCE.createLicense();
        mlc.setBody(lc.getBody());
        mlc.setUUID(lc.getUUID());
        mlc.setLocation(lc.getLocation());
        return mlc;
    }

    public static MetadataRepository importToModel(IMetadataRepositoryManager mdrMgr, IMetadataRepository mdr, IProgressMonitor monitor) throws CoreException {
        MetadataRepositoryImpl target = (MetadataRepositoryImpl)P2Factory.eINSTANCE.createMetadataRepository();
        P2Bridge.importToModel(mdrMgr, mdr, target, monitor);
        return target;
    }

    public static void importToModel(IMetadataRepositoryManager mdrMgr, IMetadataRepository mdr, MetadataRepositoryImpl target, IProgressMonitor monitor) throws CoreException {
        P2Bridge.importToModel(mdrMgr, mdr, target, monitor, false);
    }

    public static void importToModel(IMetadataRepositoryManager mdrMgr, IMetadataRepository mdr, MetadataRepositoryImpl target, IProgressMonitor monitor, boolean sortIUs) throws CoreException {
        P2Bridge.importToModel(mdrMgr, mdr, target);
        monitor = MonitorUtils.ensureNotNull((IProgressMonitor)monitor);
        IQueryResult result = mdr.query(QUERY_ALL_IUS, monitor);
        Iterator itor = result.iterator();
        ArrayList<InstallableUnit> ius = new ArrayList<InstallableUnit>();
        while (itor.hasNext()) {
            ius.add(P2Bridge.importToModel((IInstallableUnit)itor.next()));
        }
        if (sortIUs) {
            Collections.sort(ius);
        }
        target.getInstallableUnits().addAll(ius);
        target.addRepositoryReferences(mdrMgr, mdr);
    }

    public static IProcessingStepDescriptor importToModel(IProcessingStepDescriptor step) {
        if (step == null) {
            return null;
        }
        ProcessingStepDescriptorImpl mstep = (ProcessingStepDescriptorImpl)P2Factory.eINSTANCE.createProcessingStepDescriptor();
        mstep.setData(step.getData());
        mstep.setProcessorId(mstep.getProcessorId());
        mstep.setRequired(step.isRequired());
        return mstep;
    }

    public static ProvidedCapability importToModel(IProvidedCapability pc) {
        if (pc == null) {
            return null;
        }
        ProvidedCapabilityImpl mrq = (ProvidedCapabilityImpl)P2Factory.eINSTANCE.createProvidedCapability();
        mrq.setName(pc.getName());
        mrq.setNamespace(pc.getNamespace());
        mrq.setVersion(pc.getVersion());
        return mrq;
    }

    public static <T> void importToModel(IRepositoryManager<T> repoMgr, IRepository<T> repo, RepositoryImpl<T> target) throws CoreException {
        target.setProvisioningAgent(repo.getProvisioningAgent());
        target.setName(repo.getName());
        target.setLocation(repo.getLocation());
        target.setDescription(repo.getDescription());
        target.setProvider(repo.getProvider());
        target.setType(repo.getType());
        target.setVersion(repo.getVersion());
        target.getPropertyMap().putAll(repo.getProperties());
    }

    public static Requirement importToModel(IRequirement req) {
        RequirementImpl mreq;
        if (req == null) {
            return null;
        }
        if (req instanceof IRequiredCapability) {
            IRequiredCapability rc = (IRequiredCapability)req;
            RequiredCapabilityImpl mrc = (RequiredCapabilityImpl)P2Factory.eINSTANCE.createRequiredCapability();
            mrc.setName(rc.getName());
            mrc.setNamespace(rc.getNamespace());
            mrc.setRange(rc.getRange());
            mreq = mrc;
        } else {
            mreq = (RequirementImpl)P2Factory.eINSTANCE.createRequirement();
        }
        mreq.setFilter((IMatchExpression<IInstallableUnit>)req.getFilter());
        mreq.setGreedy(req.isGreedy());
        mreq.setMin(req.getMin());
        mreq.setMax(req.getMax());
        mreq.setDescription(req.getDescription());
        return mreq;
    }

    public static IRequirementChange importToModel(IRequirementChange rqChange) {
        if (rqChange == null) {
            return null;
        }
        RequirementChangeImpl mrqc = (RequirementChangeImpl)P2Factory.eINSTANCE.createRequirementChange();
        mrqc.setApplyOn((IRequiredCapability)P2Bridge.importToModel((IRequirement)rqChange.applyOn()));
        mrqc.setNewValue((IRequiredCapability)P2Bridge.importToModel((IRequirement)rqChange.newValue()));
        return mrqc;
    }

    public static TouchpointData importToModel(ITouchpointData ptd) {
        if (ptd == null) {
            return null;
        }
        TouchpointData mtpd = P2Factory.eINSTANCE.createTouchpointData();
        EMap<String, ITouchpointInstruction> minstrMap = mtpd.getInstructionMap();
        Map instrMap = ptd.getInstructions();
        for (Map.Entry instr : instrMap.entrySet()) {
            minstrMap.put((Object)((String)instr.getKey()), (Object)P2Bridge.importToModel((ITouchpointInstruction)instr.getValue()));
        }
        return mtpd;
    }

    public static TouchpointInstruction importToModel(ITouchpointInstruction ti) {
        if (ti == null) {
            return null;
        }
        TouchpointInstructionImpl mti = (TouchpointInstructionImpl)P2Factory.eINSTANCE.createTouchpointInstruction();
        mti.setBody(ti.getBody());
        mti.setImportAttribute(ti.getImportAttribute());
        return mti;
    }

    public static TouchpointType importToModel(ITouchpointType tpt) {
        if (tpt == null) {
            return null;
        }
        TouchpointTypeImpl mtpt = (TouchpointTypeImpl)P2Factory.eINSTANCE.createTouchpointType();
        mtpt.setId(tpt.getId());
        mtpt.setVersion(tpt.getVersion());
        return mtpt;
    }

    public static UpdateDescriptor importToModel(IUpdateDescriptor ud) {
        if (ud == null) {
            return null;
        }
        UpdateDescriptorImpl mud = (UpdateDescriptorImpl)P2Factory.eINSTANCE.createUpdateDescriptor();
        mud.setDescription(ud.getDescription());
        mud.setIUsBeingUpdated(ud.getIUsBeingUpdated());
        mud.setSeverity(ud.getSeverity());
        mud.setLocation(ud.getLocation());
        return mud;
    }
}

