/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.p2.tests;

import java.util.Set;
import junit.framework.Assert;
import org.eclipse.cbi.p2repo.p2.tests.RepositoryTests;
import org.eclipse.cbi.p2repo.p2.util.P2Bridge;
import org.eclipse.cbi.p2repo.p2.util.P2Utils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.junit.Before;
import org.junit.Test;

public class ArtifactRepositoryTests
extends RepositoryTests<IArtifactKey> {
    protected IArtifactRepository source;
    protected IArtifactRepository target;
    protected IQuery<IArtifactKey> query;

    @Before
    public void createAndLoadAR() throws Exception {
        IArtifactRepositoryManager arMgr = (IArtifactRepositoryManager)P2Utils.getRepositoryManager(IArtifactRepositoryManager.class);
        this.source = arMgr.loadRepository(ArtifactRepositoryTests.getTestData("bucky"), this.monitor);
        this.target = P2Bridge.importToModel((IArtifactRepositoryManager)arMgr, (IArtifactRepository)this.source, (IProgressMonitor)this.monitor);
        this.query = QueryUtil.createMatchQuery(IArtifactKey.class, (IExpression)ExpressionUtil.TRUE_EXPRESSION, (Object[])new Object[0]);
    }

    @Test
    public void testContainer() throws Exception {
        Set keys = this.target.query(this.query, this.monitor).toUnmodifiableSet();
        for (IArtifactKey key : keys) {
            IArtifactDescriptor[] iArtifactDescriptorArray = this.target.getArtifactDescriptors(key);
            int n = iArtifactDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactDescriptor desc = iArtifactDescriptorArray[n2];
                Assert.assertTrue((String)"Parent is not correct", (this.target == desc.getRepository() ? 1 : 0) != 0);
                ++n2;
            }
        }
    }

    @Test
    public void testEquality() throws Exception {
        super.assertEquals(this.source, this.target);
        Set aKeys = this.source.query(this.query, this.monitor).toUnmodifiableSet();
        Set bKeys = this.target.query(this.query, this.monitor).toUnmodifiableSet();
        Assert.assertEquals((String)"Artifact keys differ", (Object)aKeys, (Object)bKeys);
        for (IArtifactKey key : aKeys) {
            IArtifactDescriptor[] bDescs;
            IArtifactDescriptor[] aDescs = this.source.getArtifactDescriptors(key);
            if (aDescs.length != (bDescs = this.target.getArtifactDescriptors(key)).length) {
                Assert.fail((String)("ArtifactDescriptorCount for " + key + " differs"));
            }
            IArtifactDescriptor[] iArtifactDescriptorArray = aDescs;
            int n = aDescs.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactDescriptor desc = iArtifactDescriptorArray[n2];
                Assert.assertTrue((String)"Missing artifact descriptor", (boolean)this.target.contains(desc));
                ++n2;
            }
        }
    }
}

