/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GdkEventScroll;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    long scrolledHandle;
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite parent, int style) {
        super(parent, style);
    }

    long clientHandle() {
        return this.handle;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle rect = DPIUtil.autoScaleUp(new Rectangle(x, y, width, height));
        return DPIUtil.autoScaleDown(this.computeTrimInPixels(rect.x, rect.y, rect.width, rect.height));
    }

    Rectangle computeTrimInPixels(int x, int y, int width, int height) {
        this.checkWidget();
        int border = 0;
        if (this.fixedHandle != 0L) {
            border += OS.gtk_container_get_border_width(this.fixedHandle);
        }
        if (this.scrolledHandle != 0L) {
            border += OS.gtk_container_get_border_width(this.scrolledHandle);
        }
        int trimX = x - border;
        int trimY = y - border;
        int trimWidth = width + border * 2;
        int trimHeight = height + border * 2;
        trimHeight += this.hScrollBarWidth();
        trimWidth += this.vScrollBarWidth();
        if (this.scrolledHandle != 0L && OS.gtk_scrolled_window_get_shadow_type(this.scrolledHandle) != 0) {
            Point thickness = this.getThickness(this.scrolledHandle);
            int xthickness = thickness.x;
            int ythickness = thickness.y;
            trimX -= xthickness;
            trimY -= ythickness;
            trimWidth += xthickness * 2;
            trimHeight += ythickness * 2;
        }
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    ScrollBar createScrollBar(int style) {
        if (this.scrolledHandle == 0L) {
            return null;
        }
        ScrollBar bar = new ScrollBar();
        bar.parent = this;
        bar.style = style;
        bar.display = this.display;
        bar.state |= 8;
        if ((style & 0x100) != 0) {
            bar.handle = OS.gtk_scrolled_window_get_hscrollbar(this.scrolledHandle);
            bar.adjustmentHandle = OS.gtk_scrolled_window_get_hadjustment(this.scrolledHandle);
        } else {
            bar.handle = OS.gtk_scrolled_window_get_vscrollbar(this.scrolledHandle);
            bar.adjustmentHandle = OS.gtk_scrolled_window_get_vadjustment(this.scrolledHandle);
        }
        bar.setOrientation(true);
        bar.hookEvents();
        bar.register();
        return bar;
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    @Override
    void updateBackgroundMode() {
        super.updateBackgroundMode();
        switch (this.applyThemeBackground()) {
            case 0: {
                this.state &= 0xFFFEFFFF;
                break;
            }
            case 1: {
                this.state |= 0x10000;
            }
        }
        super.updateBackgroundMode();
    }

    int applyThemeBackground() {
        return this.backgroundAlpha == 0 ? 1 : 0;
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.scrolledHandle != 0L) {
            this.display.removeWidget(this.scrolledHandle);
        }
    }

    void destroyScrollBar(ScrollBar bar) {
        this.setScrollBarVisible(bar, false);
    }

    @Override
    int getBorderWidthInPixels() {
        this.checkWidget();
        int border = 0;
        if (this.fixedHandle != 0L) {
            border += OS.gtk_container_get_border_width(this.fixedHandle);
        }
        if (this.scrolledHandle != 0L) {
            border += OS.gtk_container_get_border_width(this.scrolledHandle);
            if (OS.gtk_scrolled_window_get_shadow_type(this.scrolledHandle) != 0) {
                border += this.getThickness((long)this.scrolledHandle).x;
            }
        }
        return border;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getClientAreaInPixels());
    }

    Rectangle getClientAreaInPixels() {
        this.checkWidget();
        this.forceResize();
        long clientHandle = this.clientHandle();
        GtkAllocation allocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(clientHandle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        return new Rectangle(x, y, width, height);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public int getScrollbarsMode() {
        this.checkWidget();
        return 0;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    @Override
    long gtk_scroll_event(long widget, long eventPtr) {
        long result = super.gtk_scroll_event(widget, eventPtr);
        if ((this.state & 2) != 0) {
            GdkEventScroll gdkEvent = new GdkEventScroll();
            OS.memmove(gdkEvent, eventPtr, (long)GdkEventScroll.sizeof);
            if (gdkEvent.direction == 4) {
                double[] delta_x = new double[1];
                double[] delta_y = new double[1];
                if (OS.gdk_event_get_scroll_deltas(eventPtr, delta_x, delta_y)) {
                    int value;
                    double delta;
                    GtkAdjustment adjustment;
                    ScrollBar scrollBar;
                    if (delta_x[0] != 0.0 && (scrollBar = this.horizontalBar) != null && !OS.gtk_widget_get_visible(scrollBar.handle) && scrollBar.getEnabled()) {
                        adjustment = new GtkAdjustment();
                        this.gtk_adjustment_get(scrollBar.adjustmentHandle, adjustment);
                        delta = Math.pow(adjustment.page_size, 0.6666666666666666) * delta_x[0];
                        value = (int)Math.max(adjustment.lower, Math.min(adjustment.upper - adjustment.page_size, adjustment.value + delta));
                        OS.gtk_adjustment_set_value(scrollBar.adjustmentHandle, value);
                        result = 1L;
                    }
                    if (delta_y[0] != 0.0 && (scrollBar = this.verticalBar) != null && !OS.gtk_widget_get_visible(scrollBar.handle) && scrollBar.getEnabled()) {
                        adjustment = new GtkAdjustment();
                        this.gtk_adjustment_get(scrollBar.adjustmentHandle, adjustment);
                        delta = Math.pow(adjustment.page_size, 0.6666666666666666) * delta_y[0];
                        value = (int)Math.max(adjustment.lower, Math.min(adjustment.upper - adjustment.page_size, adjustment.value + delta));
                        OS.gtk_adjustment_set_value(scrollBar.adjustmentHandle, value);
                        result = 1L;
                    }
                }
            } else {
                ScrollBar scrollBar = gdkEvent.direction == 0 || gdkEvent.direction == 1 ? this.verticalBar : this.horizontalBar;
                if (scrollBar != null && !OS.gtk_widget_get_visible(scrollBar.handle) && scrollBar.getEnabled()) {
                    GtkAdjustment adjustment = new GtkAdjustment();
                    this.gtk_adjustment_get(scrollBar.adjustmentHandle, adjustment);
                    int wheel_delta = (int)Math.pow(adjustment.page_size, 0.6666666666666666);
                    if (gdkEvent.direction == 0 || gdkEvent.direction == 2) {
                        wheel_delta = -wheel_delta;
                    }
                    int value = (int)Math.max(adjustment.lower, Math.min(adjustment.upper - adjustment.page_size, adjustment.value + (double)wheel_delta));
                    OS.gtk_adjustment_set_value(scrollBar.adjustmentHandle, value);
                    return 1L;
                }
            }
        }
        return result;
    }

    int hScrollBarWidth() {
        if (this.horizontalBar == null) {
            return 0;
        }
        long hBarHandle = 0L;
        hBarHandle = OS.gtk_scrolled_window_get_hscrollbar(this.scrolledHandle);
        if (hBarHandle == 0L) {
            return 0;
        }
        GtkRequisition requisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(hBarHandle, requisition);
        int[] padding = new int[1];
        OS.gtk_widget_style_get(this.scrolledHandle, OS.scrollbar_spacing, padding, 0L);
        int spacing = padding[0];
        return requisition.height + spacing;
    }

    @Override
    void reskinChildren(int flags) {
        if (this.horizontalBar != null) {
            this.horizontalBar.reskin(flags);
        }
        if (this.verticalBar != null) {
            this.verticalBar.reskin(flags);
        }
        super.reskinChildren(flags);
    }

    @Override
    boolean sendLeaveNotify() {
        return this.scrolledHandle != 0L;
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.scrolledHandle != 0L) {
                OS.gtk_widget_set_direction(this.scrolledHandle, dir);
            }
        }
        if (this.horizontalBar != null) {
            this.horizontalBar.setOrientation(create);
        }
        if (this.verticalBar != null) {
            this.verticalBar.setOrientation(create);
        }
    }

    boolean setScrollBarVisible(ScrollBar bar, boolean visible) {
        int policy;
        if (this.scrolledHandle == 0L) {
            return false;
        }
        int[] hsp = new int[1];
        int[] vsp = new int[1];
        OS.gtk_scrolled_window_get_policy(this.scrolledHandle, hsp, vsp);
        int n = policy = visible ? 0 : 2;
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0) && !visible) {
            policy = 3;
        }
        if ((bar.style & 0x100) != 0) {
            if (hsp[0] == policy) {
                return false;
            }
            hsp[0] = policy;
        } else {
            if (vsp[0] == policy) {
                return false;
            }
            vsp[0] = policy;
        }
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp[0], vsp[0]);
        return true;
    }

    void redrawBackgroundImage() {
    }

    @Override
    void redrawWidget(int x, int y, int width, int height, boolean redrawAll, boolean all, boolean trim) {
        long paintHandle;
        super.redrawWidget(x, y, width, height, redrawAll, all, trim);
        if (!this.gtk_widget_get_realized(this.handle)) {
            return;
        }
        if (!trim) {
            return;
        }
        long topHandle = this.topHandle();
        if (topHandle == (paintHandle = this.paintHandle())) {
            return;
        }
        long window = this.gtk_widget_get_window(topHandle);
        GdkRectangle rect = new GdkRectangle();
        if (redrawAll) {
            GtkAllocation allocation = new GtkAllocation();
            OS.gtk_widget_get_allocation(topHandle, allocation);
            rect.width = allocation.width;
            rect.height = allocation.height;
        } else {
            int[] destX = new int[1];
            int[] destY = new int[1];
            OS.gtk_widget_translate_coordinates(paintHandle, topHandle, x, y, destX, destY);
            rect.x = destX[0];
            rect.y = destY[0];
            rect.width = Math.max(0, width);
            rect.height = Math.max(0, height);
        }
        OS.gdk_window_invalidate_rect(window, rect, all);
    }

    @Override
    void register() {
        super.register();
        if (this.scrolledHandle != 0L) {
            this.display.addWidget(this.scrolledHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.scrolledHandle = 0L;
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void resizeHandle(int width, int height) {
        if (OS.GTK3) {
            if (this.fixedHandle != 0L) {
                OS.swt_fixed_resize(OS.gtk_widget_get_parent(this.fixedHandle), this.fixedHandle, width, height);
            }
            long child = this.scrolledHandle != 0L ? this.scrolledHandle : this.handle;
            OS.swt_fixed_resize(OS.gtk_widget_get_parent(child), child, width, height);
        } else {
            if (this.fixedHandle != 0L) {
                OS.gtk_widget_set_size_request(this.fixedHandle, width, height);
            }
            OS.gtk_widget_set_size_request(this.scrolledHandle != 0L ? this.scrolledHandle : this.handle, width, height);
        }
    }

    @Override
    void showWidget() {
        super.showWidget();
        if (this.scrolledHandle != 0L) {
            OS.gtk_widget_show(this.scrolledHandle);
        }
    }

    @Override
    long topHandle() {
        if (this.fixedHandle != 0L) {
            return this.fixedHandle;
        }
        if (this.scrolledHandle != 0L) {
            return this.scrolledHandle;
        }
        return super.topHandle();
    }

    void updateScrollBarValue(ScrollBar bar) {
        this.redrawBackgroundImage();
    }

    int vScrollBarWidth() {
        if (this.verticalBar == null) {
            return 0;
        }
        long vBarHandle = 0L;
        vBarHandle = OS.gtk_scrolled_window_get_vscrollbar(this.scrolledHandle);
        if (vBarHandle == 0L) {
            return 0;
        }
        GtkRequisition requisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(vBarHandle, requisition);
        int[] padding = new int[1];
        OS.gtk_widget_style_get(this.scrolledHandle, OS.scrollbar_spacing, padding, 0L);
        int spacing = padding[0];
        return requisition.width + spacing;
    }
}

