/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.p2view.presentation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cbi.p2repo.aggregator.p2view.provider.P2viewItemProviderAdapterFactory;
import org.eclipse.cbi.p2repo.aggregator.presentation.AggregatorEditorPlugin;
import org.eclipse.cbi.p2repo.aggregator.provider.AggregatorItemProviderAdapterFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class P2viewEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected List<PropertySheetPage> propertySheetPages = new ArrayList<PropertySheetPage>();
    protected PropertySheetPage propertySheetPage;
    protected TreeViewer selectionViewer;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == P2viewEditor.this.contentOutlinePage) {
                    P2viewEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)P2viewEditor.this);
                    P2viewEditor.this.setCurrentViewer((Viewer)P2viewEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (P2viewEditor.this.propertySheetPages.contains(((PropertySheet)p).getCurrentPage())) {
                    P2viewEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)P2viewEditor.this);
                    P2viewEditor.this.handleActivate();
                }
            } else if (p == P2viewEditor.this) {
                P2viewEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = P2viewEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            P2viewEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            P2viewEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!P2viewEditor.this.updateProblemIndication) return;
                        P2viewEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                P2viewEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
            P2viewEditor.this.resourceToDiagnosticMap.remove(target);
            if (P2viewEditor.this.updateProblemIndication) {
                P2viewEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        P2viewEditor.this.updateProblemIndication();
                    }
                });
            }
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).P2viewEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1) {
                            Resource resource;
                            if ((delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                                if (delta.getKind() == 2) {
                                    this.removedResources.add(resource);
                                } else if (!(this).P2viewEditor.this.savedResources.remove(resource)) {
                                    this.changedResources.add(resource);
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    P2viewEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).P2viewEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!P2viewEditor.this.isDirty()) {
                                P2viewEditor.this.getSite().getPage().closeEditor((IEditorPart)P2viewEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    P2viewEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).P2viewEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (P2viewEditor.this.getSite().getPage().getActiveEditor() == P2viewEditor.this) {
                                P2viewEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                AggregatorEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };

    private static String getString(String key) {
        return AggregatorEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return AggregatorEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public P2viewEditor() {
        this.initializeEditingDomain();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        boolean hasErrors;
        boolean bl = hasErrors = !resource.getErrors().isEmpty();
        if (hasErrors || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(hasErrors ? 4 : 2, "org.eclipse.cbi.p2repo.aggregator.editor", 0, P2viewEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.cbi.p2repo.aggregator.editor", 0, P2viewEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void createModel() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput(), (URIConverter)this.editingDomain.getResourceSet().getURIConverter());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    public void createPages() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            Tree tree = new Tree(this.getContainer(), 2);
            this.selectionViewer = new TreeViewer(tree);
            this.setCurrentViewer((Viewer)this.selectionViewer);
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.FontAndColorProvider((AdapterFactory)this.adapterFactory, (Viewer)this.selectionViewer));
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage((Control)tree);
            this.setPageText(pageIndex, P2viewEditor.getString("_UI_SelectionPage_label"));
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    P2viewEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    P2viewEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                P2viewEditor.this.updateProblemIndication();
            }
        });
    }

    public void dispose() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        for (PropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("LINE_DELIMITER", "");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : P2viewEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !P2viewEditor.this.isPersisted(resource) || P2viewEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            P2viewEditor.this.savedResources.add(resource);
                        }
                    }
                    catch (Exception exception) {
                        P2viewEditor.this.resourceToDiagnosticMap.put(resource, P2viewEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            AggregatorEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    P2viewEditor.this.contentOutlineViewer = this.getTreeViewer();
                    P2viewEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    P2viewEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)P2viewEditor.this.adapterFactory));
                    P2viewEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.FontAndColorProvider((AdapterFactory)P2viewEditor.this.adapterFactory, (Viewer)P2viewEditor.this.contentOutlineViewer));
                    P2viewEditor.this.contentOutlineViewer.setInput((Object)P2viewEditor.this.editingDomain.getResourceSet());
                    P2viewEditor.this.createContextMenuFor((StructuredViewer)P2viewEditor.this.contentOutlineViewer);
                    if (!P2viewEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        P2viewEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(P2viewEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    P2viewEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    P2viewEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    P2viewEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public IPropertySheetPage getPropertySheetPage() {
        ExtendedPropertySheetPage propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

            public void setSelectionToViewer(List<?> selection) {
                P2viewEditor.this.setSelectionToViewer(selection);
                P2viewEditor.this.setFocus();
            }

            public void setActionBars(IActionBars actionBars) {
                super.setActionBars(actionBars);
                P2viewEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
            }
        };
        propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.propertySheetPages.add((PropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    public void gotoMarker(IMarker marker) {
        List targetObjects = this.markerHelper.getTargetObjects((Object)this.editingDomain, marker);
        if (!targetObjects.isEmpty()) {
            this.setSelectionToViewer(targetObjects);
        }
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.selectionViewer != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList selectionList = new ArrayList();
            selectionList.add(selectedElement);
            while (selectedElements.hasNext()) {
                selectionList.add(selectedElements.next());
            }
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)P2viewEditor.getString("_UI_FileConflict_label"), (String)P2viewEditor.getString("_WARN_FileConflict"));
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new AggregatorItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new P2viewItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                P2viewEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        P2viewEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            P2viewEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        if ((this).P2viewEditor.this.propertySheetPage != null && !(this).P2viewEditor.this.propertySheetPage.getControl().isDisposed()) {
                            (this).P2viewEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        P2viewEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (P2viewEditor.this.currentViewer != null) {
                        P2viewEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(P2viewEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(P2viewEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(P2viewEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    protected boolean showOutlineView() {
        return false;
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, P2viewEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.cbi.p2repo.aggregator.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    AggregatorEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        AggregatorEditorPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        }
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object getParent(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }
    }
}

