/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.engine;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import org.eclipse.cbi.p2repo.aggregator.ValidationSet;
import org.eclipse.cbi.p2repo.aggregator.engine.Builder;
import org.eclipse.cbi.p2repo.aggregator.engine.BuilderPhase;
import org.eclipse.cbi.p2repo.aggregator.engine.VerificationIUAction;
import org.eclipse.cbi.p2repo.util.LogUtils;
import org.eclipse.cbi.p2repo.util.MonitorUtils;
import org.eclipse.cbi.p2repo.util.TimeUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class VerificationIUGenerator
extends BuilderPhase {
    private ValidationSet validationSet;

    public VerificationIUGenerator(Builder builder, ValidationSet validationSet) {
        super(builder);
        this.validationSet = validationSet;
    }

    private IPublisherAction[] createActions(IMetadataRepository mdr) {
        return new IPublisherAction[]{new VerificationIUAction(this.getBuilder(), this.validationSet)};
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        long start;
        block8: {
            String taskLabel = Builder.getValidationSetLabel(this.validationSet);
            start = TimeUtils.getNow();
            MonitorUtils.begin((IProgressMonitor)monitor, (String)("Verifying Features for validationSet: " + taskLabel), (int)100);
            String info = "Starting generation of verification feature for validationSet: " + taskLabel;
            LogUtils.info((String)info, (Object[])new Object[0]);
            MonitorUtils.subTask((IProgressMonitor)monitor, (String)info);
            String name = this.getBuilder().getAggregation().getLabel();
            if (this.validationSet != null) {
                name = String.valueOf(name) + " / " + this.validationSet.getLabel();
            }
            name = String.valueOf(name) + " Verification repository";
            File globalLocation = new File(this.getBuilder().getBuildRoot(), "interim");
            File location = new File(globalLocation, "verification" + this.getBuilder().getValidationSetSubdirectory(this.validationSet));
            FileUtils.deleteAll((File)location);
            HashMap properties = new HashMap();
            URI locationURI = Builder.createURI(location);
            IMetadataRepositoryManager mdrMgr = this.getBuilder().getMdrManager();
            try {
                try {
                    mdrMgr.removeRepository(locationURI);
                    final IMetadataRepository mdr = mdrMgr.createRepository(locationURI, name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
                    final IStatus[] publishResult = new IStatus[]{Status.OK_STATUS};
                    mdr.executeBatch(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, OperationCanceledException {
                            PublisherInfo pubInfo = new PublisherInfo();
                            pubInfo.setMetadataRepository(mdr);
                            Publisher publisher = new Publisher((IPublisherInfo)pubInfo);
                            publishResult[0] = publisher.publish(VerificationIUGenerator.this.createActions(mdr), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                        }
                    }, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                    if (publishResult[0].getSeverity() == 4) {
                        throw new CoreException(publishResult[0]);
                    }
                    this.getBuilder().getSourceComposite(this.validationSet).addChild(mdr.getLocation());
                }
                catch (OperationCanceledException operationCanceledException) {
                    LogUtils.info((String)"Operation canceled.", (Object[])new Object[0]);
                    MonitorUtils.done((IProgressMonitor)monitor);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                MonitorUtils.done((IProgressMonitor)monitor);
                throw throwable;
            }
            MonitorUtils.done((IProgressMonitor)monitor);
        }
        if (!monitor.isCanceled()) {
            LogUtils.info((String)"Done. Took %s", (Object[])new Object[]{TimeUtils.getFormattedDuration((long)start)});
        }
    }
}

