/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.csd.identifier.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.csd.identifier.peak.AbstractPeakIdentifierCSD;
import org.eclipse.chemclipse.chromatogram.csd.identifier.settings.IPeakIdentifierSettingsCSD;
import org.eclipse.chemclipse.chromatogram.csd.identifier.settings.PeakIdentifierSettingsCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakIdentifierRemoveUnidentified<T>
extends AbstractPeakIdentifierCSD<T> {
    @Override
    public IProcessingInfo<T> identify(List<? extends IPeakCSD> peaks, IPeakIdentifierSettingsCSD peakIdentifierSettings, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        try {
            for (IPeakCSD iPeakCSD : peaks) {
                IChromatogramPeakCSD chromatogramPeakCSD;
                IChromatogramCSD chromatogramCSD;
                if (!(iPeakCSD instanceof IChromatogramPeakCSD) || (chromatogramCSD = (chromatogramPeakCSD = (IChromatogramPeakCSD)iPeakCSD).getChromatogram()) == null || chromatogramPeakCSD.getTargets().size() != 0) continue;
                chromatogramCSD.removePeak((IPeak)chromatogramPeakCSD);
            }
            processingInfo.addInfoMessage("Identifier", "Done - unidentified peaks have been removed.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            processingInfo.addErrorMessage("Identifier", "Something has gone wrong.");
        }
        return processingInfo;
    }

    @Override
    public IProcessingInfo<T> identify(IPeakCSD peak, IPeakIdentifierSettingsCSD peakIdentifierSettings, IProgressMonitor monitor) {
        ArrayList<IPeakCSD> peaks = new ArrayList<IPeakCSD>();
        peaks.add(peak);
        return this.identify(peaks, peakIdentifierSettings, monitor);
    }

    @Override
    public IProcessingInfo<T> identify(IPeakCSD peak, IProgressMonitor monitor) {
        PeakIdentifierSettingsCSD peakIdentifierSettings = new PeakIdentifierSettingsCSD();
        return this.identify(peak, (IPeakIdentifierSettingsCSD)peakIdentifierSettings, monitor);
    }

    @Override
    public IProcessingInfo<T> identify(List<? extends IPeakCSD> peaks, IProgressMonitor monitor) {
        PeakIdentifierSettingsCSD peakIdentifierSettings = new PeakIdentifierSettingsCSD();
        return this.identify(peaks, (IPeakIdentifierSettingsCSD)peakIdentifierSettings, monitor);
    }

    @Override
    public IProcessingInfo<T> identify(IChromatogramSelectionCSD chromatogramSelectionCSD, IProgressMonitor monitor) {
        PeakIdentifierSettingsCSD peakIdentifierSettings = new PeakIdentifierSettingsCSD();
        return this.identify(chromatogramSelectionCSD, (IPeakIdentifierSettingsCSD)peakIdentifierSettings, monitor);
    }

    @Override
    public IProcessingInfo<T> identify(IChromatogramSelectionCSD chromatogramSelectionCSD, IPeakIdentifierSettingsCSD peakIdentifierSettings, IProgressMonitor monitor) {
        IChromatogramCSD chromatogramCSD = (IChromatogramCSD)chromatogramSelectionCSD.getChromatogram();
        ArrayList<IChromatogramPeakCSD> peaks = new ArrayList<IChromatogramPeakCSD>();
        for (IChromatogramPeakCSD chromatogramPeakCSD : chromatogramCSD.getPeaks((IRetentionTimeRange)chromatogramSelectionCSD)) {
            peaks.add(chromatogramPeakCSD);
        }
        return this.identify(peaks, peakIdentifierSettings, monitor);
    }
}

